/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.SmapStratum;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JavaCompiler
extends Compiler {
    private final Log log = LogFactory.getLog(JavaCompiler.class);

    @Override
    protected void generateClass(Map<String, SmapStratum> smaps) throws JasperException, IOException {
        File javaFile;
        long t1 = 0L;
        if (this.log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        javax.tools.JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, Charset.forName(this.ctxt.getOptions().getJavaEncoding()));
        ArrayList<File> compilationUnitsList = new ArrayList<File>(1);
        compilationUnitsList.add(new File(this.ctxt.getServletJavaFileName()));
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Collections.unmodifiableList(compilationUnitsList));
        ArrayList<String> compilerOptionsList = new ArrayList<String>(6);
        compilerOptionsList.add("-classpath");
        compilerOptionsList.add(this.ctxt.getClassPath());
        compilerOptionsList.add("-source");
        compilerOptionsList.add(this.ctxt.getOptions().getCompilerSourceVM());
        compilerOptionsList.add("-target");
        compilerOptionsList.add(this.ctxt.getOptions().getCompilerTargetVM());
        List<String> compilerOptions = Collections.unmodifiableList(compilerOptionsList);
        Boolean result = compiler.getTask(null, fileManager, diagnostics, compilerOptions, null, compilationUnits).call();
        ArrayList<JavacErrorDetail> problemList = new ArrayList<JavacErrorDetail>();
        if (!result.booleanValue()) {
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                try {
                    problemList.add(ErrorDispatcher.createJavacError(((JavaFileObject)diagnostic.getSource()).getName(), this.pageNodes, new StringBuilder(diagnostic.getMessage(Locale.getDefault())), (int)diagnostic.getLineNumber(), this.ctxt));
                }
                catch (JasperException e) {
                    this.log.error(Localizer.getMessage("jsp.error.compilation.jdtProblemError"), e);
                }
            }
        }
        if (!this.ctxt.keepGenerated() && !(javaFile = new File(this.ctxt.getServletJavaFileName())).delete()) {
            throw new JasperException(Localizer.getMessage("jsp.warning.compiler.javafile.delete.fail", javaFile));
        }
        if (!problemList.isEmpty()) {
            JavacErrorDetail[] jeds = problemList.toArray(new JavacErrorDetail[0]);
            this.errDispatcher.javacError(jeds);
        }
        if (this.log.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            this.log.debug(Localizer.getMessage("jsp.compiled", this.ctxt.getServletJavaFileName(), t2 - t1));
        }
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(smaps);
        }
    }
}

