/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.maven.plugin;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jetty.ee8.maven.plugin.AbstractWebAppMojo;

@Mojo(name="stop")
public class JettyStopMojo
extends AbstractWebAppMojo {
    @Parameter
    protected int stopWait;

    @Override
    protected void startJettyEmbedded() throws MojoExecutionException {
    }

    @Override
    protected void startJettyForked() throws MojoExecutionException {
    }

    @Override
    protected void startJettyHome() throws MojoExecutionException {
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        block17: {
            if (this.stopPort <= 0) {
                throw new MojoExecutionException("Please specify a valid port");
            }
            if (this.stopKey == null) {
                throw new MojoExecutionException("Please specify a valid stopKey");
            }
            String command = "forcestop";
            if (this.stopWait > 0) {
                String response;
                Long pid = null;
                try {
                    response = this.send(this.stopKey + "\r\npid\r\n", this.stopWait);
                    pid = Long.valueOf(response);
                }
                catch (NumberFormatException e) {
                    this.getLog().info((CharSequence)"Server returned bad pid");
                }
                catch (ConnectException e) {
                    this.getLog().info((CharSequence)"Jetty not running!");
                    return;
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                }
                if (pid == null) {
                    try {
                        this.getLog().info((CharSequence)("Waiting " + this.stopWait + " seconds for jetty to stop"));
                        response = this.send(this.stopKey + "\r\n" + command + "\r\n", this.stopWait);
                        if ("Stopped".equals(response)) {
                            this.getLog().info((CharSequence)"Server reports itself as stopped");
                            break block17;
                        }
                        this.getLog().info((CharSequence)("Couldn't verify server as stopped, received " + response));
                    }
                    catch (ConnectException e) {
                        this.getLog().info((CharSequence)"Jetty not running!");
                    }
                    catch (Exception e) {
                        this.getLog().error((Throwable)e);
                    }
                } else {
                    this.getLog().info((CharSequence)("Waiting " + this.stopWait + " seconds for jetty " + pid + " to stop"));
                    Optional<ProcessHandle> optional = ProcessHandle.of(pid);
                    long remotePid = pid;
                    optional.ifPresentOrElse(p -> {
                        try {
                            if (ProcessHandle.current().pid() == remotePid) {
                                this.send(this.stopKey + "\r\n" + command + "\r\n", this.stopWait);
                            } else {
                                this.send(this.stopKey + "\r\n" + command + "\r\n", 0);
                                CompletableFuture<ProcessHandle> future = p.onExit();
                                if (p.isAlive()) {
                                    p = future.get(this.stopWait, TimeUnit.SECONDS);
                                }
                                if (p.isAlive()) {
                                    this.getLog().info((CharSequence)"Couldn't verify server process stop");
                                } else {
                                    this.getLog().info((CharSequence)"Server process stopped");
                                }
                            }
                        }
                        catch (ConnectException e) {
                            this.getLog().info((CharSequence)"Jetty not running!");
                        }
                        catch (TimeoutException e) {
                            this.getLog().error((CharSequence)"Timeout expired while waiting for server process to stop");
                        }
                        catch (Throwable e) {
                            this.getLog().error(e);
                        }
                    }, () -> this.getLog().info((CharSequence)"Process not running"));
                }
            } else {
                this.getLog().info((CharSequence)"Stopping jetty");
                try {
                    this.send(this.stopKey + "\r\n" + command + "\r\n", 0);
                }
                catch (ConnectException e) {
                    this.getLog().info((CharSequence)"Jetty not running!");
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                }
            }
        }
    }

    private String send(String command, int wait) throws Exception {
        String response = null;
        try (Socket s = new Socket(InetAddress.getByName("127.0.0.1"), this.stopPort);){
            String string;
            block20: {
                OutputStream out = s.getOutputStream();
                try {
                    out.write(command.getBytes());
                    out.flush();
                    if (wait > 0) {
                        s.setSoTimeout(wait * 1000);
                        try (LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));){
                            response = lin.readLine();
                        }
                    }
                    try {
                        s.setSoTimeout(1000);
                        s.getInputStream().read();
                    }
                    catch (Exception e) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().error((CharSequence)("Error after sending command: " + command + ". Check the server state."), (Throwable)e);
                        }
                        this.getLog().info((CharSequence)(e.getMessage() + " after sending command: " + command + ". Check the server state."));
                    }
                    string = response;
                    if (out == null) break block20;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out.close();
            }
            return string;
        }
    }
}

