/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.jaas.spi;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.jetty.ee8.jaas.JAASRole;
import org.eclipse.jetty.ee8.jaas.callback.ObjectCallback;
import org.eclipse.jetty.ee8.security.UserPrincipal;

public abstract class AbstractLoginModule
implements LoginModule {
    private CallbackHandler callbackHandler;
    private boolean authState = false;
    private boolean commitState = false;
    private JAASUser currentUser;
    private Subject subject;

    public abstract JAASUser getUser(String var1) throws Exception;

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject s) {
        this.subject = s;
    }

    public JAASUser getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(JAASUser u) {
        this.currentUser = u;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler h) {
        this.callbackHandler = h;
    }

    public boolean isAuthenticated() {
        return this.authState;
    }

    public boolean isCommitted() {
        return this.commitState;
    }

    public void setAuthenticated(boolean authState) {
        this.authState = authState;
    }

    public void setCommitted(boolean commitState) {
        this.commitState = commitState;
    }

    @Override
    public boolean abort() throws LoginException {
        this.currentUser = null;
        return this.isAuthenticated() && this.isCommitted();
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            this.currentUser = null;
            this.setCommitted(false);
            return false;
        }
        this.setCommitted(true);
        this.currentUser.setJAASInfo(this.subject);
        return true;
    }

    public Callback[] configureCallbacks() {
        Callback[] callbacks = new Callback[]{new NameCallback("Enter user name"), new ObjectCallback(), new PasswordCallback("Enter password", false)};
        return callbacks;
    }

    public boolean isIgnored() {
        return false;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            if (this.isIgnored()) {
                return false;
            }
            if (this.callbackHandler == null) {
                throw new LoginException("No callback handler");
            }
            Callback[] callbacks = this.configureCallbacks();
            this.callbackHandler.handle(callbacks);
            String webUserName = ((NameCallback)callbacks[0]).getName();
            Object webCredential = null;
            webCredential = ((ObjectCallback)callbacks[1]).getObject();
            if (webCredential == null) {
                webCredential = ((PasswordCallback)callbacks[2]).getPassword();
            }
            if (webUserName == null || webCredential == null) {
                this.setAuthenticated(false);
                throw new FailedLoginException();
            }
            JAASUser user = this.getUser(webUserName);
            if (user == null) {
                this.setAuthenticated(false);
                throw new FailedLoginException();
            }
            this.currentUser = user;
            this.setAuthenticated(this.currentUser.checkCredential(webCredential));
            if (this.isAuthenticated()) {
                this.currentUser.fetchRoles();
                return true;
            }
            throw new FailedLoginException();
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.toString());
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException(e.toString());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.currentUser.unsetJAASInfo(this.subject);
        this.currentUser = null;
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
    }

    public static abstract class JAASUser {
        private final UserPrincipal _user;
        private List<JAASRole> _roles;

        public JAASUser(UserPrincipal u) {
            this._user = u;
        }

        public String getUserName() {
            return this._user.getName();
        }

        public void setJAASInfo(Subject subject) {
            if (this._user == null) {
                return;
            }
            this._user.configureSubject(subject);
            if (this._roles != null) {
                subject.getPrincipals().addAll(this._roles);
            }
        }

        public void unsetJAASInfo(Subject subject) {
            if (this._user == null) {
                return;
            }
            this._user.deconfigureSubject(subject);
            if (this._roles != null) {
                subject.getPrincipals().removeAll(this._roles);
            }
        }

        public boolean checkCredential(Object suppliedCredential) {
            return this._user.authenticate(suppliedCredential);
        }

        public void fetchRoles() throws Exception {
            List<String> rolenames = this.doFetchRoles();
            if (rolenames != null) {
                this._roles = rolenames.stream().map(JAASRole::new).collect(Collectors.toList());
            }
        }

        public abstract List<String> doFetchRoles() throws Exception;
    }
}

