/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.common.messages;

import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.WrongMethodTypeException;
import java.util.List;
import org.eclipse.jetty.ee11.websocket.jakarta.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.messages.AbstractDecodedMessageSink;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.messages.MessageSink;
import org.eclipse.jetty.websocket.core.messages.ReaderMessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;

public class DecodedTextStreamMessageSink<T>
extends AbstractDecodedMessageSink.Stream<Decoder.TextStream<T>> {
    public DecodedTextStreamMessageSink(CoreSession session, MethodHolder methodHolder, List<RegisteredDecoder> decoders) {
        super(session, methodHolder, decoders);
    }

    @Override
    MessageSink newMessageSink(CoreSession coreSession) throws Exception {
        MethodHolder methodHolder = args -> {
            if (args.length != 1) {
                throw new WrongMethodTypeException(String.format("Expected %s params but had %s", 1, args.length));
            }
            this.onStreamStart((Reader)args[0]);
            return null;
        };
        return new ReaderMessageSink(coreSession, methodHolder, true);
    }

    public void onStreamStart(Reader reader) {
        try {
            Object obj = ((Decoder.TextStream)this._decoder).decode(reader);
            this.invoke(obj);
        }
        catch (DecodeException | IOException e) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", e);
        }
    }
}

