/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.osgi.boot;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.jetty.ee11.webapp.Configuration;
import org.eclipse.jetty.ee11.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.util.Util;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiMetaInfConfiguration
extends MetaInfConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiMetaInfConfiguration.class);
    public static final String SYS_PROP_TLD_BUNDLES = "org.eclipse.jetty.osgi.tldbundles";
    public static final String CONTAINER_BUNDLE_PATTERN = "org.eclipse.jetty.server.webapp.containerIncludeBundlePattern";
    public static final String FRAGMENT_AND_REQUIRED_BUNDLES = "org.eclipse.jetty.ee11.osgi.fragmentAndRequiredBundles";
    public static final String FRAGMENT_AND_REQUIRED_RESOURCES = "org.eclipse.jetty.ee11.osgi.fragmentAndRequiredResources";

    public Class<? extends Configuration> replaces() {
        return MetaInfConfiguration.class;
    }

    public void preConfigure(WebAppContext context) throws Exception {
        super.preConfigure(context);
    }

    protected void scanJars(WebAppContext context) throws Exception {
        String tmp = (String)context.getAttribute(CONTAINER_BUNDLE_PATTERN);
        Pattern pattern = tmp == null ? null : Pattern.compile(tmp);
        ArrayList<String> names = new ArrayList<String>();
        tmp = System.getProperty(SYS_PROP_TLD_BUNDLES);
        if (tmp != null) {
            StringTokenizer tokenizer = new StringTokenizer(tmp, ", \n\r\t", false);
            while (tokenizer.hasMoreTokens()) {
                names.add(tokenizer.nextToken());
            }
        }
        HashSet<Resource> matchingResources = new HashSet<Resource>();
        if (!names.isEmpty() || pattern != null) {
            Bundle[] bundles;
            for (Bundle bundle : bundles = FrameworkUtil.getBundle(OSGiMetaInfConfiguration.class).getBundleContext().getBundles()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Checking bundle {}:{}", (Object)bundle.getBundleId(), (Object)bundle.getSymbolicName());
                }
                if (pattern != null && pattern.matcher(bundle.getSymbolicName()).matches()) {
                    matchingResources.addAll(this.getBundleAsResource(ResourceFactory.of((Container)context), bundle));
                }
                if (names == null || !names.contains(bundle.getSymbolicName())) continue;
                matchingResources.addAll(this.getBundleAsResource(ResourceFactory.of((Container)context), bundle));
            }
        }
        for (Resource r : matchingResources) {
            context.getMetaData().addContainerResource(r);
        }
        super.scanJars(context);
    }

    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(FRAGMENT_AND_REQUIRED_BUNDLES, null);
        context.setAttribute(FRAGMENT_AND_REQUIRED_RESOURCES, null);
        super.postConfigure(context);
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        Bundle[] bundles;
        ArrayList<Resource> mergedResources = new ArrayList<Resource>();
        List webInfJars = super.findJars(context);
        if (webInfJars != null) {
            mergedResources.addAll(webInfJars);
        }
        if ((bundles = Util.getFragmentsAndRequiredBundles((BundleContext)((BundleContext)context.getAttribute("Jetty-Boot-Bundle-Context")), (Bundle)((Bundle)context.getAttribute("osgi-bundle")))) != null && bundles.length > 0) {
            HashSet<Resource> fragsAndReqsResources;
            HashSet<Bundle> fragsAndReqsBundles = (HashSet<Bundle>)context.getAttribute(FRAGMENT_AND_REQUIRED_BUNDLES);
            if (fragsAndReqsBundles == null) {
                fragsAndReqsBundles = new HashSet<Bundle>();
                context.setAttribute(FRAGMENT_AND_REQUIRED_BUNDLES, fragsAndReqsBundles);
            }
            if ((fragsAndReqsResources = (HashSet<Resource>)context.getAttribute(FRAGMENT_AND_REQUIRED_RESOURCES)) == null) {
                fragsAndReqsResources = new HashSet<Resource>();
                context.setAttribute(FRAGMENT_AND_REQUIRED_RESOURCES, fragsAndReqsResources);
            }
            for (Bundle b : bundles) {
                if (b.getState() == 1) continue;
                fragsAndReqsBundles.add(b);
                File f = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(b);
                Resource r = ResourceFactory.of((Container)context).newResource(f.toURI());
                fragsAndReqsResources.add(r);
                mergedResources.add(r);
            }
        }
        return mergedResources;
    }

    public void configure(WebAppContext context) throws Exception {
        Set fragments;
        TreeMap<String, Resource> prependedResourcesPath = new TreeMap<String, Resource>();
        TreeMap<String, Resource> appendedResourcesPath = new TreeMap<String, Resource>();
        Bundle bundle = (Bundle)context.getAttribute("osgi-bundle");
        if (bundle != null && (fragments = (Set)context.getAttribute(FRAGMENT_AND_REQUIRED_BUNDLES)) != null && !fragments.isEmpty()) {
            for (Bundle frag : fragments) {
                String path = Util.getManifestHeaderValue((String)"Jetty-WarFragmentResourcePath", (Dictionary)frag.getHeaders());
                this.convertFragmentPathToResource(ResourceFactory.of((Container)context), path, frag, appendedResourcesPath);
                path = Util.getManifestHeaderValue((String)"Jetty-WarPrependFragmentResourcePath", (Dictionary)frag.getHeaders());
                this.convertFragmentPathToResource(ResourceFactory.of((Container)context), path, frag, prependedResourcesPath);
            }
            if (!appendedResourcesPath.isEmpty()) {
                LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
                Set resourceDirs = (Set)context.getAttribute("org.eclipse.jetty.resources");
                if (resourceDirs != null && !resourceDirs.isEmpty()) {
                    resources.addAll(resourceDirs);
                }
                resources.addAll(appendedResourcesPath.values());
                context.setAttribute("org.eclipse.jetty.resources", resources);
            }
        }
        super.configure(context);
        if (!prependedResourcesPath.isEmpty()) {
            Resource[] resources = new Resource[1 + prependedResourcesPath.size()];
            System.arraycopy(prependedResourcesPath.values().toArray(new Resource[prependedResourcesPath.size()]), 0, resources, 0, prependedResourcesPath.size());
            resources[resources.length - 1] = context.getBaseResource();
            context.setBaseResource(ResourceFactory.combine((Resource[])resources));
        }
    }

    private List<Resource> getBundleAsResource(ResourceFactory resourceFactory, Bundle bundle) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        File file = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (FileID.isJavaArchive((String)f.getName()) && f.isFile()) {
                    resources.add(resourceFactory.newResource(f.toPath()));
                    continue;
                }
                if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                for (File f2 : file.listFiles()) {
                    if (!FileID.isJavaArchive((String)f2.getName()) || !f2.isFile()) continue;
                    resources.add(resourceFactory.newResource(f.toPath()));
                }
            }
            resources.add(resourceFactory.newResource(file.toPath()));
        } else {
            resources.add(resourceFactory.newResource(file.toPath()));
        }
        return resources;
    }

    private void convertFragmentPathToResource(ResourceFactory resourceFactory, String resourcePath, Bundle fragment, Map<String, Resource> resourceMap) throws Exception {
        URI uri;
        if (resourcePath == null) {
            return;
        }
        URL url = fragment.getEntry(resourcePath);
        if (url == null) {
            throw new IllegalArgumentException("Unable to locate " + resourcePath + " inside the fragment '" + fragment.getSymbolicName() + "'");
        }
        url = BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(url);
        String key = resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            uri = new URI(url.toString().replaceAll(" ", "%20"));
        }
        resourceMap.put(key + ";" + fragment.getSymbolicName(), resourceFactory.newResource(uri));
    }
}

