/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.messages;

import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.exception.BadPayloadException;
import org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;

public class StringMessageSink
extends AbstractMessageSink {
    private Utf8StringBuilder out;
    private int size = 0;

    public StringMessageSink(CoreSession session, MethodHolder methodHolder, boolean autoDemand) {
        super(session, methodHolder, autoDemand);
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            this.size += frame.getPayloadLength();
            long maxSize = this.getCoreSession().getMaxTextMessageSize();
            if (maxSize > 0L && (long)this.size > maxSize) {
                callback.failed(new MessageTooLargeException(String.format("Text message too large: %,d > %,d", this.size, maxSize)));
                return;
            }
            if (this.out == null) {
                this.out = new Utf8StringBuilder(this.getCoreSession().getInputBufferSize());
            }
            this.out.append(frame.getPayload());
            if (frame.isFin()) {
                this.getMethodHolder().invoke(this.out.takeCompleteString(BadPayloadException.InvalidUtf8::new));
                this.reset();
                callback.succeeded();
                this.autoDemand();
            } else {
                callback.succeeded();
                this.getCoreSession().demand();
            }
        }
        catch (Throwable t) {
            this.reset();
            callback.failed(t);
        }
    }

    @Override
    public void fail(Throwable failure) {
        this.reset();
    }

    private void reset() {
        this.out = null;
        this.size = 0;
    }
}

