/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Objects;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.internal.HttpConnection;
import org.eclipse.jetty.util.annotation.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionFactory
extends AbstractConnectionFactory
implements HttpConfiguration.ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectionFactory.class);
    private final HttpConfiguration _config;
    private boolean _useInputDirectByteBuffers;
    private boolean _useOutputDirectByteBuffers;

    public HttpConnectionFactory() {
        this(new HttpConfiguration());
    }

    public HttpConnectionFactory(@Name(value="config") HttpConfiguration config) {
        super(HttpVersion.HTTP_1_1.asString());
        this._config = Objects.requireNonNull(config);
        this.installBean(this._config);
        this.setUseInputDirectByteBuffers(this._config.isUseInputDirectByteBuffers());
        this.setUseOutputDirectByteBuffers(this._config.isUseOutputDirectByteBuffers());
        this.setInputBufferSize(this._config.getInputBufferSize());
    }

    @Override
    public void setInputBufferSize(int size) {
        super.setInputBufferSize(size);
        this._config.setInputBufferSize(size);
    }

    @Override
    public int getInputBufferSize() {
        return this._config.getInputBufferSize();
    }

    @Override
    public HttpConfiguration getHttpConfiguration() {
        return this._config;
    }

    @Deprecated(since="12.0.6", forRemoval=true)
    public boolean isRecordHttpComplianceViolations() {
        return !this._config.getComplianceViolationListeners().isEmpty();
    }

    @Deprecated(since="12.0.6", forRemoval=true)
    public void setRecordHttpComplianceViolations(boolean recordHttpComplianceViolations) {
        this._config.addComplianceViolationListener(new ComplianceViolation.LoggingListener());
    }

    public boolean isUseInputDirectByteBuffers() {
        return this._useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this._useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this._useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this._useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        HttpConnection connection = new HttpConnection(this._config, connector, endPoint);
        connection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
        connection.setUseOutputDirectByteBuffers(this.isUseOutputDirectByteBuffers());
        return this.configure(connection, connector, endPoint);
    }
}

