/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.ByteChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.content.BufferedContentSink;
import org.eclipse.jetty.io.content.ByteBufferContentSource;
import org.eclipse.jetty.io.content.ContentSinkOutputStream;
import org.eclipse.jetty.io.content.ContentSinkSubscriber;
import org.eclipse.jetty.io.content.ContentSourceInputStream;
import org.eclipse.jetty.io.content.ContentSourcePublisher;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.io.internal.ByteBufferChunk;
import org.eclipse.jetty.io.internal.ByteChannelContentSource;
import org.eclipse.jetty.io.internal.ContentCopier;
import org.eclipse.jetty.io.internal.ContentSourceByteBuffer;
import org.eclipse.jetty.io.internal.ContentSourceConsumer;
import org.eclipse.jetty.io.internal.ContentSourceRetainableByteBuffer;
import org.eclipse.jetty.io.internal.ContentSourceString;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Content {
    private static final Logger LOG = LoggerFactory.getLogger(Content.class);

    private Content() {
    }

    public static void copy(Source source, Sink sink, Callback callback) {
        Content.copy(source, sink, null, callback);
    }

    public static void copy(Source source, Sink sink, Chunk.Processor chunkProcessor, Callback callback) {
        new ContentCopier(source, sink, chunkProcessor, callback).iterate();
    }

    public static interface Source {
        public static Source from(ByteBuffer ... byteBuffers) {
            return new ByteBufferContentSource(byteBuffers);
        }

        public static Source from(Path path) {
            return Source.from(null, path, 0L, -1L);
        }

        public static Source from(Path path, long offset, long length) {
            return Source.from(null, path, offset, length);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, Path path) {
            return Source.from(byteBufferPool, path, 0L, -1L);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, Path path, long offset, long length) {
            return new ByteChannelContentSource.PathContentSource(byteBufferPool, path, offset, length);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, ByteChannel byteChannel) {
            return new ByteChannelContentSource(byteBufferPool, byteChannel);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, SeekableByteChannel seekableByteChannel, long offset, long length) {
            return new ByteChannelContentSource(byteBufferPool, seekableByteChannel, offset, length);
        }

        public static Source from(InputStream inputStream) {
            return Source.from(null, inputStream);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, InputStream inputStream) {
            return new InputStreamContentSource(inputStream, byteBufferPool);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, InputStream inputStream, long offset, long length) {
            return new InputStreamContentSource(inputStream, byteBufferPool, offset, length);
        }

        public static void asByteBuffer(Source source, Promise<ByteBuffer> promise) {
            new ContentSourceByteBuffer(source, promise).run();
        }

        public static ByteBuffer asByteBuffer(Source source) throws IOException {
            Blocker.Promise<ByteBuffer> promise = Blocker.promise();
            try {
                Source.asByteBuffer(source, promise);
                ByteBuffer byteBuffer = promise.block();
                if (promise != null) {
                    promise.close();
                }
                return byteBuffer;
            }
            catch (Throwable throwable) {
                try {
                    if (promise != null) {
                        try {
                            promise.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable x) {
                    throw IO.rethrow(x);
                }
            }
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<byte[]> asByteArrayAsync(Source source, int maxSize) {
            return Source.asRetainableByteBuffer(source, null, false, maxSize).thenApply(rbb -> {
                int remaining = rbb.remaining();
                byte[] bytes = new byte[remaining];
                rbb.get(bytes, 0, remaining);
                return bytes;
            });
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<ByteBuffer> asByteBufferAsync(Source source) {
            return Source.asByteBufferAsync(source, -1);
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<ByteBuffer> asByteBufferAsync(Source source, int maxSize) {
            return Source.asRetainableByteBuffer(source, null, false, maxSize).thenApply(rbb -> {
                ByteBuffer byteBuffer = rbb.getByteBuffer();
                rbb.release();
                return byteBuffer;
            });
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<RetainableByteBuffer> asRetainableByteBuffer(Source source, ByteBufferPool pool, boolean direct, int maxSize) {
            Promise.Completable<RetainableByteBuffer> promise = new Promise.Completable<RetainableByteBuffer>(){

                @Override
                public void succeeded(RetainableByteBuffer result) {
                    result.retain();
                    super.succeeded(result);
                }
            };
            Source.asRetainableByteBuffer(source, pool, direct, maxSize, (Promise<RetainableByteBuffer>)promise);
            return promise;
        }

        public static void asRetainableByteBuffer(Source source, ByteBufferPool pool, boolean direct, int maxSize, Promise<RetainableByteBuffer> promise) {
            new ContentSourceRetainableByteBuffer(source, pool, direct, maxSize, promise).run();
        }

        public static void asString(Source source, Charset charset, Promise<String> promise) {
            new ContentSourceString(source, charset, promise).convert();
        }

        public static String asString(Source source) throws IOException {
            return Source.asString(source, StandardCharsets.UTF_8);
        }

        public static String asString(Source source, Charset charset) throws IOException {
            Blocker.Promise<String> promise = Blocker.promise();
            try {
                Source.asString(source, charset, promise);
                String string = promise.block();
                if (promise != null) {
                    promise.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (promise != null) {
                        try {
                            promise.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable x) {
                    throw IO.rethrow(x);
                }
            }
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<String> asStringAsync(Source source, Charset charset) {
            Promise.Completable<String> completable = new Promise.Completable<String>();
            Source.asString(source, charset, completable);
            return completable;
        }

        public static InputStream asInputStream(Source source) {
            return new ContentSourceInputStream(source);
        }

        public static Flow.Publisher<Chunk> asPublisher(Source source) {
            return new ContentSourcePublisher(source);
        }

        public static void consumeAll(Source source, Callback callback) {
            new ContentSourceConsumer(source, callback).run();
        }

        public static void consumeAll(Source source) throws IOException {
            try (Blocker.Callback callback = Blocker.callback();){
                Source.consumeAll(source, callback);
                callback.block();
            }
            catch (Throwable x) {
                throw IO.rethrow(x);
            }
        }

        default public long getLength() {
            return -1L;
        }

        public Chunk read();

        public void demand(Runnable var1);

        public void fail(Throwable var1);

        default public void fail(Throwable failure, boolean last) {
            this.fail(failure);
        }

        default public boolean rewind() {
            return false;
        }
    }

    public static interface Sink {
        public static Sink from(final OutputStream out) {
            return new Sink(){
                boolean closed;

                @Override
                public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
                    if (this.closed) {
                        callback.failed(new EOFException());
                        return;
                    }
                    try {
                        BufferUtil.writeTo(byteBuffer, out);
                        if (last) {
                            this.closed = true;
                            out.close();
                        }
                        callback.succeeded();
                    }
                    catch (Throwable t) {
                        callback.failed(t);
                    }
                }
            };
        }

        public static Sink from(final ByteChannel channel) {
            return new Sink(){
                boolean closed;

                @Override
                public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
                    if (this.closed) {
                        callback.failed(new EOFException());
                        return;
                    }
                    try {
                        int remaining = byteBuffer.remaining();
                        int tries = 0;
                        while (remaining > 0) {
                            int written = channel.write(byteBuffer);
                            if (written > 0) {
                                remaining -= written;
                                continue;
                            }
                            if (tries++ <= 2) continue;
                            throw new IllegalStateException("ByteChannel in async mode");
                        }
                        if (last) {
                            this.closed = true;
                            channel.close();
                        }
                        callback.succeeded();
                    }
                    catch (Throwable t) {
                        callback.failed(t);
                    }
                }
            };
        }

        public static Sink from(final AsynchronousByteChannel channel) {
            return new Sink(){
                boolean closed;

                @Override
                public void write(final boolean last, ByteBuffer byteBuffer, final Callback callback) {
                    if (this.closed) {
                        callback.failed(new EOFException());
                        return;
                    }
                    try {
                        channel.write(byteBuffer, byteBuffer, new CompletionHandler<Integer, ByteBuffer>(this){
                            final /* synthetic */ 3 this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void completed(Integer written, ByteBuffer buffer) {
                                if (buffer.hasRemaining()) {
                                    this.this$0.channel.write(buffer, buffer, this);
                                } else {
                                    if (last) {
                                        this.this$0.closed = true;
                                        IO.close(this.this$0.channel);
                                    }
                                    callback.succeeded();
                                }
                            }

                            @Override
                            public void failed(Throwable x, ByteBuffer buffer) {
                                callback.failed(x);
                            }
                        });
                    }
                    catch (Throwable t) {
                        callback.failed(t);
                    }
                }
            };
        }

        public static Sink asBuffered(Sink sink, ByteBufferPool bufferPool, boolean direct, int maxAggregationSize, int maxBufferSize) {
            return new BufferedContentSink(sink, bufferPool, direct, maxAggregationSize, maxBufferSize);
        }

        public static OutputStream asOutputStream(Sink sink) {
            return new ContentSinkOutputStream(sink);
        }

        public static Flow.Subscriber<Chunk> asSubscriber(Sink sink, Callback callback) {
            return new ContentSinkSubscriber(sink, callback);
        }

        public static void write(Sink sink, boolean last, ByteBuffer byteBuffer) throws IOException {
            try (Blocker.Callback callback = Blocker.callback();){
                sink.write(last, byteBuffer, callback);
                callback.block();
            }
        }

        public static void write(Sink sink, boolean last, String utf8Content, Callback callback) {
            sink.write(last, StandardCharsets.UTF_8.encode(utf8Content), callback);
        }

        public void write(boolean var1, ByteBuffer var2, Callback var3);
    }

    public static interface Chunk
    extends RetainableByteBuffer {
        public static final Chunk EMPTY = new Empty(){

            @Override
            public boolean isLast() {
                return false;
            }

            public String toString() {
                return "EMPTY";
            }
        };
        public static final Chunk EOF = new Empty(){

            @Override
            public boolean isLast() {
                return true;
            }

            public String toString() {
                return "EOF";
            }
        };

        public static Chunk from(ByteBuffer byteBuffer, boolean last) {
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.WithReferenceCount(byteBuffer, last);
            }
            return last ? EOF : EMPTY;
        }

        public static Chunk from(ByteBuffer byteBuffer, boolean last, Runnable releaser) {
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.ReleasedByRunnable(byteBuffer, last, Objects.requireNonNull(releaser));
            }
            releaser.run();
            return last ? EOF : EMPTY;
        }

        public static Chunk from(ByteBuffer byteBuffer, boolean last, Consumer<ByteBuffer> releaser) {
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.ReleasedByConsumer(byteBuffer, last, Objects.requireNonNull(releaser));
            }
            releaser.accept(byteBuffer);
            return last ? EOF : EMPTY;
        }

        public static Chunk asChunk(ByteBuffer byteBuffer, boolean last, Retainable retainable) {
            if (byteBuffer.hasRemaining()) {
                if (retainable.canRetain()) {
                    return new ByteBufferChunk.WithRetainable(byteBuffer, last, Objects.requireNonNull(retainable));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Copying buffer because could not retain");
                }
                return new ByteBufferChunk.WithReferenceCount(BufferUtil.copy(byteBuffer), last);
            }
            retainable.release();
            return last ? EOF : EMPTY;
        }

        public static Chunk from(Throwable failure) {
            return Chunk.from(failure, true);
        }

        public static Chunk from(final Throwable failure, final boolean last) {
            return new Empty(){

                @Override
                public Throwable getFailure() {
                    return failure;
                }

                @Override
                public boolean isLast() {
                    return last;
                }

                public String toString() {
                    return String.format("Chunk@%x{c=%s,l=%b}", this.hashCode(), failure, last);
                }
            };
        }

        public static Chunk next(Chunk chunk) {
            if (chunk == null) {
                return null;
            }
            if (Chunk.isFailure(chunk)) {
                return chunk.isLast() ? chunk : null;
            }
            if (chunk.isLast()) {
                return EOF;
            }
            return null;
        }

        public static Chunk releaseAndNext(Chunk chunk) {
            if (chunk == null) {
                return null;
            }
            chunk.release();
            return Chunk.next(chunk);
        }

        public static boolean isFailure(Chunk chunk) {
            return chunk != null && chunk.getFailure() != null;
        }

        public static boolean isFailure(Chunk chunk, boolean last) {
            return chunk != null && chunk.getFailure() != null && chunk.isLast() == last;
        }

        default public Throwable getFailure() {
            return null;
        }

        public boolean isLast();

        @Deprecated(forRemoval=true, since="12.1.0")
        default public Chunk asReadOnly() {
            if (!this.getByteBuffer().hasRemaining() || this.getByteBuffer().isReadOnly()) {
                return this;
            }
            if (this.canRetain()) {
                return Chunk.asChunk(this.getByteBuffer().asReadOnlyBuffer(), this.isLast(), this);
            }
            return Chunk.from(this.getByteBuffer().asReadOnlyBuffer(), this.isLast());
        }

        public static interface Processor {
            public boolean process(Chunk var1, Callback var2);
        }

        public static abstract class Empty
        implements Chunk {
            protected Empty() {
            }

            @Override
            public ByteBuffer getByteBuffer() {
                return BufferUtil.EMPTY_BUFFER;
            }

            @Override
            public RetainableByteBuffer slice(long length) {
                return this;
            }
        }
    }
}

