/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.maven.plugin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.ee11.maven.plugin.MavenQuickStartConfiguration;
import org.eclipse.jetty.ee11.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.ee11.maven.plugin.WebAppPropertyConverter;
import org.eclipse.jetty.ee11.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.ee11.servlet.ServletHandler;
import org.eclipse.jetty.ee11.webapp.Configuration;
import org.eclipse.jetty.ee11.webapp.Configurations;
import org.eclipse.jetty.maven.AbstractJettyEmbedder;
import org.eclipse.jetty.maven.ServerSupport;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;

public class JettyEmbedder
extends AbstractJettyEmbedder {
    protected MavenWebAppContext webApp;

    public List<ContextHandler> getContextHandlers() {
        return this.contextHandlers;
    }

    public void setWebApp(MavenWebAppContext app) {
        this.webApp = app;
    }

    protected void redeployWebApp() throws Exception {
        this.stopWebApp();
        this.webApp.setServletHandler(new ServletHandler());
        this.applyWebAppProperties();
        this.webApp.start();
    }

    public void stopWebApp() throws Exception {
        if (this.webApp != null && !this.webApp.isStopped()) {
            this.webApp.stop();
        }
    }

    public void configureWebApp() throws Exception {
        Path qs;
        Configurations.setServerDefault((Server)this.server);
        if (this.webApp == null) {
            this.webApp = new MavenWebAppContext();
        }
        this.applyWebAppProperties();
        if (this.webApp.getTempDirectory() != null && Files.exists(qs = this.webApp.getTempDirectory().toPath().resolve("quickstart-web.xml"), new LinkOption[0]) && Files.isRegularFile(qs, new LinkOption[0])) {
            this.webApp.addConfiguration(new Configuration[]{new MavenQuickStartConfiguration()});
            this.webApp.setAttribute("org.eclipse.jetty.quickstart.xml", qs);
            this.webApp.setAttribute("org.eclipse.jetty.quickstart.mode", QuickStartConfiguration.Mode.QUICKSTART);
        }
    }

    public void applyWebAppProperties() throws Exception {
        super.applyWebAppProperties();
        WebAppPropertyConverter.fromProperties(this.webApp, this.webAppProperties, this.server, (Map<String, String>)this.jettyProperties);
    }

    public void addWebAppToServer() throws Exception {
        ServerSupport.addWebApplication((Server)this.server, (ContextHandler)this.webApp);
    }
}

