/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.maven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jetty.ee11.maven.plugin.AbstractUnassembledWebAppMojo;
import org.eclipse.jetty.ee11.maven.plugin.QuickStartGenerator;

@Mojo(name="effective-web-xml", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JettyEffectiveWebXml
extends AbstractUnassembledWebAppMojo {
    @Parameter(defaultValue="${project.build.directory}/effective-web.xml")
    protected File effectiveWebXml;

    @Override
    public void configureWebApp() throws Exception {
        String war = this.webApp.getWar();
        Path path = null;
        if (war != null) {
            try {
                URL url = new URL(war);
                path = Paths.get(url.toURI());
            }
            catch (MalformedURLException e) {
                path = Paths.get(war, new String[0]);
            }
        }
        Path start = path.getName(0);
        int count = path.getNameCount();
        Path end = path.getName(count > 0 ? count - 1 : count);
        if (start.startsWith("src") || !end.toString().endsWith(".war")) {
            super.configureUnassembledWebApp();
        }
    }

    @Override
    protected void configureUnassembledWebApp() {
    }

    @Override
    protected void startJettyEmbedded() throws MojoExecutionException {
        this.generate();
    }

    @Override
    protected void startJettyForked() throws MojoExecutionException {
        this.generate();
    }

    @Override
    protected void startJettyHome() throws MojoExecutionException {
        this.generate();
    }

    private void generate() throws MojoExecutionException {
        try {
            QuickStartGenerator generator = new QuickStartGenerator(this.effectiveWebXml.toPath(), this.webApp);
            generator.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating effective web xml", e);
        }
    }
}

