/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.ee11.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.ee11.webapp.Configuration;
import org.eclipse.jetty.ee11.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenMetaInfConfiguration
extends MetaInfConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MavenMetaInfConfiguration.class);
    protected static int COUNTER = 0;

    public Class<? extends Configuration> replaces() {
        return MetaInfConfiguration.class;
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        List superList;
        ArrayList<Resource> list = new ArrayList<Resource>();
        MavenWebAppContext jwac = (MavenWebAppContext)context;
        List<File> files = jwac.getWebInfLib();
        if (files != null) {
            files.forEach(file -> {
                if (FileID.isJavaArchive((String)file.getName()) || file.isDirectory()) {
                    try {
                        LOG.debug(" add  resource to resources to examine {}", file);
                        list.add(context.getResourceFactory().newResource(file.toURI()));
                    }
                    catch (Exception e) {
                        LOG.warn("Bad url ", (Throwable)e);
                    }
                }
            });
        }
        if ((superList = super.findJars(context)) != null) {
            list.addAll(superList);
        }
        return list;
    }

    protected List<Resource> findClassDirs(WebAppContext context) throws Exception {
        List classesDirs;
        ArrayList<Resource> list = new ArrayList<Resource>();
        MavenWebAppContext jwac = (MavenWebAppContext)context;
        List<File> files = jwac.getWebInfClasses();
        if (files != null) {
            files.forEach(file -> {
                if (file.exists() && file.isDirectory()) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Add file {}", (Object)file.toURI());
                        }
                        list.add(context.getResourceFactory().newResource(file.toURI()));
                    }
                    catch (Exception e) {
                        LOG.warn("Bad url ", (Throwable)e);
                    }
                }
            });
        }
        if ((classesDirs = super.findClassDirs(context)) != null) {
            list.addAll(classesDirs);
        }
        return list;
    }
}

