/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.common;

import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import org.eclipse.jetty.ee10.websocket.api.CloseStatus;
import org.eclipse.jetty.ee10.websocket.api.Session;
import org.eclipse.jetty.ee10.websocket.api.SuspendToken;
import org.eclipse.jetty.ee10.websocket.api.UpgradeRequest;
import org.eclipse.jetty.ee10.websocket.api.UpgradeResponse;
import org.eclipse.jetty.ee10.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.ee10.websocket.api.WebSocketContainer;
import org.eclipse.jetty.ee10.websocket.api.WriteCallback;
import org.eclipse.jetty.ee10.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.ee10.websocket.common.JettyWebSocketRemoteEndpoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketSession
implements Session,
SuspendToken,
Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketSession.class);
    private final CoreSession coreSession;
    private final JettyWebSocketFrameHandler frameHandler;
    private final JettyWebSocketRemoteEndpoint remoteEndpoint;
    private final UpgradeRequest upgradeRequest;
    private final UpgradeResponse upgradeResponse;

    public WebSocketSession(WebSocketContainer container, CoreSession coreSession, JettyWebSocketFrameHandler frameHandler) {
        this.frameHandler = Objects.requireNonNull(frameHandler);
        this.coreSession = Objects.requireNonNull(coreSession);
        this.upgradeRequest = frameHandler.getUpgradeRequest();
        this.upgradeResponse = frameHandler.getUpgradeResponse();
        this.remoteEndpoint = new JettyWebSocketRemoteEndpoint(coreSession, frameHandler.getBatchMode());
        container.notifySessionListeners(listener -> listener.onWebSocketSessionCreated((Session)this));
    }

    public void close() {
        this.coreSession.close(1000, null, Callback.NOOP);
    }

    public void close(CloseStatus closeStatus) {
        this.coreSession.close(closeStatus.getCode(), closeStatus.getPhrase(), Callback.NOOP);
    }

    public void close(int statusCode, String reason) {
        this.coreSession.close(statusCode, reason, Callback.NOOP);
    }

    public void close(int statusCode, String reason, WriteCallback callback) {
        this.coreSession.close(statusCode, reason, Callback.from(() -> ((WriteCallback)callback).writeSuccess(), arg_0 -> ((WriteCallback)callback).writeFailed(arg_0)));
    }

    public WebSocketBehavior getBehavior() {
        switch (this.coreSession.getBehavior()) {
            case CLIENT: {
                return WebSocketBehavior.CLIENT;
            }
            case SERVER: {
                return WebSocketBehavior.SERVER;
            }
        }
        return null;
    }

    public Duration getIdleTimeout() {
        return this.coreSession.getIdleTimeout();
    }

    public int getInputBufferSize() {
        return this.coreSession.getInputBufferSize();
    }

    public int getOutputBufferSize() {
        return this.coreSession.getOutputBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.coreSession.getMaxBinaryMessageSize();
    }

    public long getMaxTextMessageSize() {
        return this.coreSession.getMaxTextMessageSize();
    }

    public long getMaxFrameSize() {
        return this.coreSession.getMaxFrameSize();
    }

    public boolean isAutoFragment() {
        return this.coreSession.isAutoFragment();
    }

    public void setIdleTimeout(Duration duration) {
        this.coreSession.setIdleTimeout(duration);
    }

    public void setInputBufferSize(int size) {
        this.coreSession.setInputBufferSize(size);
    }

    public void setOutputBufferSize(int size) {
        this.coreSession.setOutputBufferSize(size);
    }

    public void setMaxBinaryMessageSize(long size) {
        this.coreSession.setMaxBinaryMessageSize(size);
    }

    public void setMaxTextMessageSize(long size) {
        this.coreSession.setMaxTextMessageSize(size);
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.coreSession.setMaxFrameSize(maxFrameSize);
    }

    public void setAutoFragment(boolean autoFragment) {
        this.coreSession.setAutoFragment(autoFragment);
    }

    public String getProtocolVersion() {
        return this.upgradeRequest.getProtocolVersion();
    }

    public JettyWebSocketRemoteEndpoint getRemote() {
        return this.remoteEndpoint;
    }

    public boolean isOpen() {
        return this.coreSession.isOutputOpen();
    }

    public boolean isSecure() {
        return this.upgradeRequest.isSecure();
    }

    public void disconnect() {
        this.coreSession.abort();
    }

    public SocketAddress getLocalAddress() {
        return this.coreSession.getLocalAddress();
    }

    public SocketAddress getRemoteAddress() {
        return this.coreSession.getRemoteAddress();
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    public SuspendToken suspend() {
        this.frameHandler.suspend();
        return this;
    }

    public void resume() {
        this.frameHandler.resume();
    }

    public CoreSession getCoreSession() {
        return this.coreSession;
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{this.upgradeRequest, this.coreSession, this.remoteEndpoint, this.frameHandler});
    }

    public String dumpSelf() {
        return String.format("%s@%x[behavior=%s,idleTimeout=%dms]", this.getClass().getSimpleName(), this.hashCode(), this.getPolicy().getBehavior(), this.getIdleTimeout().toMillis());
    }

    public String toString() {
        return String.format("WebSocketSession[%s,to=%s,%s,%s]", this.getBehavior(), this.getIdleTimeout(), this.coreSession, this.frameHandler);
    }
}

