/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.osgi.boot;

import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jetty.ee.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.Configurations;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.osgi.AbstractContextProvider;
import org.eclipse.jetty.osgi.AbstractEEActivator;
import org.eclipse.jetty.osgi.BundleMetadata;
import org.eclipse.jetty.osgi.ContextFactory;
import org.eclipse.jetty.osgi.OSGiWebappClassLoader;
import org.eclipse.jetty.osgi.OSGiWebappConstants;
import org.eclipse.jetty.osgi.util.OSGiClassLoader;
import org.eclipse.jetty.osgi.util.Util;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EE10Activator
extends AbstractEEActivator {
    private static final Logger LOG = LoggerFactory.getLogger(EE10Activator.class);
    public static final String ENVIRONMENT = "ee10";

    public ContextFactory newContextFactory(Bundle bundle) {
        return new EE10ContextFactory(bundle);
    }

    public String getEnvironment() {
        return ENVIRONMENT;
    }

    public String getMetaInfContainerBundlePatternAttributeName() {
        return "org.eclipse.jetty.server.webapp.containerIncludeBundlePattern";
    }

    public ContextFactory newWebAppFactory(Bundle bundle) {
        return new EE10WebAppFactory(bundle);
    }

    public class EE10ContextFactory
    implements ContextFactory {
        private final Bundle _myBundle;

        public EE10ContextFactory(Bundle bundle) {
            this._myBundle = bundle;
        }

        public ContextHandler createContextHandler(AbstractContextProvider provider, BundleMetadata metadata) throws Exception {
            String jettyHome = (String)provider.getServer().getAttribute("jetty.home");
            Path jettyHomePath = StringUtil.isBlank((String)jettyHome) ? null : Paths.get(jettyHome, new String[0]);
            ContextHandler contextHandler = new ContextHandler();
            contextHandler.setAttribute("org.eclipse.jetty.osgi.bundle", (Object)metadata.getBundle());
            contextHandler.setAttribute("Jetty-Boot-Bundle-Context", (Object)EE10Activator.this.getBootBundleContext());
            ResourceFactory resourceFactory = ResourceFactory.of((Container)contextHandler);
            contextHandler.setBaseResource(Util.newBundleResource((Bundle)metadata.getBundle(), (ResourceFactory)resourceFactory));
            ClassLoader coreLoader = (ClassLoader)provider.getServer().getAttribute("org.eclipse.jetty.osgi.server.classLoader");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Core classloader = {}", coreLoader.getClass());
            }
            OSGiClassLoader environmentLoader = new OSGiClassLoader(coreLoader, this._myBundle);
            OSGiClassLoader classLoader = new OSGiClassLoader((ClassLoader)environmentLoader, metadata.getBundle());
            contextHandler.setClassLoader((ClassLoader)classLoader);
            String tmp = (String)metadata.getAttributes().getAttribute("Jetty-ContextFilePath");
            URI contextXmlURI = Util.resolvePathAsLocalizedURI((String)tmp, (Bundle)metadata.getBundle(), (Path)jettyHomePath);
            if (contextXmlURI != null) {
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(contextHandler.getClassLoader());
                    WebAppClassLoader.runWithHiddenClassAccess(() -> {
                        Server server = provider.getServer();
                        XmlConfiguration xmlConfiguration = new XmlConfiguration(ResourceFactory.of((Container)contextHandler).newResource(contextXmlURI));
                        xmlConfiguration.setJettyStandardIdsAndProperties((Object)server, null);
                        WebAppClassLoader.runWithHiddenClassAccess(() -> {
                            HashMap<String, String> properties = new HashMap<String, String>();
                            properties.put("bundle.root", metadata.getPath().toUri().toString());
                            properties.put("jetty.home", (String)server.getAttribute("jetty.home"));
                            xmlConfiguration.getProperties().putAll(properties);
                            xmlConfiguration.configure((Object)contextHandler);
                            return null;
                        });
                        return null;
                    });
                }
                catch (Exception e) {
                    LOG.warn("Error applying context xml", (Throwable)e);
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            contextHandler.setAttribute("osgi-bundlecontext", (Object)metadata.getBundle().getBundleContext());
            String[] targets = contextHandler.getProtectedTargets();
            int length = targets == null ? 0 : targets.length;
            String[] updatedTargets = null;
            if (targets != null) {
                updatedTargets = new String[length + OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
                System.arraycopy(targets, 0, updatedTargets, 0, length);
            } else {
                updatedTargets = new String[OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
            }
            System.arraycopy(OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS, 0, updatedTargets, length, OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length);
            contextHandler.setProtectedTargets(updatedTargets);
            return contextHandler;
        }
    }

    public class EE10WebAppFactory
    implements ContextFactory {
        private final Bundle _myBundle;

        public EE10WebAppFactory(Bundle bundle) {
            this._myBundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ContextHandler createContextHandler(AbstractContextProvider provider, BundleMetadata metadata) throws Exception {
            URI defaultWebXml;
            URI webXml;
            String tmp;
            String jettyHome = (String)provider.getServer().getAttribute("jetty.home");
            Path jettyHomePath = StringUtil.isBlank((String)jettyHome) ? null : ResourceFactory.of((Container)provider.getServer()).newResource(jettyHome).getPath();
            WebAppContext webApp = new WebAppContext();
            webApp.setAttribute("org.eclipse.jetty.osgi.bundle", (Object)metadata.getBundle());
            webApp.setAttribute("Jetty-Boot-Bundle-Context", (Object)EE10Activator.this.getBootBundleContext());
            ResourceFactory resourceFactory = ResourceFactory.of((Container)webApp);
            webApp.initializeDefaults(provider.getAttributes());
            ClassLoader coreLoader = (ClassLoader)provider.getServer().getAttribute("org.eclipse.jetty.osgi.server.classLoader");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Core classloader = {}", (Object)coreLoader);
            }
            OSGiClassLoader environmentLoader = new OSGiClassLoader(coreLoader, this._myBundle);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Environment classloader = {}", (Object)environmentLoader);
            }
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)environmentLoader);
                WebAppClassLoader.runWithHiddenClassAccess(() -> {
                    Configurations.getKnown();
                    return null;
                });
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            webApp.setConfigurations((Configuration[])Configurations.getKnown().stream().filter(Configuration::isEnabledByDefault).toArray(Configuration[]::new));
            OSGiWebappClassLoader webAppLoader = new OSGiWebappClassLoader((ClassLoader)environmentLoader, (WebAppClassLoader.Context)webApp, metadata.getBundle());
            String requireTldBundles = (String)metadata.getAttributes().getAttribute("Require-TldBundle");
            List pathsToTldBundles = Util.getPathsToBundlesBySymbolicNames((String)requireTldBundles, (BundleContext)metadata.getBundle().getBundleContext());
            for (Path p : pathsToTldBundles) {
                webAppLoader.addClassPath(p.toUri().toString());
            }
            String extraClasspath = (String)metadata.getAttributes().getAttribute("Jetty-extraClasspath");
            if (extraClasspath != null) {
                webApp.setExtraClasspath(extraClasspath);
            }
            webApp.setClassLoader((ClassLoader)webAppLoader);
            webApp.setAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern", provider.getAttributes().getAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern"));
            webApp.setAttribute("Require-TldBundle", (Object)requireTldBundles);
            webApp.setAttribute("osgi-bundlecontext", (Object)metadata.getBundle().getBundleContext());
            webApp.setAttribute("org.springframework.osgi.web." + BundleContext.class.getName(), (Object)metadata.getBundle().getBundleContext());
            webApp.setAttribute("osgi-bundle", (Object)metadata.getBundle());
            URI tmpUri = null;
            URL contextXmlURL = Util.getLocalizedEntry((String)"/META-INF/jetty-webapp-context.xml", (Bundle)metadata.getBundle());
            if (contextXmlURL != null) {
                tmpUri = contextXmlURL.toURI();
            }
            if (contextXmlURL == null && (tmp = (String)metadata.getAttributes().getAttribute("Jetty-ContextFilePath")) != null) {
                String[] filenames = tmp.split("[,;]");
                tmpUri = Util.resolvePathAsLocalizedURI((String)filenames[0], (Bundle)metadata.getBundle(), (Path)jettyHomePath);
            }
            if (tmpUri != null) {
                URI contextXmlUri = tmpUri;
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(webApp.getClassLoader());
                    WebAppClassLoader.runWithHiddenClassAccess(() -> {
                        Server server = provider.getServer();
                        XmlConfiguration xmlConfiguration = new XmlConfiguration(ResourceFactory.of((Container)webApp).newResource(contextXmlUri));
                        xmlConfiguration.setJettyStandardIdsAndProperties((Object)server, null);
                        WebAppClassLoader.runWithHiddenClassAccess(() -> {
                            HashMap<String, String> properties = new HashMap<String, String>();
                            properties.put("bundle.root", metadata.getPath().toUri().toString());
                            properties.put("jetty.home", (String)server.getAttribute("jetty.home"));
                            xmlConfiguration.getProperties().putAll(properties);
                            xmlConfiguration.configure((Object)webApp);
                            return null;
                        });
                        return null;
                    });
                }
                catch (Exception e) {
                    LOG.warn("Error applying context xml", (Throwable)e);
                    throw e;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            webApp.setContextPath(metadata.getContextPath());
            webApp.setAttribute("osgi-bundlecontext", (Object)metadata.getBundle().getBundleContext());
            webApp.setAttribute("o.e.j.o.b.watermark", (Object)"o.e.j.o.b.watermark");
            String[] targets = webApp.getProtectedTargets();
            String[] updatedTargets = null;
            if (targets != null) {
                updatedTargets = new String[targets.length + OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
                System.arraycopy(targets, 0, updatedTargets, 0, targets.length);
            } else {
                updatedTargets = new String[OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
            }
            System.arraycopy(OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS, 0, updatedTargets, targets.length, OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length);
            webApp.setProtectedTargets(updatedTargets);
            Resource bundleResource = Util.newBundleResource((Bundle)metadata.getBundle(), (ResourceFactory)resourceFactory);
            String pathToResourceBase = metadata.getPathToResourceBase();
            if (StringUtil.isBlank((String)pathToResourceBase) || ".".equals(pathToResourceBase)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Webapp base using bundle install location: {}", (Object)bundleResource);
                }
                webApp.setWarResource(bundleResource);
            } else if (pathToResourceBase.startsWith("/") || pathToResourceBase.startsWith("file:")) {
                Path p = Paths.get(pathToResourceBase, new String[0]);
                webApp.setWar(p.toUri().toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Webapp base using absolute location: {}", (Object)p);
                }
            } else {
                Resource r = bundleResource.resolve(pathToResourceBase);
                webApp.setWarResource(r);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Webapp base using path relative to bundle unpacked install location: {}", (Object)r);
                }
            }
            String tmp2 = (String)metadata.getAttributes().getAttribute("Jetty-WebXmlFilePath");
            if (!StringUtil.isBlank((String)tmp2) && (webXml = Util.resolvePathAsLocalizedURI((String)tmp2, (Bundle)metadata.getBundle(), (Path)jettyHomePath)) != null) {
                webApp.setDescriptor(webXml.toString());
            }
            if ((tmp2 = (String)metadata.getAttributes().getAttribute("Jetty-defaultWebXmlFilePath")) != null && (defaultWebXml = Util.resolvePathAsLocalizedURI((String)tmp2, (Bundle)metadata.getBundle(), (Path)jettyHomePath)) != null) {
                webApp.setDefaultsDescriptor(defaultWebXml.toString());
            }
            return webApp;
        }
    }
}

