/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.osgi.annotations;

import jakarta.servlet.ServletContainerInitializer;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.ee10.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee10.annotations.AnnotationParser;
import org.eclipse.jetty.ee10.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.ee10.osgi.annotations.AnnotationParser;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationConfiguration
extends org.eclipse.jetty.ee10.annotations.AnnotationConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(org.eclipse.jetty.ee10.annotations.AnnotationConfiguration.class);

    public Class<? extends Configuration> replaces() {
        return org.eclipse.jetty.ee10.annotations.AnnotationConfiguration.class;
    }

    protected org.eclipse.jetty.ee10.annotations.AnnotationParser createAnnotationParser(int platform) {
        return new AnnotationParser(platform);
    }

    protected Resource getJarFor(WebAppContext context, ServletContainerInitializer service) {
        Resource resource = super.getJarFor(context, service);
        if (resource != null && !FileID.isJavaArchive((URI)resource.getURI())) {
            return null;
        }
        return resource;
    }

    public void parseWebInfLib(AnnotationConfiguration.State state, org.eclipse.jetty.ee10.annotations.AnnotationParser parser) throws Exception {
        AnnotationParser oparser = (AnnotationParser)parser;
        if (state._webInfLibStats == null) {
            state._webInfLibStats = new CounterStatistic();
        }
        WebAppContext context = state._context;
        Bundle webbundle = (Bundle)context.getAttribute("osgi-bundle");
        Set fragAndRequiredBundles = (Set)context.getAttribute("org.eclipse.jetty.ee10.osgi.fragmentAndRequiredBundles");
        if (fragAndRequiredBundles != null) {
            for (Bundle bundle : fragAndRequiredBundles) {
                if (bundle.getState() == 1) continue;
                Resource bundleRes = oparser.indexBundle(ResourceFactory.of((Container)context), bundle);
                if (!context.getMetaData().getWebInfResources(false).contains(bundleRes)) {
                    context.getMetaData().addWebInfResource(bundleRes);
                }
                if (bundle.getHeaders().get("Fragment-Host") == null) continue;
                this.parseFragmentBundle(state, oparser, webbundle, bundle);
                state._webInfLibStats.increment();
            }
        }
        oparser.indexBundle(ResourceFactory.of((Container)context), webbundle);
        this.parseWebBundle(state, oparser, webbundle);
        state._webInfLibStats.increment();
        super.parseWebInfLib(state, parser);
        if (fragAndRequiredBundles != null) {
            for (Bundle requiredBundle : fragAndRequiredBundles) {
                if (requiredBundle.getState() == 1 || requiredBundle.getHeaders().get("Fragment-Host") != null) continue;
                this.parseRequiredBundle(state, oparser, webbundle, requiredBundle);
                state._webInfLibStats.increment();
            }
        }
    }

    protected void parseFragmentBundle(AnnotationConfiguration.State state, AnnotationParser parser, Bundle webbundle, Bundle fragmentBundle) throws Exception {
        this.parseBundle(state, parser, webbundle, fragmentBundle);
    }

    protected void parseWebBundle(AnnotationConfiguration.State state, AnnotationParser parser, Bundle webbundle) throws Exception {
        this.parseBundle(state, parser, webbundle, webbundle);
    }

    public void parseWebInfClasses(AnnotationConfiguration.State state, org.eclipse.jetty.ee10.annotations.AnnotationParser parser) {
        WebAppContext context = state._context;
        Bundle webbundle = (Bundle)context.getAttribute("osgi-bundle");
        String bundleClasspath = (String)webbundle.getHeaders().get("Bundle-ClassPath");
        if (StringUtil.isBlank((String)bundleClasspath) || !bundleClasspath.contains("WEB-INF/classes")) {
            super.parseWebInfClasses(state, parser);
        }
    }

    protected void parseRequiredBundle(AnnotationConfiguration.State state, AnnotationParser parser, Bundle webbundle, Bundle requiredBundle) throws Exception {
        this.parseBundle(state, parser, webbundle, requiredBundle);
    }

    protected void parseBundle(AnnotationConfiguration.State state, AnnotationParser parser, Bundle webbundle, Bundle bundle) {
        Resource bundleRes = parser.getResource(bundle);
        HashSet<ClassInheritanceHandler> handlers = new HashSet<ClassInheritanceHandler>(state._discoverableAnnotationHandlers);
        if (state._classInheritanceHandler != null) {
            handlers.add(state._classInheritanceHandler);
        }
        handlers.addAll(state._containerInitializerAnnotationHandlers);
        if (state._parserTasks != null) {
            BundleParserTask task = new BundleParserTask(parser, handlers, bundleRes);
            state._parserTasks.add(task);
            if (LOG.isDebugEnabled()) {
                task.setStatistic(new AnnotationConfiguration.TimeStatistic());
            }
        }
    }

    public class BundleParserTask
    extends AnnotationConfiguration.ParserTask {
        public BundleParserTask(AnnotationParser parser, Set<? extends AnnotationParser.Handler> handlers, Resource resource) {
            super((org.eclipse.jetty.ee10.annotations.AnnotationParser)parser, handlers, resource);
        }

        public Void call() throws Exception {
            if (this._parser != null) {
                AnnotationParser osgiAnnotationParser = (AnnotationParser)this._parser;
                Bundle bundle = osgiAnnotationParser.getBundle(this._resource);
                if (this._stat != null) {
                    this._stat.start();
                }
                osgiAnnotationParser.parse((Set<? extends AnnotationParser.Handler>)this._handlers, bundle);
                if (this._stat != null) {
                    this._stat.end();
                }
            }
            return null;
        }
    }
}

