/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPartConfig;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ConditionalHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.thread.Invocable;

public class EagerContentHandler
extends ConditionalHandler.ElseNext {
    private final Map<String, ContentLoaderFactory> _factoriesByMimeType = new TreeMap<String, ContentLoaderFactory>(String.CASE_INSENSITIVE_ORDER);
    private final ContentLoaderFactory _defaultFactory;

    public EagerContentHandler() {
        this((Handler)null);
    }

    public EagerContentHandler(Handler handler) {
        this(handler, new FormContentLoaderFactory(), new MultiPartContentLoaderFactory(), new RetainedContentLoaderFactory());
    }

    public EagerContentHandler(ContentLoaderFactory ... factories) {
        this((Handler)null, factories);
    }

    public EagerContentHandler(Handler handler, ContentLoaderFactory ... factories) {
        super(handler);
        ContentLoaderFactory dft = null;
        for (ContentLoaderFactory factory : factories) {
            this.installBean(factory);
            if (factory.getApplicableMimeType() == null) {
                dft = factory;
                continue;
            }
            this._factoriesByMimeType.put(factory.getApplicableMimeType(), factory);
        }
        this._defaultFactory = dft;
    }

    @Override
    protected boolean onConditionsMet(Request request, Response response, Callback callback) throws Exception {
        ContentLoaderFactory factory;
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        boolean contentExpected = false;
        String contentType = null;
        String mimeType = null;
        for (HttpField field : request.getHeaders()) {
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case CONTENT_TYPE: {
                    contentType = field.getValue();
                    mimeType = MimeTypes.getMimeTypeAsStringFromContentType(field);
                    break;
                }
                case CONTENT_LENGTH: {
                    contentExpected = field.getLongValue() > 0L;
                    break;
                }
                case TRANSFER_ENCODING: {
                    contentExpected = field.contains(HttpHeaderValue.CHUNKED.asString());
                    break;
                }
            }
        }
        if (!contentExpected) {
            return next.handle(request, response, callback);
        }
        ContentLoaderFactory contentLoaderFactory = factory = mimeType == null ? null : this._factoriesByMimeType.get(mimeType);
        if (factory == null) {
            factory = this._defaultFactory;
        }
        if (factory == null) {
            return next.handle(request, response, callback);
        }
        ContentLoader contentLoader = factory.newContentLoader(contentType, mimeType, next, request, response, callback);
        if (contentLoader == null) {
            return next.handle(request, response, callback);
        }
        contentLoader.load();
        return true;
    }

    public static interface ContentLoaderFactory {
        public String getApplicableMimeType();

        public ContentLoader newContentLoader(String var1, String var2, Handler var3, Request var4, Response var5, Callback var6);
    }

    public static class FormContentLoaderFactory
    implements ContentLoaderFactory {
        private final int _maxFields;
        private final int _maxLength;

        public FormContentLoaderFactory() {
            this(-1, -1);
        }

        public FormContentLoaderFactory(int maxFields, int maxLength) {
            this._maxFields = maxFields;
            this._maxLength = maxLength;
        }

        @Override
        public String getApplicableMimeType() {
            return MimeTypes.Type.FORM_ENCODED.asString();
        }

        @Override
        public ContentLoader newContentLoader(String contentType, String mimeType, Handler handler, Request request, Response response, Callback callback) {
            String cs = MimeTypes.getCharsetFromContentType(contentType);
            final Charset charset = StringUtil.isEmpty(cs) ? StandardCharsets.UTF_8 : Charset.forName(cs);
            return new ContentLoader(this, handler, request, response, callback){
                final /* synthetic */ FormContentLoaderFactory this$0;
                {
                    this.this$0 = this$0;
                    super(handler, request, response, callback);
                }

                @Override
                protected void load() {
                    final Invocable.InvocationType invocationType = this.getHandler().getInvocationType();
                    final AtomicInteger done = new AtomicInteger(2);
                    Promise.Invocable<Fields> onFields = new Promise.Invocable<Fields>(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void failed(Throwable x) {
                            this.succeeded(null);
                        }

                        @Override
                        public void succeeded(Fields result) {
                            if (done.decrementAndGet() == 0) {
                                invocationType.runWithoutBlocking(this::doProcess, this.this$1.getRequest().getContext());
                            }
                        }

                        private void doProcess() {
                            this.this$1.handle();
                        }

                        @Override
                        public Invocable.InvocationType getInvocationType() {
                            return invocationType;
                        }
                    };
                    FormFields.onFields(this.getRequest(), charset, this.this$0._maxFields, this.this$0._maxLength, onFields);
                    if (done.decrementAndGet() == 0) {
                        this.handle();
                    }
                }
            };
        }
    }

    public static class MultiPartContentLoaderFactory
    implements ContentLoaderFactory {
        private final MultiPartConfig _multiPartConfig;

        public MultiPartContentLoaderFactory() {
            this(null);
        }

        public MultiPartContentLoaderFactory(MultiPartConfig multiPartConfig) {
            this._multiPartConfig = multiPartConfig;
        }

        @Override
        public String getApplicableMimeType() {
            return MimeTypes.Type.MULTIPART_FORM_DATA.asString();
        }

        @Override
        public ContentLoader newContentLoader(final String contentType, String mimeType, Handler handler, Request request, Response response, Callback callback) {
            MultiPartConfig mpc;
            Object object;
            MultiPartConfig config = this._multiPartConfig;
            if (config == null && (object = request.getContext().getAttribute(MultiPartConfig.class.getName())) instanceof MultiPartConfig) {
                config = mpc = (MultiPartConfig)object;
            }
            if (config == null && (object = handler.getServer().getAttribute(MultiPartConfig.class.getName())) instanceof MultiPartConfig) {
                config = mpc = (MultiPartConfig)object;
            }
            if (config == null) {
                return null;
            }
            final MultiPartConfig multiPartConfig = config;
            return new ContentLoader(this, handler, request, response, callback){
                final /* synthetic */ MultiPartContentLoaderFactory this$0;
                {
                    this.this$0 = this$0;
                    super(handler, request, response, callback);
                }

                @Override
                protected void load() {
                    Request request = this.getRequest();
                    final Invocable.InvocationType invocationType = this.getHandler().getInvocationType();
                    final AtomicInteger done = new AtomicInteger(2);
                    Promise.Invocable<MultiPartFormData.Parts> onParts = new Promise.Invocable<MultiPartFormData.Parts>(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void failed(Throwable x) {
                            this.succeeded(null);
                        }

                        @Override
                        public void succeeded(MultiPartFormData.Parts result) {
                            if (done.decrementAndGet() == 0) {
                                invocationType.runWithoutBlocking(this::doProcess, this.this$1.getRequest().getContext());
                            }
                        }

                        private void doProcess() {
                            this.this$1.handle();
                        }

                        @Override
                        public Invocable.InvocationType getInvocationType() {
                            return invocationType;
                        }
                    };
                    MultiPartFormData.onParts(request, request, contentType, multiPartConfig, onParts);
                    if (done.decrementAndGet() == 0) {
                        this.handle();
                    }
                }
            };
        }
    }

    public static class RetainedContentLoaderFactory
    implements ContentLoaderFactory {
        private final long _maxRetainedBytes;
        private final int _framingOverhead;
        private final boolean _reject;

        public RetainedContentLoaderFactory() {
            this(-1L, -1, true);
        }

        public RetainedContentLoaderFactory(long maxRetainedBytes, int framingOverhead, boolean reject) {
            this._maxRetainedBytes = maxRetainedBytes;
            this._framingOverhead = framingOverhead;
            this._reject = reject;
        }

        @Override
        public String getApplicableMimeType() {
            return null;
        }

        @Override
        public ContentLoader newContentLoader(String contentType, String mimeType, Handler handler, Request request, Response response, Callback callback) {
            return new RetainedContentLoader(handler, request, response, callback, this._maxRetainedBytes, this._framingOverhead, this._reject);
        }

        public static class RetainedContentLoader
        extends ContentLoader
        implements Invocable.Task {
            private final Deque<Content.Chunk> _chunks = new ArrayDeque<Content.Chunk>();
            private final long _maxRetainedBytes;
            private final int _framingOverhead;
            private final boolean _rejectWhenExceeded;
            private long _estimatedSize;

            public RetainedContentLoader(Handler handler, Request request, Response response, Callback callback, long maxRetainedBytes, int framingOverhead, boolean rejectWhenExceeded) {
                super(handler, request, response, callback);
                long l = this._maxRetainedBytes = maxRetainedBytes < 0L ? (long)Math.max(1, request.getConnectionMetaData().getConnector().getConnectionFactory(HttpConnectionFactory.class).getInputBufferSize() - 1500) : maxRetainedBytes;
                this._framingOverhead = framingOverhead < 0 ? (request.getConnectionMetaData().getHttpVersion().getVersion() <= HttpVersion.HTTP_1_1.getVersion() ? 8 : 9) : framingOverhead;
                this._rejectWhenExceeded = rejectWhenExceeded;
            }

            @Override
            protected void load() {
                this.read(false);
            }

            protected void read(boolean execute) {
                block7: {
                    boolean oversize;
                    Content.Chunk chunk;
                    do {
                        if ((chunk = super.getRequest().read()) == null) {
                            this.getRequest().demand(this);
                        } else if (!this._chunks.add(chunk)) {
                            this.getCallback().failed(new IllegalStateException());
                        } else {
                            this._estimatedSize += (long)(this._framingOverhead + chunk.remaining());
                            boolean bl = oversize = this._estimatedSize >= this._maxRetainedBytes;
                            if (!this._rejectWhenExceeded || !oversize || chunk.isLast()) continue;
                            Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), 413);
                        }
                        break block7;
                    } while (!chunk.isLast() && !oversize);
                    if (execute) {
                        this.getRequest().getContext().execute(this::doHandle);
                    } else {
                        this.doHandle();
                    }
                }
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void run() {
                this.read(true);
            }

            private void doHandle() {
                RewindChunksRequest request = new RewindChunksRequest(this.getRequest(), this.getCallback(), this._chunks);
                this.handle(request, this.getResponse(), request);
            }

            private static class RewindChunksRequest
            extends Request.Wrapper
            implements Callback {
                private final Deque<Content.Chunk> _chunks;
                private final Callback _callback;

                public RewindChunksRequest(Request wrapped, Callback callback, Deque<Content.Chunk> chunks) {
                    super(wrapped);
                    this._chunks = chunks;
                    this._callback = callback;
                }

                @Override
                public Invocable.InvocationType getInvocationType() {
                    return this._callback.getInvocationType();
                }

                @Override
                public Content.Chunk read() {
                    if (this._chunks.isEmpty()) {
                        return super.read();
                    }
                    return this._chunks.removeFirst();
                }

                private void release() {
                    this._chunks.forEach(Retainable::release);
                    this._chunks.clear();
                }

                @Override
                public void succeeded() {
                    this.release();
                    this._callback.succeeded();
                }

                @Override
                public void fail(Throwable failure) {
                    this.release();
                    this._callback.failed(failure);
                }
            }
        }
    }

    public static abstract class ContentLoader {
        private final Handler _handler;
        private final Request _request;
        private final Response _response;
        private final Callback _callback;

        protected ContentLoader(Handler handler, Request request, Response response, Callback callback) {
            this._handler = Objects.requireNonNull(handler);
            this._request = Objects.requireNonNull(request);
            this._response = Objects.requireNonNull(response);
            this._callback = Objects.requireNonNull(callback);
        }

        protected Handler getHandler() {
            return this._handler;
        }

        protected Request getRequest() {
            return this._request;
        }

        protected Response getResponse() {
            return this._response;
        }

        protected Callback getCallback() {
            return this._callback;
        }

        protected void handle() {
            this.handle(this.getRequest(), this.getResponse(), this.getCallback());
        }

        protected void handle(Request request, Response response, Callback callback) {
            try {
                if (this.getHandler().handle(request, response, callback)) {
                    return;
                }
                Response.writeError(request, response, callback, 404);
            }
            catch (Throwable t) {
                Response.writeError(request, response, callback, t);
            }
        }

        protected abstract void load() throws Exception;
    }
}

