/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.quickstart;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspPropertyGroupDescriptor;
import jakarta.servlet.descriptor.TaglibDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.ee10.quickstart.ExtraXmlDescriptorProcessor;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.FilterMapping;
import org.eclipse.jetty.ee10.servlet.ListenerHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.ee10.servlet.Source;
import org.eclipse.jetty.ee10.servlet.security.ConstraintAware;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.DescriptorProcessor;
import org.eclipse.jetty.ee10.webapp.MetaData;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.AttributeNormalizer;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlAppendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickStartGeneratorConfiguration
extends AbstractConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(QuickStartGeneratorConfiguration.class);
    public static final String ORIGIN = "org.eclipse.jetty.originAttribute";
    public static final String DEFAULT_ORIGIN_ATTRIBUTE_NAME = "origin";
    protected final boolean _abort;
    protected String _originAttribute;
    protected int _count = 0;
    protected Path _quickStartWebXml;

    public QuickStartGeneratorConfiguration() {
        this(false);
    }

    public QuickStartGeneratorConfiguration(boolean abort) {
        super(new AbstractConfiguration.Builder().enabledByDefault(false));
        this._abort = abort;
    }

    public boolean abort(WebAppContext context) {
        return this._abort;
    }

    public void setOriginAttribute(String name) {
        this._originAttribute = name;
    }

    public String getOriginAttribute() {
        return this._originAttribute;
    }

    public Path getQuickStartWebXml() {
        return this._quickStartWebXml;
    }

    public void setQuickStartWebXml(Path quickStartWebXml) {
        this._quickStartWebXml = quickStartWebXml;
    }

    /*
     * WARNING - void declaration
     */
    public void generateQuickStartWebXml(WebAppContext context, OutputStream stream) throws IOException {
        LifeCycleCallbackCollection lifeCycleCallbackCollection;
        ServletContextHandler.JspConfig jspConfig;
        MimeTypes.Mutable mutable;
        Map errorPages;
        Map localeEncodings;
        SecurityHandler security;
        ServletHandler servlets;
        String responseEncoding;
        String requestEncoding;
        Resource base;
        if (context == null) {
            throw new IllegalStateException("No webapp for quickstart generation");
        }
        if (stream == null) {
            throw new IllegalStateException("No output for quickstart generation");
        }
        if (this._originAttribute == null) {
            this._originAttribute = DEFAULT_ORIGIN_ATTRIBUTE_NAME;
        }
        context.getMetaData().getOrigins();
        if (context.getBaseResource() == null) {
            throw new IllegalArgumentException("No base resource for " + String.valueOf((Object)this));
        }
        MetaData md = context.getMetaData();
        HashMap<String, Object> webappAttr = new HashMap<String, Object>();
        int major = context.getServletContext().getEffectiveMajorVersion();
        int minor = context.getServletContext().getEffectiveMinorVersion();
        String ns = major < 5 ? "http://xmlns.jcp.org/xml/ns/javaee" : "https://jakarta.ee/xml/ns/jakartaee";
        webappAttr.put("xmlns", ns);
        webappAttr.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webappAttr.put("xsi:schemaLocation", String.format("%s %s/web-app_%d_%d.xsd", ns, ns, major, minor));
        webappAttr.put("metadata-complete", Boolean.toString(context.getMetaData().isMetaDataComplete()));
        webappAttr.put("version", major + "." + minor);
        XmlAppendable out = new XmlAppendable(stream);
        out.openTag("web-app", webappAttr);
        if (context.getDisplayName() != null) {
            out.tag("display-name", context.getDisplayName());
        }
        base = (base = context.getBaseResource()) != null ? (Resource)base.iterator().next() : null;
        AttributeNormalizer normalizer = new AttributeNormalizer(base);
        this.addContextParamFromAttribute(context, out, "jakarta.servlet.context.orderedLibs");
        ServletContextHandler.ServletContainerInitializerStarter sciStarter = (ServletContextHandler.ServletContainerInitializerStarter)context.getBean(ServletContextHandler.ServletContainerInitializerStarter.class);
        this.addContextParamFromCollection(context, out, "org.eclipse.jetty.containerInitializers", sciStarter == null ? Collections.emptySet() : sciStarter.getServletContainerInitializerHolders());
        this.addContextParamFromAttribute(context, out, "org.eclipse.jetty.tlds", normalizer);
        this.addContextParamFromAttribute(context, out, "org.eclipse.jetty.resources", normalizer);
        String defaultContextPath = (String)context.getAttribute("default-context-path");
        if (defaultContextPath != null) {
            out.tag("default-context-path", defaultContextPath);
        }
        if (!StringUtil.isBlank((String)(requestEncoding = (String)context.getAttribute("request-character-encoding")))) {
            out.tag("request-character-encoding", requestEncoding);
        }
        if (!StringUtil.isBlank((String)(responseEncoding = (String)context.getAttribute("response-character-encoding")))) {
            out.tag("response-character-encoding", responseEncoding);
        }
        if (StringUtil.isNotBlank((String)this._originAttribute)) {
            out.openTag("context-param").tag("param-name", ORIGIN).tag("param-value", this._originAttribute).closeTag();
        }
        for (String p : context.getInitParams().keySet()) {
            out.openTag("context-param", this.origin(md, "context-param." + p)).tag("param-name", p).tag("param-value", context.getInitParameter(p)).closeTag();
        }
        if (context.getServletHandler().getListeners() != null) {
            for (ListenerHolder e : context.getServletHandler().getListeners()) {
                if (e.getSource() == Source.EMBEDDED) continue;
                out.openTag("listener", this.origin(md, e.getClassName() + ".listener")).tag("listener-class", e.getClassName()).closeTag();
            }
        }
        if ((servlets = context.getServletHandler()).getFilters() != null) {
            for (FilterHolder filterHolder : servlets.getFilters()) {
                if (filterHolder.getSource() == Source.EMBEDDED) continue;
                this.outholder(out, md, filterHolder);
            }
        }
        if (servlets.getFilterMappings() != null) {
            for (FilterMapping filterMapping : servlets.getFilterMappings()) {
                FilterHolder filterHolder = servlets.getFilter(filterMapping.getFilterName());
                if (filterHolder != null && filterHolder.getSource() == Source.EMBEDDED) continue;
                out.openTag("filter-mapping", this.origin(md, filterMapping.getFilterName() + ".filter.mapping." + Long.toHexString(filterMapping.hashCode())));
                out.tag("filter-name", filterMapping.getFilterName());
                if (filterMapping.getPathSpecs() != null) {
                    for (String s : filterMapping.getPathSpecs()) {
                        out.tag("url-pattern", s);
                    }
                }
                if (filterMapping.getServletNames() != null) {
                    for (String n : filterMapping.getServletNames()) {
                        out.tag("servlet-name", n);
                    }
                }
                if (!filterMapping.isDefaultDispatches()) {
                    if (filterMapping.appliesTo(DispatcherType.REQUEST)) {
                        out.tag("dispatcher", "REQUEST");
                    }
                    if (filterMapping.appliesTo(DispatcherType.ASYNC)) {
                        out.tag("dispatcher", "ASYNC");
                    }
                    if (filterMapping.appliesTo(DispatcherType.ERROR)) {
                        out.tag("dispatcher", "ERROR");
                    }
                    if (filterMapping.appliesTo(DispatcherType.FORWARD)) {
                        out.tag("dispatcher", "FORWARD");
                    }
                    if (filterMapping.appliesTo(DispatcherType.INCLUDE)) {
                        out.tag("dispatcher", "INCLUDE");
                    }
                }
                out.closeTag();
            }
        }
        if (servlets.getServlets() != null) {
            for (ServletHolder servletHolder : servlets.getServlets()) {
                if (servletHolder.getSource() == Source.EMBEDDED) continue;
                this.outholder(out, md, servletHolder);
            }
        }
        if (servlets.getServletMappings() != null) {
            for (ServletMapping servletMapping : servlets.getServletMappings()) {
                ServletHolder servletHolder = servlets.getServlet(servletMapping.getServletName());
                if (servletHolder != null && servletHolder.getSource() == Source.EMBEDDED) continue;
                out.openTag("servlet-mapping", this.origin(md, servletMapping.getServletName() + ".servlet.mapping." + Long.toHexString(servletMapping.hashCode())));
                out.tag("servlet-name", servletMapping.getServletName());
                if (servletMapping.getPathSpecs() != null) {
                    for (String s : servletMapping.getPathSpecs()) {
                        out.tag("url-pattern", s);
                    }
                }
                out.closeTag();
            }
        }
        if ((security = context.getSecurityHandler()) != null && (security.getRealmName() != null || security.getAuthenticationType() != null)) {
            out.openTag("login-config");
            if (security.getAuthenticationType() != null) {
                out.tag("auth-method", this.origin(md, "auth-method"), security.getAuthenticationType());
            }
            if (security.getRealmName() != null) {
                out.tag("realm-name", this.origin(md, "realm-name"), security.getRealmName());
            }
            if ("FORM".equalsIgnoreCase(security.getAuthenticationType())) {
                out.openTag("form-login-config");
                out.tag("form-login-page", this.origin(md, "form-login-page"), security.getParameter("org.eclipse.jetty.security.form_login_page"));
                out.tag("form-error-page", this.origin(md, "form-error-page"), security.getParameter("org.eclipse.jetty.security.form_error_page"));
                out.closeTag();
            }
            out.closeTag();
        }
        if (security instanceof ConstraintAware) {
            ConstraintAware ca = (ConstraintAware)security;
            for (String string : ca.getKnownRoles()) {
                out.openTag("security-role", this.origin(md, "security-role." + string)).tag("role-name", string).closeTag();
            }
            for (ConstraintMapping constraintMapping : ca.getConstraintMappings()) {
                out.openTag("security-constraint");
                out.openTag("web-resource-collection");
                if (constraintMapping.getConstraint().getName() != null) {
                    out.tag("web-resource-name", constraintMapping.getConstraint().getName());
                }
                if (constraintMapping.getPathSpec() != null) {
                    out.tag("url-pattern", this.origin(md, "constraint.url." + constraintMapping.getPathSpec()), constraintMapping.getPathSpec());
                }
                if (constraintMapping.getMethod() != null) {
                    out.tag("http-method", constraintMapping.getMethod());
                }
                if (constraintMapping.getMethodOmissions() != null) {
                    for (String o : constraintMapping.getMethodOmissions()) {
                        out.tag("http-method-omission", o);
                    }
                }
                out.closeTag();
                Constraint.Authorization authorization = constraintMapping.getConstraint().getAuthorization();
                switch (authorization) {
                    case ALLOWED: 
                    case INHERIT: {
                        break;
                    }
                    case FORBIDDEN: {
                        out.tag("auth-constraint");
                        break;
                    }
                    case ANY_USER: {
                        out.openTag("auth-constraint");
                        out.tag("role-name", "**");
                        out.closeTag();
                        break;
                    }
                    case KNOWN_ROLE: {
                        out.openTag("auth-constraint");
                        out.tag("role-name", "*");
                        out.closeTag();
                        break;
                    }
                    case SPECIFIC_ROLE: {
                        Set set = constraintMapping.getConstraint().getRoles();
                        if (set == null || set.size() <= 0) break;
                        out.openTag("auth-constraint");
                        if (constraintMapping.getConstraint().getRoles() != null) {
                            for (String r : constraintMapping.getConstraint().getRoles()) {
                                out.tag("role-name", r);
                            }
                        }
                        out.closeTag();
                    }
                }
                if (Constraint.Transport.SECURE.equals((Object)constraintMapping.getConstraint().getTransport())) {
                    out.openTag("user-data-constraint").tag("transport-guarantee", "CONFIDENTIAL").closeTag();
                } else if (Constraint.Transport.ANY.equals((Object)constraintMapping.getConstraint().getTransport())) {
                    out.openTag("user-data-constraint").tag("transport-guarantee", "NONE").closeTag();
                }
                out.closeTag();
            }
        }
        if (context.getWelcomeFiles() != null) {
            void var19_49;
            out.openTag("welcome-file-list");
            String[] ca = context.getWelcomeFiles();
            int e = ca.length;
            boolean bl = false;
            while (var19_49 < e) {
                String string = ca[var19_49];
                out.tag("welcome-file", this.origin(md, "welcome-file." + string), string);
                ++var19_49;
            }
            out.closeTag();
        }
        if ((localeEncodings = context.getLocaleEncodings()) != null && !localeEncodings.isEmpty()) {
            out.openTag("locale-encoding-mapping-list");
            for (Map.Entry entry : localeEncodings.entrySet()) {
                out.openTag("locale-encoding-mapping", this.origin(md, "locale-encoding." + (String)entry.getKey()));
                out.tag("locale", (String)entry.getKey());
                out.tag("encoding", (String)entry.getValue());
                out.closeTag();
            }
            out.closeTag();
        }
        if (context.getSessionHandler() != null) {
            Set set;
            out.openTag("session-config");
            int maxInactiveSec = context.getSessionHandler().getMaxInactiveInterval();
            out.tag("session-timeout", maxInactiveSec == 0 ? "0" : Integer.toString(maxInactiveSec / 60));
            SessionCookieConfig sessionCookieConfig = context.getSessionHandler().getSessionCookieConfig();
            if (sessionCookieConfig != null) {
                out.openTag("cookie-config");
                if (sessionCookieConfig.getName() != null) {
                    out.tag("name", this.origin(md, "cookie-config.name"), sessionCookieConfig.getName());
                }
                if (sessionCookieConfig.getDomain() != null) {
                    out.tag("domain", this.origin(md, "cookie-config.domain"), sessionCookieConfig.getDomain());
                }
                if (sessionCookieConfig.getPath() != null) {
                    out.tag("path", this.origin(md, "cookie-config.path"), sessionCookieConfig.getPath());
                }
                if (sessionCookieConfig.getComment() != null) {
                    out.tag("comment", this.origin(md, "cookie-config.comment"), sessionCookieConfig.getComment());
                }
                out.tag("http-only", this.origin(md, "cookie-config.http-only"), Boolean.toString(sessionCookieConfig.isHttpOnly()));
                out.tag("secure", this.origin(md, "cookie-config.secure"), Boolean.toString(sessionCookieConfig.isSecure()));
                out.tag("max-age", this.origin(md, "cookie-config.max-age"), Integer.toString(sessionCookieConfig.getMaxAge()));
                out.closeTag();
            }
            if ((set = context.getSessionHandler().getEffectiveSessionTrackingModes()) != null) {
                for (SessionTrackingMode mode : set) {
                    out.tag("tracking-mode", mode.toString());
                }
            }
            out.closeTag();
        }
        if ((errorPages = ((ErrorPageErrorHandler)context.getErrorHandler()).getErrorPages()) != null) {
            for (Map.Entry entry : errorPages.entrySet()) {
                out.openTag("error-page", this.origin(md, "error." + (String)entry.getKey()));
                if (!"org.eclipse.jetty.server.error_page.global".equals(entry.getKey())) {
                    if (((String)entry.getKey()).matches("\\d{3}")) {
                        out.tag("error-code", (String)entry.getKey());
                    } else {
                        out.tag("exception-type", (String)entry.getKey());
                    }
                }
                out.tag("location", (String)entry.getValue());
                out.closeTag();
            }
        }
        if ((mutable = context.getMimeTypes()) != null) {
            for (Map.Entry entry : mutable.getMimeMap().entrySet()) {
                out.openTag("mime-mapping");
                out.tag("extension", this.origin(md, "extension." + (String)entry.getKey()), (String)entry.getKey());
                out.tag("mime-type", (String)entry.getValue());
                out.closeTag();
            }
        }
        if ((jspConfig = (ServletContextHandler.JspConfig)context.getServletContext().getJspConfigDescriptor()) != null) {
            Collection jspPropertyGroups;
            out.openTag("jsp-config");
            Collection collection = jspConfig.getTaglibs();
            if (collection != null && !collection.isEmpty()) {
                for (TaglibDescriptor tld : collection) {
                    out.openTag("taglib");
                    out.tag("taglib-uri", tld.getTaglibURI());
                    out.tag("taglib-location", tld.getTaglibLocation());
                    out.closeTag();
                }
            }
            if ((jspPropertyGroups = jspConfig.getJspPropertyGroups()) != null && !jspPropertyGroups.isEmpty()) {
                for (JspPropertyGroupDescriptor jspPropertyGroup : jspPropertyGroups) {
                    out.openTag("jsp-property-group");
                    Collection strings = jspPropertyGroup.getUrlPatterns();
                    if (strings != null && !strings.isEmpty()) {
                        for (String urlPattern : strings) {
                            out.tag("url-pattern", urlPattern);
                        }
                    }
                    if (jspPropertyGroup.getElIgnored() != null) {
                        out.tag("el-ignored", jspPropertyGroup.getElIgnored());
                    }
                    if (jspPropertyGroup.getPageEncoding() != null) {
                        out.tag("page-encoding", jspPropertyGroup.getPageEncoding());
                    }
                    if (jspPropertyGroup.getScriptingInvalid() != null) {
                        out.tag("scripting-invalid", jspPropertyGroup.getScriptingInvalid());
                    }
                    if (jspPropertyGroup.getIsXml() != null) {
                        out.tag("is-xml", jspPropertyGroup.getIsXml());
                    }
                    if (jspPropertyGroup.getDeferredSyntaxAllowedAsLiteral() != null) {
                        out.tag("deferred-syntax-allowed-as-literal", jspPropertyGroup.getDeferredSyntaxAllowedAsLiteral());
                    }
                    if (jspPropertyGroup.getTrimDirectiveWhitespaces() != null) {
                        out.tag("trim-directive-whitespaces", jspPropertyGroup.getTrimDirectiveWhitespaces());
                    }
                    if (jspPropertyGroup.getDefaultContentType() != null) {
                        out.tag("default-content-type", jspPropertyGroup.getDefaultContentType());
                    }
                    if (jspPropertyGroup.getBuffer() != null) {
                        out.tag("buffer", jspPropertyGroup.getBuffer());
                    }
                    if (jspPropertyGroup.getErrorOnUndeclaredNamespace() != null) {
                        out.tag("error-on-undeclared-namespace", jspPropertyGroup.getErrorOnUndeclaredNamespace());
                    }
                    if ((strings = jspPropertyGroup.getIncludePreludes()) != null && !strings.isEmpty()) {
                        for (String prelude : strings) {
                            out.tag("include-prelude", prelude);
                        }
                    }
                    if ((strings = jspPropertyGroup.getIncludeCodas()) != null && !strings.isEmpty()) {
                        for (String coda : strings) {
                            out.tag("include-coda", coda);
                        }
                    }
                    out.closeTag();
                }
            }
            out.closeTag();
        }
        if ((lifeCycleCallbackCollection = (LifeCycleCallbackCollection)context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) != null) {
            Collection tmp = lifeCycleCallbackCollection.getPostConstructCallbacks();
            for (LifeCycleCallback c : tmp) {
                out.openTag("post-construct");
                out.tag("lifecycle-callback-class", c.getTargetClassName());
                out.tag("lifecycle-callback-method", c.getMethodName());
                out.closeTag();
            }
            tmp = lifeCycleCallbackCollection.getPreDestroyCallbacks();
            for (LifeCycleCallback c : tmp) {
                out.openTag("pre-destroy");
                out.tag("lifecycle-callback-class", c.getTargetClassName());
                out.tag("lifecycle-callback-method", c.getMethodName());
                out.closeTag();
            }
        }
        ExtraXmlDescriptorProcessor extraXmlProcessor = (ExtraXmlDescriptorProcessor)((Object)context.getAttribute(ExtraXmlDescriptorProcessor.class.getName()));
        out.literal(extraXmlProcessor.getXML());
        out.closeTag();
    }

    private void addContextParamFromCollection(WebAppContext context, XmlAppendable out, String name, Collection<?> collection) throws IOException {
        if (collection == null) {
            return;
        }
        StringBuilder v = new StringBuilder();
        for (Object i : collection) {
            if (i == null) continue;
            if (v.length() > 0) {
                v.append(",\n    ");
            } else {
                v.append("\n    ");
            }
            QuotedStringTokenizer.CSV.quote((Appendable)v, i.toString());
        }
        out.openTag("context-param").tag("param-name", name).tagCDATA("param-value", v.toString()).closeTag();
    }

    private void addContextParamFromAttribute(WebAppContext context, XmlAppendable out, String attribute) throws IOException {
        Object o = context.getAttribute(attribute);
        if (o == null) {
            return;
        }
        List<Object> c = o instanceof Collection ? (List<Object>)o : Collections.singletonList(o);
        this.addContextParamFromCollection(context, out, attribute, c);
    }

    private void addContextParamFromAttribute(WebAppContext context, XmlAppendable out, String attribute, AttributeNormalizer normalizer) throws IOException {
        Object o = context.getAttribute(attribute);
        if (o == null) {
            return;
        }
        List<Object> c = o instanceof Collection ? (List<Object>)o : Collections.singletonList(o);
        StringBuilder v = new StringBuilder();
        for (Object e : c) {
            if (e == null) continue;
            if (v.length() > 0) {
                v.append(",\n    ");
            } else {
                v.append("\n    ");
            }
            QuotedStringTokenizer.CSV.quote((Appendable)v, normalizer.normalize(e));
        }
        out.openTag("context-param").tag("param-name", attribute).tagCDATA("param-value", v.toString()).closeTag();
    }

    private void outholder(XmlAppendable out, MetaData md, FilterHolder holder) throws IOException {
        if (LOG.isDebugEnabled()) {
            out.openTag("filter", Collections.singletonMap("source", holder.getSource().toString()));
        } else {
            out.openTag("filter");
        }
        String n = holder.getName();
        out.tag("filter-name", n);
        String ot = n + ".filter.";
        out.tag("filter-class", this.origin(md, ot + "filter-class"), holder.getClassName());
        out.tag("async-supported", this.origin(md, ot + "async-supported"), holder.isAsyncSupported() ? "true" : "false");
        for (String p : holder.getInitParameters().keySet()) {
            out.openTag("init-param", this.origin(md, ot + "init-param." + p)).tag("param-name", p).tag("param-value", holder.getInitParameter(p)).closeTag();
        }
        out.closeTag();
    }

    private void outholder(XmlAppendable out, MetaData md, ServletHolder holder) throws IOException {
        MultipartConfigElement multipartConfig;
        Map roles;
        if (LOG.isDebugEnabled()) {
            out.openTag("servlet", Collections.singletonMap("source", holder.getSource().toString()));
        } else {
            out.openTag("servlet");
        }
        String n = holder.getName();
        out.tag("servlet-name", n);
        String ot = n + ".servlet.";
        if (holder.getForcedPath() != null && holder.getClassName() == null) {
            out.tag("jsp-file", holder.getForcedPath());
        } else {
            out.tag("servlet-class", this.origin(md, ot + "servlet-class"), holder.getClassName());
        }
        for (Object p : holder.getInitParameters().keySet()) {
            if ("jsp".equalsIgnoreCase(n) && "scratchdir".equalsIgnoreCase((String)p)) continue;
            out.openTag("init-param", this.origin(md, ot + "init-param." + (String)p)).tag("param-name", (String)p).tag("param-value", holder.getInitParameter((String)p)).closeTag();
        }
        if (holder.getInitOrder() >= 0) {
            out.tag("load-on-startup", Integer.toString(holder.getInitOrder()));
        }
        if (!holder.isEnabled()) {
            out.tag("enabled", this.origin(md, ot + "enabled"), "false");
        }
        out.tag("async-supported", this.origin(md, ot + "async-supported"), holder.isAsyncSupported() ? "true" : "false");
        if (holder.getRunAsRole() != null) {
            out.openTag("run-as", this.origin(md, ot + "run-as")).tag("role-name", holder.getRunAsRole()).closeTag();
        }
        if ((roles = holder.getRoleLinks()) != null) {
            for (Map.Entry entry : roles.entrySet()) {
                out.openTag("security-role-ref", this.origin(md, ot + "role-name." + (String)entry.getKey())).tag("role-name", (String)entry.getKey()).tag("role-link", (String)entry.getValue()).closeTag();
            }
        }
        if ((multipartConfig = holder.getRegistration().getMultipartConfigElement()) != null) {
            out.openTag("multipart-config", this.origin(md, holder.getName() + ".servlet.multipart-config"));
            if (multipartConfig.getLocation() != null) {
                out.tag("location", multipartConfig.getLocation());
            }
            out.tag("max-file-size", Long.toString(multipartConfig.getMaxFileSize()));
            out.tag("max-request-size", Long.toString(multipartConfig.getMaxRequestSize()));
            out.tag("file-size-threshold", Long.toString(multipartConfig.getFileSizeThreshold()));
            out.closeTag();
        }
        out.closeTag();
    }

    public Map<String, String> origin(MetaData md, String name) {
        if (StringUtil.isBlank((String)this._originAttribute)) {
            return Collections.emptyMap();
        }
        if (name == null) {
            return Collections.emptyMap();
        }
        MetaData.OriginInfo origin = md.getOriginInfo(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("origin of {} is {}", (Object)name, (Object)origin);
        }
        if (origin == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this._originAttribute, String.valueOf(origin) + ":" + this._count++);
    }

    public void preConfigure(WebAppContext context) throws Exception {
        ExtraXmlDescriptorProcessor extraXmlProcessor = new ExtraXmlDescriptorProcessor();
        extraXmlProcessor.setOriginAttribute(this.getOriginAttribute());
        context.getMetaData().addDescriptorProcessor((DescriptorProcessor)extraXmlProcessor);
        context.setAttribute(ExtraXmlDescriptorProcessor.class.getName(), (Object)extraXmlProcessor);
        super.preConfigure(context);
    }

    public void configure(WebAppContext context) throws Exception {
        MetaData metadata = context.getMetaData();
        metadata.resolve(context);
        try (OutputStream os = Files.newOutputStream(this._quickStartWebXml, new OpenOption[0]);){
            this.generateQuickStartWebXml(context, os);
            LOG.info("Generated {}", (Object)this._quickStartWebXml);
            if (context.getAttribute("org.eclipse.jetty.webapp.tmpResourceBase") != null && !context.isTempDirectoryPersistent()) {
                LOG.warn("Generated to non persistent location: {}", (Object)this._quickStartWebXml);
            }
        }
    }

    public void deconfigure(WebAppContext context) throws Exception {
        super.deconfigure(context);
    }
}

