/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.jaas.callback;

import jakarta.servlet.ServletRequest;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.jetty.ee10.jaas.callback.AbstractCallbackHandler;
import org.eclipse.jetty.ee10.jaas.callback.ObjectCallback;
import org.eclipse.jetty.ee10.jaas.callback.RequestParameterCallback;
import org.eclipse.jetty.ee10.jaas.callback.ServletRequestCallback;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.server.Request;

public class DefaultCallbackHandler
extends AbstractCallbackHandler {
    private Request _request;

    public void setRequest(Request request) {
        this._request = request;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            ServletContextRequest servletContextRequest;
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.getUserName());
                continue;
            }
            if (callback instanceof ObjectCallback) {
                ((ObjectCallback)callback).setObject(this.getCredential());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.getCredential().toString().toCharArray());
                continue;
            }
            if (callback instanceof RequestParameterCallback) {
                servletContextRequest = (ServletContextRequest)Request.as((Request)this._request, ServletContextRequest.class);
                if (servletContextRequest == null) continue;
                RequestParameterCallback rpc = (RequestParameterCallback)callback;
                rpc.setParameterValues(Arrays.asList(servletContextRequest.getServletApiRequest().getParameterValues(rpc.getParameterName())));
                continue;
            }
            if (callback instanceof ServletRequestCallback) {
                servletContextRequest = (ServletContextRequest)Request.as((Request)this._request, ServletContextRequest.class);
                ((ServletRequestCallback)callback).setRequest((ServletRequest)servletContextRequest.getServletApiRequest());
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

