/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.zstandard.internal;

import com.github.luben.zstd.EndDirective;
import com.github.luben.zstd.ZstdCompressCtx;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.compression.zstandard.ZstandardCompression;
import org.eclipse.jetty.compression.zstandard.ZstandardEncoderConfig;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZstandardEncoderSink
extends EncoderSink {
    private static final Logger LOG = LoggerFactory.getLogger(ZstandardEncoderSink.class);
    private static final ByteBuffer EMPTY_DIRECT_BUFFER = ByteBuffer.allocateDirect(0);
    private final ZstandardCompression compression;
    private final ZstdCompressCtx compressCtx;
    private final int bufferSize;
    private final AtomicReference<State> state = new AtomicReference<State>(State.CONTINUE);

    public ZstandardEncoderSink(ZstandardCompression compression, Content.Sink sink, ZstandardEncoderConfig config) {
        super(sink);
        this.compression = compression;
        this.bufferSize = config.getBufferSize();
        this.compressCtx = new ZstdCompressCtx();
        this.compressCtx.setLevel(config.getCompressionLevel());
        if (config.getStrategy() >= 0) {
            this.compressCtx.setStrategy(config.getStrategy());
        }
        this.compressCtx.setMagicless(config.isMagicless());
        this.compressCtx.setChecksum(config.isChecksum());
    }

    protected EncoderSink.WriteRecord encode(boolean last, ByteBuffer content) {
        State initialState = this.state.get();
        if (initialState == State.FINISHED) {
            throw new IllegalStateException("Already released");
        }
        boolean done = false;
        EncoderSink.WriteRecord writeRecord = null;
        while (!done) {
            State state = this.state.get();
            switch (state.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    EncoderSink.WriteRecord writeRecord2 = this.continueOp(last, content);
                    break;
                }
                case 1: {
                    EncoderSink.WriteRecord writeRecord2 = this.endOp(last);
                    break;
                }
                case 2: {
                    EncoderSink.WriteRecord writeRecord2 = this.flushOp(last);
                    break;
                }
                case 3: {
                    EncoderSink.WriteRecord writeRecord2 = writeRecord = null;
                }
            }
            if (writeRecord != null) {
                done = true;
                continue;
            }
            if (last || content.hasRemaining()) continue;
            done = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("encode() stateIn={}, last={}, content={}, write={}, stateNow={}", new Object[]{initialState, last, content, writeRecord, this.state});
        }
        return writeRecord;
    }

    protected RetainableByteBuffer ensureDirect(ByteBuffer buffer, int size) {
        if (buffer.isDirect()) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return RetainableByteBuffer.wrap((ByteBuffer)buffer);
        }
        RetainableByteBuffer.Mutable direct = this.compression.acquireByteBuffer(size);
        int pos = buffer.position();
        int limit = buffer.limit();
        int length = Math.min(buffer.remaining(), size);
        buffer.limit(pos + length);
        BufferUtil.flipToFill((ByteBuffer)direct.getByteBuffer());
        direct.getByteBuffer().put(buffer);
        BufferUtil.flipToFlush((ByteBuffer)direct.getByteBuffer(), (int)0);
        buffer.limit(limit);
        buffer.position(pos + length);
        return direct;
    }

    private EncoderSink.WriteRecord continueOp(boolean last, ByteBuffer content) {
        RetainableByteBuffer.Mutable outputBuf = this.compression.acquireByteBuffer(this.bufferSize);
        while (content.hasRemaining()) {
            RetainableByteBuffer inputBuf = this.ensureDirect(content, this.bufferSize);
            while (inputBuf.hasRemaining()) {
                outputBuf.getByteBuffer().clear();
                this.compressCtx.compressDirectByteBufferStream(outputBuf.getByteBuffer(), inputBuf.getByteBuffer(), EndDirective.CONTINUE);
                outputBuf.getByteBuffer().flip();
                if (!outputBuf.getByteBuffer().hasRemaining()) continue;
                Callback writeCallback = Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> ((RetainableByteBuffer)outputBuf).release());
                if (inputBuf.hasRemaining()) {
                    content.position(content.position() - inputBuf.remaining());
                }
                inputBuf.release();
                return new EncoderSink.WriteRecord(false, outputBuf.getByteBuffer(), writeCallback);
            }
            inputBuf.release();
        }
        outputBuf.release();
        if (last) {
            this.state.compareAndSet(State.CONTINUE, State.END);
        }
        return null;
    }

    private EncoderSink.WriteRecord endOp(boolean last) {
        if (!last) {
            throw new IllegalStateException("Directive.END not possible on non-last encode");
        }
        this.state.compareAndSet(State.END, State.FLUSH);
        RetainableByteBuffer.Mutable outputBuf = this.compression.acquireByteBuffer(this.bufferSize);
        outputBuf.getByteBuffer().clear();
        this.compressCtx.compressDirectByteBufferStream(outputBuf.getByteBuffer(), EMPTY_DIRECT_BUFFER, EndDirective.END);
        outputBuf.getByteBuffer().flip();
        if (outputBuf.getByteBuffer().hasRemaining()) {
            Callback writeCallback = Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> ((RetainableByteBuffer)outputBuf).release());
            return new EncoderSink.WriteRecord(false, outputBuf.getByteBuffer(), writeCallback);
        }
        outputBuf.release();
        return null;
    }

    private EncoderSink.WriteRecord flushOp(boolean last) {
        if (!last) {
            throw new IllegalStateException("Directive.END not possible on non-last encode");
        }
        RetainableByteBuffer.Mutable outputBuf = this.compression.acquireByteBuffer(this.bufferSize);
        outputBuf.getByteBuffer().clear();
        boolean actualLast = this.compressCtx.compressDirectByteBufferStream(outputBuf.getByteBuffer(), EMPTY_DIRECT_BUFFER, EndDirective.FLUSH);
        outputBuf.getByteBuffer().flip();
        if (actualLast || outputBuf.getByteBuffer().hasRemaining()) {
            if (actualLast) {
                this.state.compareAndSet(State.FLUSH, State.FINISHED);
            }
            Callback writeCallback = Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> ((RetainableByteBuffer)outputBuf).release());
            return new EncoderSink.WriteRecord(actualLast, outputBuf.getByteBuffer(), writeCallback);
        }
        outputBuf.release();
        return null;
    }

    private static enum State {
        CONTINUE,
        END,
        FLUSH,
        FINISHED;

    }
}

