/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.zstandard;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import org.eclipse.jetty.compression.DecoderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZstandardDecoderConfig
implements DecoderConfig {
    private static final int DEFAULT_BUFFER_SIZE;
    private static final int MIN_BUFFER_SIZE = 32;
    private static final Logger LOG;
    private int bufferSize = DEFAULT_BUFFER_SIZE;
    private boolean magicless = false;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = Math.max(32, size);
    }

    public boolean isMagicless() {
        return this.magicless;
    }

    public void setMagicless(boolean flag) {
        this.magicless = flag;
    }

    static {
        LOG = LoggerFactory.getLogger(ZstandardDecoderConfig.class);
        long bufferSizeCeiling = 256000L;
        long bufferSize = ZstdInputStreamNoFinalizer.recommendedDOutSize();
        if (bufferSize > bufferSizeCeiling) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Lowering zstd-jni recommended/default decoder buffer size of: {} to {}", (Object)bufferSize, (Object)bufferSizeCeiling);
            }
            bufferSize = bufferSizeCeiling;
        }
        DEFAULT_BUFFER_SIZE = (int)bufferSize;
    }
}

