/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.server.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.compression.server.CompressionConfig;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionResponse
extends Response.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionResponse.class);
    private final Compression compression;
    private final CompressionConfig config;
    private final AtomicReference<State> state = new AtomicReference<State>(State.MIGHT_COMPRESS);
    private EncoderSink encoderSink;

    public CompressionResponse(Request request, Response wrapped, Compression compression, CompressionConfig config) {
        super(request, wrapped);
        this.compression = compression;
        this.config = config;
    }

    public void write(boolean last, ByteBuffer content, Callback callback) {
        HttpFields.Mutable headers = this.getHeaders();
        switch (this.state.get().ordinal()) {
            case 0: {
                String mimeType;
                HttpField contentTypeField;
                int status = this.getStatus();
                if (status > 0 && (HttpStatus.isInformational((int)status) || status == 204 || status == 205) && !HttpMethod.HEAD.is(this.getRequest().getMethod())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("no compression for status {} {}", (Object)status, (Object)this);
                    }
                    this.state.compareAndSet(State.MIGHT_COMPRESS, State.NOT_COMPRESSING);
                    super.write(last, content, callback);
                    return;
                }
                if (status == 304) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("no compression for status {} {}", (Object)status, (Object)this);
                    }
                    this.state.compareAndSet(State.MIGHT_COMPRESS, State.NOT_COMPRESSING);
                    headers.computeField(HttpHeader.ETAG, (name, value) -> value == null || value.isEmpty() ? null : new HttpField(HttpHeader.ETAG, this.compression.etag(((HttpField)value.get(0)).getValue())));
                    super.write(last, content, callback);
                }
                if ((contentTypeField = headers.getField(HttpHeader.CONTENT_TYPE)) != null && !this.config.isCompressMimeTypeSupported(mimeType = MimeTypes.getContentTypeWithoutCharset((String)contentTypeField.getValue()))) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("no compression for unsupported content type {} {}", (Object)mimeType, (Object)this);
                    }
                    this.state.compareAndSet(State.MIGHT_COMPRESS, State.NOT_COMPRESSING);
                    super.write(last, content, callback);
                    return;
                }
                String contentEncoding = headers.get(HttpHeader.CONTENT_ENCODING);
                if (contentEncoding != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("no compression for explicit content encoding {} {}", (Object)contentEncoding, (Object)this);
                    }
                    this.state.compareAndSet(State.MIGHT_COMPRESS, State.NOT_COMPRESSING);
                    super.write(last, content, callback);
                    return;
                }
                if (last && BufferUtil.isEmpty((ByteBuffer)content)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("no compression, nothing to write {}", (Object)this);
                    }
                    this.state.compareAndSet(State.MIGHT_COMPRESS, State.NOT_COMPRESSING);
                    super.write(last, content, callback);
                    return;
                }
                long contentLength = headers.getLongField(HttpHeader.CONTENT_LENGTH);
                if (contentLength < 0L && last) {
                    contentLength = BufferUtil.length((ByteBuffer)content);
                }
                if (contentLength >= 0L && contentLength < (long)this.compression.getMinCompressSize()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("no compression, too few content bytes {} {}", (Object)contentLength, (Object)this);
                    }
                    this.state.compareAndSet(State.MIGHT_COMPRESS, State.NOT_COMPRESSING);
                    super.write(last, content, callback);
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("compressing {} {}", (Object)this.compression.getEncodingName(), (Object)this);
                }
                this.state.compareAndSet(State.MIGHT_COMPRESS, State.COMPRESSING);
                this.encoderSink = this.compression.newEncoderSink((Content.Sink)this.getWrapped());
                headers.put(this.compression.getContentEncodingField());
                headers.remove(HttpHeader.CONTENT_LENGTH);
                headers.computeField(HttpHeader.ETAG, (name, value) -> value == null || value.isEmpty() ? null : new HttpField(HttpHeader.ETAG, this.compression.etag(((HttpField)value.get(0)).getValue())));
                this.write(last, content, callback);
                break;
            }
            case 2: {
                this.encoderSink.write(last, content, callback);
                break;
            }
            case 1: {
                super.write(last, content, callback);
            }
        }
    }

    static enum State {
        MIGHT_COMPRESS,
        NOT_COMPRESSING,
        COMPRESSING;

    }
}

