/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.AsciiLowerCaseSet;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

@ManagedObject(value="Compression Configuration")
public class CompressionConfig
extends AbstractLifeCycle {
    private final IncludeExcludeSet<String, String> compressEncodings;
    private final IncludeExcludeSet<String, String> decompressEncodings;
    private final IncludeExcludeSet<String, String> compressMethods;
    private final IncludeExcludeSet<String, String> decompressMethods;
    private final IncludeExcludeSet<String, String> compressMimeTypes;
    private final IncludeExcludeSet<String, String> decompressMimeTypes;
    private final IncludeExcludeSet<String, String> compressPaths;
    private final IncludeExcludeSet<String, String> decompressPaths;
    private final List<String> preferredCompressEncodings;

    private CompressionConfig(Builder builder) {
        this.preferredCompressEncodings = Collections.unmodifiableList(builder.compressPreferredEncodings);
        this.compressEncodings = builder.compressEncodings.asImmutable();
        this.decompressEncodings = builder.decompressEncodings.asImmutable();
        this.compressMethods = builder.compressMethods.asImmutable();
        this.decompressMethods = builder.decompressMethods.asImmutable();
        this.compressMimeTypes = builder.compressMimeTypes.asImmutable();
        this.decompressMimeTypes = builder.decompressMimeTypes.asImmutable();
        this.compressPaths = builder.compressPaths.asImmutable();
        this.decompressPaths = builder.decompressPaths.asImmutable();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ManagedAttribute(value="Encodings that disable response compression")
    public Set<String> getCompressExcludeEncodings() {
        return this.compressEncodings.getExcluded();
    }

    @ManagedAttribute(value="HTTP methods that disable response compression")
    public Set<String> getCompressExcludeMethods() {
        return this.compressMethods.getExcluded();
    }

    @ManagedAttribute(value="MIME types that disable response compression")
    public Set<String> getCompressExcludeMimeTypes() {
        return this.compressMimeTypes.getExcluded();
    }

    @ManagedAttribute(value="Path specs that exclude response compression")
    public Set<String> getCompressExcludePaths() {
        return this.compressPaths.getExcluded();
    }

    @ManagedAttribute(value="Encodings that enable response compression")
    public Set<String> getCompressIncludeEncodings() {
        return this.compressEncodings.getIncluded();
    }

    @ManagedAttribute(value="HTTP methods that enable response compression")
    public Set<String> getCompressIncludeMethods() {
        return this.compressMethods.getIncluded();
    }

    @ManagedAttribute(value="MIME types that enable response compression")
    public Set<String> getCompressIncludeMimeTypes() {
        return this.compressMimeTypes.getIncluded();
    }

    @ManagedAttribute(value="Path specs that enable response compression")
    public Set<String> getCompressIncludePaths() {
        return this.compressPaths.getIncluded();
    }

    @ManagedAttribute(value="Encodings for response compression in preferred order")
    public List<String> getCompressPreferredEncodings() {
        return this.preferredCompressEncodings;
    }

    String getCompressionEncoding(Set<String> supportedEncodings, Request request, List<QuotedQualityCSV.QualityValue> requestAcceptEncoding, String pathInContext) {
        if (requestAcceptEncoding.isEmpty()) {
            return null;
        }
        if (!this.isCompressMethodSupported(request.getMethod())) {
            return null;
        }
        if (!this.compressPaths.test((Object)pathInContext)) {
            return null;
        }
        ArrayList<String> matches = new ArrayList<String>();
        QuotedQualityCSV.QualityValue star = null;
        QuotedQualityCSV.QualityValue identity = null;
        for (QuotedQualityCSV.QualityValue qualityValue : requestAcceptEncoding) {
            String value = qualityValue.getValue();
            if ("*".equals(value)) {
                star = qualityValue;
                continue;
            }
            if ("identity".equalsIgnoreCase(value)) {
                identity = qualityValue;
                continue;
            }
            if (!qualityValue.isAcceptable() || !supportedEncodings.contains(value) || !this.compressEncodings.test((Object)value)) continue;
            matches.add(value);
        }
        List<String> preferred = this.getCompressPreferredEncodings();
        if (matches.isEmpty()) {
            if (star != null && star.isAcceptable()) {
                String candidate = preferred.isEmpty() ? (String)supportedEncodings.stream().findFirst().orElse(null) : (String)preferred.stream().filter(supportedEncodings::contains).findFirst().orElse(null);
                if (!this.compressEncodings.test((Object)candidate)) {
                    candidate = null;
                }
                if (candidate != null) {
                    return candidate;
                }
            }
            if (identity != null && !identity.isAcceptable()) {
                throw new HttpException.RuntimeException(415);
            }
            return null;
        }
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        return preferred.stream().filter(matches::contains).findFirst().orElse((String)matches.get(0));
    }

    @ManagedAttribute(value="HTTP methods that disable request decompression")
    public Set<String> getDecompressExcludeMethods() {
        return this.decompressMethods.getExcluded();
    }

    @ManagedAttribute(value="Path specs that disable request decompression")
    public Set<String> getDecompressExcludePaths() {
        return this.decompressPaths.getExcluded();
    }

    @ManagedAttribute(value="HTTP methods that enable request decompression")
    public Set<String> getDecompressIncludeMethods() {
        return this.decompressMethods.getIncluded();
    }

    @ManagedAttribute(value="Path specs that enable request decompression")
    public Set<String> getDecompressIncludePaths() {
        return this.decompressPaths.getIncluded();
    }

    String getDecompressionEncoding(Set<String> supportedEncodings, Request request, String requestContentEncoding, String pathInContext) {
        if (requestContentEncoding == null) {
            return null;
        }
        if (!supportedEncodings.contains(requestContentEncoding)) {
            return null;
        }
        if (!this.decompressEncodings.test((Object)requestContentEncoding)) {
            return null;
        }
        if (!this.isDecompressMethodSupported(request.getMethod())) {
            return null;
        }
        String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (!this.isDecompressMimeTypeSupported(contentType)) {
            return null;
        }
        if (!this.decompressPaths.test((Object)pathInContext)) {
            return null;
        }
        return requestContentEncoding;
    }

    public boolean isCompressMethodSupported(String method) {
        return this.compressMethods.test((Object)method);
    }

    public boolean isCompressMimeTypeSupported(String mimeType) {
        return this.compressMimeTypes.test((Object)mimeType);
    }

    public boolean isDecompressMethodSupported(String method) {
        return this.decompressMethods.test((Object)method);
    }

    public boolean isDecompressMimeTypeSupported(String mimeType) {
        return this.decompressMimeTypes.test((Object)mimeType);
    }

    public static class Builder {
        private final IncludeExclude<String> decompressEncodings = new IncludeExclude();
        private final IncludeExclude<String> compressEncodings = new IncludeExclude();
        private final IncludeExclude<String> decompressMethods = new IncludeExclude();
        private final IncludeExclude<String> compressMethods = new IncludeExclude();
        private final IncludeExclude<String> decompressPaths = new IncludeExclude(PathSpecSet.class);
        private final IncludeExclude<String> compressPaths = new IncludeExclude(PathSpecSet.class);
        private final IncludeExclude<String> compressMimeTypes = new IncludeExclude(AsciiLowerCaseSet.class);
        private final IncludeExclude<String> decompressMimeTypes = new IncludeExclude(AsciiLowerCaseSet.class);
        private final List<String> compressPreferredEncodings = new ArrayList<String>();

        private Builder() {
        }

        public Builder compressExcludeEncoding(String encoding) {
            this.compressEncodings.exclude((Object)encoding);
            return this;
        }

        public Builder compressExcludeMethod(String method) {
            this.compressMethods.exclude((Object)method);
            return this;
        }

        public Builder compressExcludeMimeType(String mimetype) {
            this.compressMimeTypes.exclude((Object)mimetype);
            return this;
        }

        public Builder compressExcludePath(String pathSpecString) {
            this.compressPaths.exclude((Object)pathSpecString);
            return this;
        }

        public Builder compressIncludeEncoding(String encoding) {
            this.compressEncodings.include((Object)encoding);
            return this;
        }

        public Builder compressIncludeMethod(String method) {
            this.compressMethods.include((Object)method);
            return this;
        }

        public Builder compressIncludeMimeType(String mimetype) {
            this.compressMimeTypes.include((Object)mimetype);
            return this;
        }

        public Builder compressIncludePath(String pathSpecString) {
            this.compressPaths.include((Object)pathSpecString);
            return this;
        }

        public Builder compressPreferredEncodings(List<String> encodings) {
            this.compressPreferredEncodings.clear();
            if (encodings != null) {
                this.compressPreferredEncodings.addAll(encodings);
            }
            return this;
        }

        public Builder decompressExcludeEncoding(String encoding) {
            this.decompressEncodings.exclude((Object)encoding);
            return this;
        }

        public Builder decompressExcludeMethod(String method) {
            this.decompressMethods.exclude((Object)method);
            return this;
        }

        public Builder decompressExcludeMimeType(String mimetype) {
            this.decompressMimeTypes.exclude((Object)mimetype);
            return this;
        }

        public Builder decompressExcludePath(String pathSpecString) {
            this.decompressPaths.exclude((Object)pathSpecString);
            return this;
        }

        public Builder decompressIncludeEncoding(String encoding) {
            this.decompressEncodings.include((Object)encoding);
            return this;
        }

        public Builder decompressIncludeMethod(String method) {
            this.decompressMethods.include((Object)method);
            return this;
        }

        public Builder decompressIncludeMimeType(String mimetype) {
            this.decompressMimeTypes.include((Object)mimetype);
            return this;
        }

        public Builder decompressIncludePath(String pathSpecString) {
            this.decompressPaths.include((Object)pathSpecString);
            return this;
        }

        public Builder defaults() {
            for (String type2 : MimeTypes.DEFAULTS.getMimeMap().values()) {
                if ("image/svg+xml".equals(type2)) {
                    this.compressExcludeMimeType(type2);
                    this.decompressExcludeMimeType(type2);
                    this.compressExcludePath("*.svgz");
                    this.decompressExcludePath("*.svgz");
                    continue;
                }
                if (!type2.startsWith("image/") && !type2.startsWith("audio/") && !type2.startsWith("video/")) continue;
                this.compressExcludeMimeType(type2);
                this.decompressExcludeMimeType(type2);
            }
            Stream.of("application/compress", "application/zip", "application/gzip", "application/x-bzip2", "application/brotli", "application/x-br", "application/x-xz", "application/x-rar-compressed", "application/vnd.bzip3", "application/zstd", "text/event-stream").forEach(type -> {
                this.compressExcludeMimeType((String)type);
                this.decompressExcludeMimeType((String)type);
            });
            this.decompressIncludeMethod(HttpMethod.POST.asString());
            this.compressIncludeMethod(HttpMethod.GET.asString());
            this.compressIncludeMethod(HttpMethod.POST.asString());
            return this;
        }

        public CompressionConfig build() {
            return new CompressionConfig(this);
        }
    }
}

