/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.server;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.AsciiLowerCaseSet;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

@ManagedObject(value="Compression Configuration")
public class CompressionConfig
extends AbstractLifeCycle {
    private final IncludeExcludeSet<String, String> compressEncodings;
    private final IncludeExcludeSet<String, String> decompressEncodings;
    private final IncludeExcludeSet<String, String> compressMethods;
    private final IncludeExcludeSet<String, String> decompressMethods;
    private final IncludeExcludeSet<String, String> compressMimeTypes;
    private final IncludeExcludeSet<String, String> decompressMimeTypes;
    private final IncludeExcludeSet<String, String> compressPaths;
    private final IncludeExcludeSet<String, String> decompressPaths;
    private final HttpField vary;

    private CompressionConfig(Builder builder) {
        this.compressEncodings = builder.compressEncodings.asImmutable();
        this.decompressEncodings = builder.decompressEncodings.asImmutable();
        this.compressMethods = builder.decompressMethods.asImmutable();
        this.decompressMethods = builder.decompressMethods.asImmutable();
        this.compressMimeTypes = builder.compressMimeTypes.asImmutable();
        this.decompressMimeTypes = builder.decompressMimeTypes.asImmutable();
        this.compressPaths = builder.compressPaths.asImmutable();
        this.decompressPaths = builder.decompressPaths.asImmutable();
        this.vary = builder.vary;
    }

    public static Builder builder() {
        return new Builder();
    }

    @ManagedAttribute(value="Set of HTTP Method Exclusions")
    public Set<String> getCompressMethodExcludes() {
        Set excluded = this.compressMethods.getExcluded();
        return Collections.unmodifiableSet(excluded);
    }

    @ManagedAttribute(value="Set of HTTP Method Inclusions")
    public Set<String> getCompressMethodIncludes() {
        Set includes = this.compressMethods.getIncluded();
        return Collections.unmodifiableSet(includes);
    }

    @ManagedAttribute(value="Set of Mime-Types Excluded from Response compression")
    public Set<String> getCompressMimeTypeExcludes() {
        Set excluded = this.compressMimeTypes.getExcluded();
        return Collections.unmodifiableSet(excluded);
    }

    @ManagedAttribute(value="Set of Mime-Types Included in Response compression")
    public Set<String> getCompressMimeTypeIncludes() {
        Set includes = this.compressMimeTypes.getIncluded();
        return Collections.unmodifiableSet(includes);
    }

    @ManagedAttribute(value="Set of Response Compression Path Exclusions")
    public Set<String> getCompressPathExcludes() {
        Set excluded = this.compressPaths.getExcluded();
        return Collections.unmodifiableSet(excluded);
    }

    @ManagedAttribute(value="Set of Response Compression Path Exclusions")
    public Set<String> getCompressPathIncludes() {
        Set includes = this.compressPaths.getIncluded();
        return Collections.unmodifiableSet(includes);
    }

    public String getCompressionEncoding(List<String> requestAcceptEncoding, Request request, String pathInContext) {
        if (requestAcceptEncoding == null || requestAcceptEncoding.isEmpty()) {
            return null;
        }
        String matchedEncoding = null;
        for (String encoding : requestAcceptEncoding) {
            if (!this.compressEncodings.test((Object)encoding)) continue;
            matchedEncoding = encoding;
        }
        if (matchedEncoding == null) {
            return null;
        }
        if (!this.compressMethods.test((Object)request.getMethod())) {
            return null;
        }
        if (!this.compressPaths.test((Object)pathInContext)) {
            return null;
        }
        return matchedEncoding;
    }

    @ManagedAttribute(value="Set of HTTP Method Exclusions")
    public Set<String> getDecompressMethodExcludes() {
        Set excluded = this.decompressMethods.getExcluded();
        return Collections.unmodifiableSet(excluded);
    }

    @ManagedAttribute(value="Set of HTTP Method Inclusions")
    public Set<String> getDecompressMethodIncludes() {
        Set includes = this.decompressMethods.getIncluded();
        return Collections.unmodifiableSet(includes);
    }

    @ManagedAttribute(value="Set of Request Decompression Path Exclusions")
    public Set<String> getDecompressPathExcludes() {
        Set excluded = this.decompressPaths.getExcluded();
        return Collections.unmodifiableSet(excluded);
    }

    @ManagedAttribute(value="Set of Request Decompression Path Inclusions")
    public Set<String> getDecompressPathIncludes() {
        Set includes = this.decompressPaths.getIncluded();
        return Collections.unmodifiableSet(includes);
    }

    public String getDecompressionEncoding(String requestContentEncoding, Request request, String pathInContext) {
        String matchedEncoding = null;
        if (this.decompressEncodings.test((Object)requestContentEncoding)) {
            matchedEncoding = requestContentEncoding;
        }
        if (!this.decompressMethods.test((Object)request.getMethod())) {
            return null;
        }
        String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (!this.decompressMimeTypes.test((Object)contentType)) {
            return null;
        }
        return matchedEncoding;
    }

    public HttpField getVary() {
        return this.vary;
    }

    public boolean isCompressMethodSupported(String method) {
        return this.compressMethods.test((Object)method);
    }

    public boolean isCompressMimeTypeSupported(String mimeType) {
        return this.compressMimeTypes.test((Object)mimeType);
    }

    public boolean isDecompressMethodSupported(String method) {
        return this.decompressMethods.test((Object)method);
    }

    public boolean isDecompressMimeTypeSupported(String mimeType) {
        return this.decompressMimeTypes.test((Object)mimeType);
    }

    public static class Builder {
        private final IncludeExclude<String> decompressEncodings = new IncludeExclude();
        private final IncludeExclude<String> compressEncodings = new IncludeExclude();
        private final IncludeExclude<String> decompressMethods = new IncludeExclude();
        private final IncludeExclude<String> compressMethods = new IncludeExclude();
        private final IncludeExclude<String> decompressPaths = new IncludeExclude(PathSpecSet.class);
        private final IncludeExclude<String> compressPaths = new IncludeExclude(PathSpecSet.class);
        private final IncludeExclude<String> compressMimeTypes = new IncludeExclude(AsciiLowerCaseSet.class);
        private final IncludeExclude<String> decompressMimeTypes = new IncludeExclude(AsciiLowerCaseSet.class);
        private HttpField vary = new PreEncodedHttpField(HttpHeader.VARY, HttpHeader.ACCEPT_ENCODING.asString());

        public CompressionConfig build() {
            return new CompressionConfig(this);
        }

        public Builder compressEncodingExclude(String encoding) {
            this.compressEncodings.exclude((Object)encoding);
            return this;
        }

        public Builder compressEncodingInclude(String encoding) {
            this.compressEncodings.include((Object)encoding);
            return this;
        }

        public Builder compressMethodExclude(String method) {
            this.compressMethods.exclude((Object)method);
            return this;
        }

        public Builder compressMethodInclude(String method) {
            this.compressMethods.include((Object)method);
            return this;
        }

        public Builder compressMimeTypeExclude(String mimetype) {
            this.compressMimeTypes.exclude((Object)mimetype);
            return this;
        }

        public Builder compressMimeTypeInclude(String mimetype) {
            this.compressMimeTypes.include((Object)mimetype);
            return this;
        }

        public Builder compressPathExclude(String pathSpecString) {
            this.compressPaths.exclude((Object)pathSpecString);
            return this;
        }

        public Builder compressPathInclude(String pathSpecString) {
            this.compressPaths.include((Object)pathSpecString);
            return this;
        }

        public Builder decompressEncodingExclude(String encoding) {
            this.decompressEncodings.exclude((Object)encoding);
            return this;
        }

        public Builder decompressEncodingInclude(String encoding) {
            this.decompressEncodings.include((Object)encoding);
            return this;
        }

        public Builder decompressMethodExclude(String method) {
            this.decompressMethods.exclude((Object)method);
            return this;
        }

        public Builder decompressMethodInclude(String method) {
            this.decompressMethods.include((Object)method);
            return this;
        }

        public Builder decompressMimeTypeExclude(String mimetype) {
            this.decompressMimeTypes.exclude((Object)mimetype);
            return this;
        }

        public Builder decompressMimeTypeInclude(String mimetype) {
            this.decompressMimeTypes.include((Object)mimetype);
            return this;
        }

        public Builder decompressPathExclude(String pathSpecString) {
            this.decompressPaths.exclude((Object)pathSpecString);
            return this;
        }

        public Builder decompressPathInclude(String pathSpecString) {
            this.decompressPaths.include((Object)pathSpecString);
            return this;
        }

        public Builder from(MimeTypes mimeTypes) {
            for (String type2 : mimeTypes.getMimeMap().values()) {
                if ("image/svg+xml".equals(type2)) {
                    this.compressMimeTypeExclude(type2);
                    this.decompressMimeTypeExclude(type2);
                    this.compressPathExclude("*.svgz");
                    this.decompressPathExclude("*.svgz");
                    continue;
                }
                if (!type2.startsWith("image/") && !type2.startsWith("audio/") && !type2.startsWith("video/")) continue;
                this.compressMimeTypeExclude(type2);
                this.decompressMimeTypeExclude(type2);
            }
            Stream.of("application/compress", "application/zip", "application/gzip", "application/x-bzip2", "application/brotli", "application/x-br", "application/x-xz", "application/x-rar-compressed", "application/vnd.bzip3", "application/zstd", "text/event-stream").forEach(type -> {
                this.compressMimeTypeExclude((String)type);
                this.decompressMimeTypeExclude((String)type);
            });
            return this;
        }

        public Builder from(CompressionConfig config) {
            this.compressEncodings.addAll(config.compressEncodings);
            this.decompressEncodings.addAll(config.decompressEncodings);
            this.compressMethods.addAll(config.compressMethods);
            this.decompressMethods.addAll(config.decompressMethods);
            this.compressMimeTypes.addAll(config.compressMimeTypes);
            this.decompressMimeTypes.addAll(config.decompressMimeTypes);
            this.compressPaths.addAll(config.compressPaths);
            this.decompressPaths.addAll(config.decompressPaths);
            this.vary = config.vary;
            return this;
        }

        public Builder varyHeader(HttpField vary) {
            this.vary = vary == null || vary instanceof PreEncodedHttpField ? vary : new PreEncodedHttpField(vary.getHeader(), vary.getName(), vary.getValue());
            return this;
        }
    }
}

