/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.DecoderConfig;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.EncoderConfig;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.compression.gzip.GzipDecoderConfig;
import org.eclipse.jetty.compression.gzip.GzipEncoderConfig;
import org.eclipse.jetty.compression.gzip.internal.ConfigurableGzipInputStream;
import org.eclipse.jetty.compression.gzip.internal.ConfigurableGzipOutputStream;
import org.eclipse.jetty.compression.gzip.internal.GzipDecoderSource;
import org.eclipse.jetty.compression.gzip.internal.GzipEncoderSink;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;

public class GzipCompression
extends Compression {
    private static final int DEFAULT_MIN_GZIP_SIZE = 32;
    private static final List<String> EXTENSIONS = List.of("gz", "gzip");
    private static final String ENCODING_NAME = "gzip";
    private static final HttpField X_CONTENT_ENCODING = new PreEncodedHttpField("X-Content-Encoding", "gzip");
    private static final HttpField CONTENT_ENCODING = new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, "gzip");
    private DeflaterPool deflaterPool;
    private InflaterPool inflaterPool;
    private GzipEncoderConfig defaultEncoderConfig = new GzipEncoderConfig();
    private GzipDecoderConfig defaultDecoderConfig = new GzipDecoderConfig();

    public GzipCompression() {
        super(ENCODING_NAME);
        this.setMinCompressSize(32);
    }

    public RetainableByteBuffer acquireByteBuffer() {
        return this.acquireByteBuffer(this.getBufferSize());
    }

    public RetainableByteBuffer acquireByteBuffer(int length) {
        if (length == 0) {
            return RetainableByteBuffer.EMPTY;
        }
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(length, false);
        buffer.getByteBuffer().order(this.getByteOrder());
        return buffer;
    }

    public HttpField getContentEncodingField() {
        return CONTENT_ENCODING;
    }

    public DecoderConfig getDefaultDecoderConfig() {
        return this.defaultDecoderConfig;
    }

    public void setDefaultDecoderConfig(DecoderConfig config) {
        this.defaultDecoderConfig = (GzipDecoderConfig)config;
    }

    public EncoderConfig getDefaultEncoderConfig() {
        return this.defaultEncoderConfig;
    }

    public void setDefaultEncoderConfig(EncoderConfig config) {
        this.defaultEncoderConfig = (GzipEncoderConfig)config;
    }

    public DeflaterPool getDeflaterPool() {
        return this.deflaterPool;
    }

    public void setDeflaterPool(DeflaterPool deflaterPool) {
        this.deflaterPool = deflaterPool;
    }

    public List<String> getFileExtensionNames() {
        return EXTENSIONS;
    }

    public InflaterPool getInflaterPool() {
        return this.inflaterPool;
    }

    public void setInflaterPool(InflaterPool inflaterPool) {
        this.inflaterPool = inflaterPool;
    }

    public void setMinCompressSize(int minCompressSize) {
        super.setMinCompressSize(Math.max(minCompressSize, 32));
    }

    public String getName() {
        return ENCODING_NAME;
    }

    public HttpField getXContentEncodingField() {
        return X_CONTENT_ENCODING;
    }

    public InputStream newDecoderInputStream(InputStream in, DecoderConfig config) throws IOException {
        GzipDecoderConfig gzipDecoderConfig = (GzipDecoderConfig)config;
        return new ConfigurableGzipInputStream(in, gzipDecoderConfig);
    }

    public DecoderSource newDecoderSource(Content.Source source, DecoderConfig config) {
        GzipDecoderConfig gzipDecoderConfig = (GzipDecoderConfig)config;
        return new GzipDecoderSource(source, this, gzipDecoderConfig);
    }

    public OutputStream newEncoderOutputStream(OutputStream out, EncoderConfig config) throws IOException {
        GzipEncoderConfig gzipEncoderConfig = (GzipEncoderConfig)config;
        return new ConfigurableGzipOutputStream(out, gzipEncoderConfig);
    }

    public EncoderSink newEncoderSink(Content.Sink sink, EncoderConfig config) {
        GzipEncoderConfig gzipEncoderConfig = (GzipEncoderConfig)config;
        return new GzipEncoderSink(this, sink, gzipEncoderConfig);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.deflaterPool == null) {
            this.deflaterPool = DeflaterPool.ensurePool((Container)this.getContainer());
        }
        this.addBean(this.deflaterPool);
        if (this.inflaterPool == null) {
            this.inflaterPool = InflaterPool.ensurePool((Container)this.getContainer());
        }
        this.addBean(this.inflaterPool);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.inflaterPool);
        this.inflaterPool = null;
        this.removeBean(this.deflaterPool);
        this.deflaterPool = null;
    }

    private ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

