/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.brotli;

import com.aayushatharva.brotli4j.encoder.EncoderJNI;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.compression.brotli.BrotliCompression;
import org.eclipse.jetty.compression.brotli.BrotliEncoderConfig;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrotliEncoderSink
extends EncoderSink {
    private static final Logger LOG = LoggerFactory.getLogger(BrotliEncoderSink.class);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final BrotliCompression compression;
    private final EncoderJNI.Wrapper encoder;
    private final ByteBuffer inputBuffer;
    private final AtomicReference<State> state = new AtomicReference<State>(State.PROCESSING);

    public BrotliEncoderSink(BrotliCompression compression, Content.Sink sink, BrotliEncoderConfig config) {
        super(sink);
        this.compression = compression;
        try {
            this.encoder = new EncoderJNI.Wrapper(config.getBufferSize(), config.getCompressionLevel(), config.getLgWindow(), config.getMode());
            this.inputBuffer = this.encoder.getInputBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EncoderSink.WriteRecord encode(boolean last, ByteBuffer content) {
        if (this.encoder.isFinished()) {
            return null;
        }
        block10: while (true) {
            switch (this.state.get().ordinal()) {
                case 0: {
                    try {
                        while (content.hasRemaining()) {
                            ByteBuffer output2;
                            if (!this.inputBuffer.hasRemaining() && (output2 = this.encode(EncoderJNI.Operation.PROCESS)) != null) {
                                EncoderSink.WriteRecord writeRecord = new EncoderSink.WriteRecord(false, output2, Callback.NOOP);
                                return writeRecord;
                            }
                            int output2 = BufferUtil.put((ByteBuffer)content, (ByteBuffer)this.inputBuffer);
                        }
                        if (last) continue block10;
                        EncoderSink.WriteRecord output2 = null;
                        return output2;
                    }
                    finally {
                        if (!last) continue block10;
                        this.state.compareAndSet(State.PROCESSING, State.FLUSHING);
                        continue block10;
                    }
                }
                case 1: {
                    this.inputBuffer.limit(this.inputBuffer.position());
                    ByteBuffer output = this.encode(EncoderJNI.Operation.FLUSH);
                    this.state.compareAndSet(State.FLUSHING, State.FINISHING);
                    if (output == null) continue block10;
                    return new EncoderSink.WriteRecord(false, output, Callback.NOOP);
                }
                case 2: {
                    this.inputBuffer.limit(this.inputBuffer.position());
                    ByteBuffer output = this.encode(EncoderJNI.Operation.FINISH);
                    this.state.compareAndSet(State.FINISHING, State.FINISHED);
                    return new EncoderSink.WriteRecord(true, output != null ? output : EMPTY_BUFFER, Callback.NOOP);
                }
                case 3: {
                    return null;
                }
            }
        }
    }

    protected ByteBuffer encode(EncoderJNI.Operation op) {
        try {
            boolean inputPushed = false;
            ByteBuffer output = null;
            while (true) {
                if (!this.encoder.isSuccess()) {
                    throw new IOException("Brotli Encoder failure");
                }
                if (this.encoder.hasMoreOutput()) {
                    output = this.encoder.pull();
                    continue;
                }
                if (this.encoder.hasRemainingInput()) {
                    this.encoder.push(op, 0);
                    continue;
                }
                if (inputPushed) break;
                this.encoder.push(op, this.inputBuffer.limit());
                inputPushed = true;
            }
            this.inputBuffer.clear();
            return output;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void release() {
        this.encoder.destroy();
    }

    private State getState() {
        return this.state.get();
    }

    static enum State {
        PROCESSING,
        FLUSHING,
        FINISHING,
        FINISHED;

    }
}

