/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jetty.compression.DecoderConfig;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.EncoderConfig;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.http.EtagUtils;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Compression
extends ContainerLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(Compression.class);
    private final String encodingName;
    private final String etagSuffix;
    private final String etagSuffixQuote;
    private ByteBufferPool byteBufferPool;
    private Container container;
    private int bufferSize = 2048;

    public Compression(String encoding) {
        this.encodingName = encoding;
        this.etagSuffix = StringUtil.isEmpty((String)EtagUtils.ETAG_SEPARATOR) ? "" : EtagUtils.ETAG_SEPARATOR + this.encodingName;
        this.etagSuffixQuote = this.etagSuffix + "\"";
    }

    public boolean acceptsCompression(HttpFields headers, long contentLength) {
        if (contentLength >= 0L && contentLength < (long)this.getMinCompressSize()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} excluded minCompressSize {}", (Object)this, (Object)headers);
            }
            return false;
        }
        if (!headers.contains(HttpHeader.ACCEPT_ENCODING, this.getEncodingName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} excluded not {} acceptable {}", new Object[]{this, this.getEncodingName(), headers});
            }
            return false;
        }
        return true;
    }

    public abstract RetainableByteBuffer acquireByteBuffer();

    public abstract RetainableByteBuffer acquireByteBuffer(int var1);

    public String etag(String etag) {
        if (StringUtil.isEmpty((String)EtagUtils.ETAG_SEPARATOR)) {
            return etag;
        }
        int end = etag.length() - 1;
        if (etag.charAt(end) == '\"') {
            return etag.substring(0, end) + this.etagSuffixQuote;
        }
        return etag + this.etagSuffix;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid buffer size: " + size);
        }
        this.bufferSize = size;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        this.byteBufferPool = byteBufferPool;
    }

    public Container getContainer() {
        return this.container != null ? this.container : this;
    }

    public void setContainer(Container container) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set container on running component");
        }
        this.container = container;
    }

    public abstract HttpField getContentEncodingField();

    public abstract DecoderConfig getDefaultDecoderConfig();

    public abstract void setDefaultDecoderConfig(DecoderConfig var1);

    public abstract EncoderConfig getDefaultEncoderConfig();

    public abstract void setDefaultEncoderConfig(EncoderConfig var1);

    public String getEncodingName() {
        return this.encodingName;
    }

    public String getEtagSuffix() {
        return this.etagSuffix;
    }

    public abstract List<String> getFileExtensionNames();

    public abstract int getMinCompressSize();

    public abstract void setMinCompressSize(int var1);

    public abstract String getName();

    public abstract HttpField getXContentEncodingField();

    public InputStream newDecoderInputStream(InputStream in) throws IOException {
        return this.newDecoderInputStream(in, this.getDefaultDecoderConfig());
    }

    public abstract InputStream newDecoderInputStream(InputStream var1, DecoderConfig var2) throws IOException;

    public DecoderSource newDecoderSource(Content.Source source) {
        return this.newDecoderSource(source, this.getDefaultDecoderConfig());
    }

    public abstract DecoderSource newDecoderSource(Content.Source var1, DecoderConfig var2);

    public OutputStream newEncoderOutputStream(OutputStream out) throws IOException {
        return this.newEncoderOutputStream(out, this.getDefaultEncoderConfig());
    }

    public abstract OutputStream newEncoderOutputStream(OutputStream var1, EncoderConfig var2) throws IOException;

    public EncoderSink newEncoderSink(Content.Sink sink) {
        return this.newEncoderSink(sink, this.getDefaultEncoderConfig());
    }

    public abstract EncoderSink newEncoderSink(Content.Sink var1, EncoderConfig var2);

    public String stripSuffixes(String etagsList) {
        if (StringUtil.isEmpty((String)EtagUtils.ETAG_SEPARATOR)) {
            return etagsList;
        }
        int i;
        while ((i = ((String)etagsList).lastIndexOf(this.etagSuffix)) >= 0) {
            etagsList = ((String)etagsList).substring(0, i) + ((String)etagsList).substring(i + this.etagSuffix.length());
        }
        return etagsList;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.byteBufferPool == null) {
            this.byteBufferPool = ByteBufferPool.NON_POOLING;
        }
    }
}

