/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.cdi.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContext;
import org.eclipse.jetty.cdi.servlet.JettyWeldInitializer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.jboss.weld.environment.servlet.EnhancedListener;

public class EmbeddedCdiHandler
extends ServletContextHandler {
    private static final Logger LOG = Log.getLogger(EmbeddedCdiHandler.class);
    private static final String[] REQUIRED_BEANS_XML_PATHS = new String[]{"/WEB-INF/beans.xml", "/META-INF/beans.xml", "/WEB-INF/classes/META-INF/beans.xml"};

    public EmbeddedCdiHandler() {
    }

    public EmbeddedCdiHandler(int options) {
        super(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        Resource baseResource = this.getBaseResource();
        if (baseResource == null) {
            throw new NullPointerException("baseResource must be set (to so it can find the beans.xml)");
        }
        boolean foundBeansXml = false;
        for (String beansXmlPath : REQUIRED_BEANS_XML_PATHS) {
            Resource res = baseResource.addPath(beansXmlPath);
            if (res == null) continue;
            if (res.exists()) {
                foundBeansXml = true;
            }
            if (!res.isDirectory()) continue;
            throw new IOException("Directory conflicts with expected file: " + res.getURI().toASCIIString());
        }
        if (!foundBeansXml) {
            StringBuilder err = new StringBuilder();
            err.append("Unable to find required beans.xml from the baseResource: ");
            err.append(baseResource.getURI().toASCIIString()).append(System.lineSeparator());
            err.append("Searched for: ");
            for (String beansXmlPath : REQUIRED_BEANS_XML_PATHS) {
                err.append(System.lineSeparator());
                err.append("  ").append(beansXmlPath);
            }
            LOG.warn("ERROR: {}", new Object[]{err.toString()});
            throw new IOException(err.toString());
        }
        JettyWeldInitializer.initContext((ContextHandler)this);
        ContextHandler.Context ctx = this.getServletContext();
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ctx.getClassLoader());
            EnhancedListener weldListener = new EnhancedListener();
            Set classes = Collections.emptySet();
            weldListener.onStartup(classes, (ServletContext)ctx);
            ctx.addListener((EventListener)weldListener);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        super.doStart();
    }
}

