/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class ShutdownMonitor
extends Thread {
    private boolean DEBUG;
    private int port;
    private String key;
    private boolean exitVm;
    private ServerSocket serverSocket;

    public static ShutdownMonitor getInstance() {
        return Holder.instance;
    }

    private ShutdownMonitor() {
        Properties props = System.getProperties();
        this.DEBUG = props.containsKey("DEBUG");
        this.port = Integer.parseInt(props.getProperty("STOP.PORT", "-1"));
        this.key = props.getProperty("STOP.KEY", "eclipse");
        this.exitVm = true;
    }

    private void close(ServerSocket server) {
        if (server == null) {
            return;
        }
        try {
            server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void close(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void debug(String format, Object ... args) {
        if (this.DEBUG) {
            System.err.printf("[ShutdownMonitor] " + format + "%n", args);
        }
    }

    private void debug(Throwable t) {
        if (this.DEBUG) {
            t.printStackTrace(System.err);
        }
    }

    public String getKey() {
        return this.key;
    }

    public int getPort() {
        return this.port;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public boolean isExitVm() {
        return this.exitVm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.serverSocket == null) {
            return;
        }
        while (true) {
            Object var7_7;
            Socket socket;
            block11: {
                if (this.serverSocket == null) {
                    return;
                }
                socket = null;
                try {
                    try {
                        socket = this.serverSocket.accept();
                        LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                        String key = lin.readLine();
                        if (!this.key.equals(key)) {
                            System.err.println("Ignoring command with incorrect key");
                            var7_7 = null;
                            this.close(socket);
                            socket = null;
                            continue;
                        }
                        OutputStream out = socket.getOutputStream();
                        String cmd = lin.readLine();
                        this.debug("command=%s", cmd);
                        if ("stop".equals(cmd)) {
                            this.debug("Issuing graceful shutdown..", new Object[0]);
                            ShutdownThread.getInstance().run();
                            this.debug("Informing client that we are stopped.", new Object[0]);
                            out.write("Stopped\r\n".getBytes("UTF-8"));
                            out.flush();
                            this.debug("Shutting down monitor", new Object[0]);
                            this.close(socket);
                            socket = null;
                            this.close(this.serverSocket);
                            this.serverSocket = null;
                            if (this.exitVm) {
                                this.debug("Killing JVM", new Object[0]);
                                System.exit(0);
                            }
                            break block11;
                        }
                        if ("status".equals(cmd)) {
                            out.write("OK\r\n".getBytes("UTF-8"));
                            out.flush();
                        }
                    }
                    catch (Exception e) {
                        this.debug(e);
                        System.err.println(e.toString());
                        var7_7 = null;
                        this.close(socket);
                        socket = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var7_7 = null;
                    this.close(socket);
                    socket = null;
                    throw throwable;
                }
            }
            var7_7 = null;
            this.close(socket);
            socket = null;
        }
    }

    public void setDebug(boolean flag) {
        this.DEBUG = flag;
    }

    public void setExitVm(boolean exitVm) {
        if (this.isAlive()) {
            throw new IllegalStateException("ShutdownMonitor already started");
        }
        this.exitVm = exitVm;
    }

    public void setKey(String key) {
        if (this.isAlive()) {
            throw new IllegalStateException("ShutdownMonitor already started");
        }
        this.key = key;
    }

    public void setPort(int port) {
        if (this.isAlive()) {
            throw new IllegalStateException("ShutdownMonitor already started");
        }
        this.port = port;
    }

    public void start() {
        if (this.isAlive()) {
            System.err.printf("ShutdownMonitor already started", new Object[0]);
            return;
        }
        this.startListenSocket();
        if (this.serverSocket == null) {
            return;
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startListenSocket() {
        if (this.port < 0) {
            if (!this.DEBUG) return;
            System.err.println("ShutdownMonitor not in use (port < 0): " + this.port);
            return;
        }
        try {
            block6: {
                try {
                    this.setDaemon(true);
                    this.setName("ShutdownMonitor");
                    this.serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName("127.0.0.1"));
                    if (this.port == 0) {
                        this.port = this.serverSocket.getLocalPort();
                        System.out.printf("STOP.PORT=%d%n", this.port);
                    }
                    if (this.key != null) break block6;
                    this.key = Long.toString((long)(9.223372036854776E18 * Math.random() + (double)this.hashCode() + (double)System.currentTimeMillis()), 36);
                    System.out.printf("STOP.KEY=%s%n", this.key);
                }
                catch (Exception e) {
                    this.debug(e);
                    System.err.println("Error binding monitor port " + this.port + ": " + e.toString());
                    Object var3_2 = null;
                    this.debug("STOP.PORT=%d", this.port);
                    this.debug("STOP.KEY=%s", this.key);
                    this.debug("%s", this.serverSocket);
                    return;
                }
            }
            Object var3_1 = null;
            this.debug("STOP.PORT=%d", this.port);
            this.debug("STOP.KEY=%s", this.key);
            this.debug("%s", this.serverSocket);
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.debug("STOP.PORT=%d", this.port);
            this.debug("STOP.KEY=%s", this.key);
            this.debug("%s", this.serverSocket);
            throw throwable;
        }
    }

    public String toString() {
        return String.format("%s[port=%d]", this.getClass().getName(), this.port);
    }

    static class Holder {
        static ShutdownMonitor instance = new ShutdownMonitor();

        Holder() {
        }
    }
}

