/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.HashedSession;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Logger;

public class HashSessionManager
extends AbstractSessionManager {
    static final Logger __log = SessionHandler.LOG;
    protected final ConcurrentMap<String, HashedSession> _sessions = new ConcurrentHashMap<String, HashedSession>();
    private static int __id;
    private Timer _timer;
    private boolean _timerStop = false;
    private TimerTask _task;
    int _scavengePeriodMs = 30000;
    int _savePeriodMs = 0;
    int _idleSavePeriodMs = 0;
    private TimerTask _saveTask;
    File _storeDir;
    private boolean _lazyLoad = false;
    private volatile boolean _sessionsLoaded = false;

    public void doStart() throws Exception {
        super.doStart();
        this._timerStop = false;
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context != null) {
            this._timer = (Timer)context.getAttribute("org.eclipse.jetty.server.session.timer");
        }
        if (this._timer == null) {
            this._timerStop = true;
            this._timer = new Timer("HashSessionScavenger-" + __id++, true);
        }
        this.setScavengePeriod(this.getScavengePeriod());
        if (this._storeDir != null) {
            if (!this._storeDir.exists()) {
                this._storeDir.mkdirs();
            }
            if (!this._lazyLoad) {
                this.restoreSessions();
            }
        }
        this.setSavePeriod(this.getSavePeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            if (this._saveTask != null) {
                this._saveTask.cancel();
            }
            this._saveTask = null;
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            if (this._timer != null && this._timerStop) {
                this._timer.cancel();
            }
            this._timer = null;
        }
        super.doStop();
        this._sessions.clear();
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    public int getSessions() {
        int sessions = super.getSessions();
        if (__log.isDebugEnabled() && this._sessions.size() != sessions) {
            __log.warn("sessions: " + this._sessions.size() + "!=" + sessions, new Object[0]);
        }
        return sessions;
    }

    public int getIdleSavePeriod() {
        if (this._idleSavePeriodMs <= 0) {
            return 0;
        }
        return this._idleSavePeriodMs / 1000;
    }

    public void setIdleSavePeriod(int seconds) {
        this._idleSavePeriodMs = seconds * 1000;
    }

    public void setMaxInactiveInterval(int seconds) {
        super.setMaxInactiveInterval(seconds);
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 1000) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSavePeriod(int seconds) {
        int period = seconds * 1000;
        if (period < 0) {
            period = 0;
        }
        this._savePeriodMs = period;
        if (this._timer != null) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._saveTask != null) {
                    this._saveTask.cancel();
                }
                if (this._savePeriodMs > 0 && this._storeDir != null) {
                    this._saveTask = new TimerTask(){

                        public void run() {
                            try {
                                HashSessionManager.this.saveSessions(true);
                            }
                            catch (Exception e) {
                                __log.warn(e);
                            }
                        }
                    };
                    this._timer.schedule(this._saveTask, this._savePeriodMs, (long)this._savePeriodMs);
                }
            }
        }
    }

    public int getSavePeriod() {
        if (this._savePeriodMs <= 0) {
            return 0;
        }
        return this._savePeriodMs / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        int old_period = this._scavengePeriodMs;
        int period = seconds * 1000;
        if (period > 60000) {
            period = 60000;
        }
        if (period < 1000) {
            period = 1000;
        }
        this._scavengePeriodMs = period;
        if (this._timer != null && (period != old_period || this._task == null)) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._task != null) {
                    this._task.cancel();
                }
                this._task = new TimerTask(){

                    public void run() {
                        HashSessionManager.this.scavenge();
                    }
                };
                this._timer.schedule(this._task, this._scavengePeriodMs, (long)this._scavengePeriodMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long now = System.currentTimeMillis();
            for (HashedSession session : this._sessions.values()) {
                long idleTime = session.getMaxInactiveInterval() * 1000;
                if (idleTime > 0L && session.getAccessed() + idleTime < now) {
                    session.timeout();
                    continue;
                }
                if (this._idleSavePeriodMs <= 0 || session.getAccessed() + (long)this._idleSavePeriodMs >= now) continue;
                session.idle();
            }
        }
        catch (Throwable t) {
            __log.warn("Problem scavenging sessions", t);
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    protected void addSession(AbstractSession session) {
        if (this.isRunning()) {
            this._sessions.put(session.getClusterId(), (HashedSession)session);
        }
    }

    public AbstractSession getSession(String idInCluster) {
        ConcurrentMap<String, HashedSession> sessions;
        if (this._lazyLoad && !this._sessionsLoaded) {
            try {
                this.restoreSessions();
            }
            catch (Exception e) {
                __log.warn(e);
            }
        }
        if ((sessions = this._sessions) == null) {
            return null;
        }
        HashedSession session = (HashedSession)sessions.get(idInCluster);
        if (session == null && this._lazyLoad) {
            session = this.restoreSession(idInCluster);
        }
        if (session == null) {
            return null;
        }
        if (this._idleSavePeriodMs != 0) {
            session.deIdle();
        }
        return session;
    }

    protected void invalidateSessions() throws Exception {
        ArrayList sessions = new ArrayList(this._sessions.values());
        int loop = 100;
        while (sessions.size() > 0 && loop-- > 0) {
            if (this.isStopping() && this._storeDir != null && this._storeDir.exists() && this._storeDir.canWrite()) {
                for (HashedSession session : sessions) {
                    session.save(false);
                    this.removeSession(session, false);
                }
            } else {
                for (HashedSession session : sessions) {
                    session.invalidate();
                }
            }
            sessions = new ArrayList(this._sessions.values());
        }
    }

    protected AbstractSession newSession(HttpServletRequest request) {
        return new HashedSession(this, request);
    }

    protected AbstractSession newSession(long created, long accessed, String clusterId) {
        return new HashedSession(this, created, accessed, clusterId);
    }

    protected boolean removeSession(String clusterId) {
        return this._sessions.remove(clusterId) != null;
    }

    public void setStoreDirectory(File dir) {
        this._storeDir = dir;
    }

    public File getStoreDirectory() {
        return this._storeDir;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this._lazyLoad = lazyLoad;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    public void restoreSessions() throws Exception {
        this._sessionsLoaded = true;
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canRead()) {
            __log.warn("Unable to restore Sessions: Cannot read from Session storage directory " + this._storeDir.getAbsolutePath(), new Object[0]);
            return;
        }
        String[] files = this._storeDir.list();
        for (int i = 0; files != null && i < files.length; ++i) {
            this.restoreSession(files[i]);
        }
    }

    protected synchronized HashedSession restoreSession(String idInCuster) {
        try {
            File file = new File(this._storeDir, idInCuster);
            if (file.exists()) {
                FileInputStream in = new FileInputStream(file);
                HashedSession session = this.restoreSession(in, null);
                in.close();
                this.addSession(session, false);
                session.didActivate();
                file.delete();
                return session;
            }
        }
        catch (Exception e) {
            __log.warn("Problem restoring session " + idInCuster, e);
        }
        return null;
    }

    public void saveSessions(boolean reactivate) throws Exception {
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canWrite()) {
            __log.warn("Unable to save Sessions: Session persistence storage directory " + this._storeDir.getAbsolutePath() + " is not writeable", new Object[0]);
            return;
        }
        for (HashedSession session : this._sessions.values()) {
            session.save(true);
        }
    }

    public HashedSession restoreSession(InputStream is, HashedSession session) throws Exception {
        DataInputStream in = new DataInputStream(is);
        String clusterId = in.readUTF();
        in.readUTF();
        long created = in.readLong();
        long accessed = in.readLong();
        int requests = in.readInt();
        if (session == null) {
            session = (HashedSession)this.newSession(created, accessed, clusterId);
        }
        session.setRequests(requests);
        int size = in.readInt();
        if (size > 0) {
            ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(in);
            for (int i = 0; i < size; ++i) {
                String key = ois.readUTF();
                Object value = ois.readObject();
                session.setAttribute(key, value);
            }
            ois.close();
        } else {
            in.close();
        }
        return session;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassLoadingObjectInputStream
    extends ObjectInputStream {
        public ClassLoadingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        public ClassLoadingObjectInputStream() throws IOException {
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass cl) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(cl.getName(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(cl);
            }
        }
    }
}

