/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public class UserAuthentication
implements Authentication.User {
    private final Authenticator _authenticator;
    private final UserIdentity _userIdentity;

    public UserAuthentication(Authenticator authenticator, UserIdentity userIdentity) {
        this._authenticator = authenticator;
        this._userIdentity = userIdentity;
    }

    @Override
    public String getAuthMethod() {
        return this._authenticator.getAuthMethod();
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }

    @Override
    public boolean isUserInRole(UserIdentity.Scope scope, String role) {
        return this._userIdentity.isUserInRole(role, scope);
    }

    @Override
    public void logout() {
        IdentityService id_service;
        Authenticator authenticator = this._authenticator;
        if (authenticator instanceof LoginAuthenticator && (id_service = ((LoginAuthenticator)authenticator).getLoginService().getIdentityService()) != null) {
            id_service.disassociate(null);
        }
    }

    public String toString() {
        return "{Auth," + this.getAuthMethod() + "," + this._userIdentity + "}";
    }
}

