/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceCollection
extends Resource {
    private Resource[] _resources;

    public ResourceCollection() {
    }

    public ResourceCollection(Resource[] resources) {
        this.setResources(resources);
    }

    public ResourceCollection(String[] resources) {
        this.setResources(resources);
    }

    public ResourceCollection(String csvResources) {
        this.setResources(csvResources);
    }

    public void setResources(Resource[] resources) {
        if (this._resources != null) {
            throw new IllegalStateException("*resources* already set.");
        }
        if (resources == null) {
            throw new IllegalArgumentException("*resources* must not be null.");
        }
        if (resources.length == 0) {
            throw new IllegalArgumentException("arg *resources* must be one or more resources.");
        }
        for (Resource r : this._resources = resources) {
            if (r.exists() && r.isDirectory()) continue;
            throw new IllegalArgumentException(r + " is not an existing directory.");
        }
    }

    public void setResources(String[] resources) {
        if (this._resources != null) {
            throw new IllegalStateException("*resources* already set.");
        }
        if (resources == null) {
            throw new IllegalArgumentException("*resources* must not be null.");
        }
        if (resources.length == 0) {
            throw new IllegalArgumentException("arg *resources* must be one or more resources.");
        }
        this._resources = new Resource[resources.length];
        try {
            for (int i = 0; i < resources.length; ++i) {
                this._resources[i] = Resource.newResource(resources[i]);
                if (this._resources[i].exists() && this._resources[i].isDirectory()) continue;
                throw new IllegalArgumentException(this._resources[i] + " is not an existing directory.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setResources(String csvResources) {
        if (this._resources != null) {
            throw new IllegalStateException("*resources* already set.");
        }
        if (csvResources == null) {
            throw new IllegalArgumentException("*csvResources* must not be null.");
        }
        StringTokenizer tokenizer = new StringTokenizer(csvResources, ",;");
        int len = tokenizer.countTokens();
        if (len == 0) {
            throw new IllegalArgumentException("arg *resources* must be one or more resources.");
        }
        this._resources = new Resource[len];
        try {
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this._resources[i] = Resource.newResource(tokenizer.nextToken().trim());
                if (!this._resources[i].exists() || !this._resources[i].isDirectory()) {
                    throw new IllegalArgumentException(this._resources[i] + " is not an existing directory.");
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setResourcesAsCSV(String csvResources) {
        this.setResources(csvResources);
    }

    public Resource[] getResources() {
        return this._resources;
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        int i;
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        if (path == null) {
            throw new MalformedURLException();
        }
        if (path.length() == 0 || "/".equals(path)) {
            return this;
        }
        Resource resource = null;
        ArrayList<Resource> resources = null;
        for (i = 0; i < this._resources.length; ++i) {
            resource = this._resources[i].addPath(path);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++i;
        while (i < this._resources.length) {
            Resource r = this._resources[i].addPath(path);
            if (r.exists() && r.isDirectory()) {
                if (resource != null) {
                    resources = new ArrayList<Resource>();
                    resources.add(resource);
                    resource = null;
                }
                resources.add(r);
            }
            ++i;
        }
        if (resource != null) {
            return resource;
        }
        if (resources != null) {
            return new ResourceCollection(resources.toArray(new Resource[resources.size()]));
        }
        return null;
    }

    protected Object findResource(String path) throws IOException, MalformedURLException {
        int i;
        Resource resource = null;
        ArrayList<Resource> resources = null;
        for (i = 0; i < this._resources.length; ++i) {
            resource = this._resources[i].addPath(path);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++i;
        while (i < this._resources.length) {
            Resource r = this._resources[i].addPath(path);
            if (r.exists() && r.isDirectory()) {
                if (resource != null) {
                    resources = new ArrayList<Resource>();
                    resources.add(resource);
                }
                resources.add(r);
            }
            ++i;
        }
        if (resource != null) {
            return resource;
        }
        if (resources != null) {
            return resources;
        }
        return null;
    }

    public boolean delete() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        return true;
    }

    public File getFile() throws IOException {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            File f = r.getFile();
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            InputStream is = r.getInputStream();
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public String getName() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            String name = r.getName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            OutputStream os = r.getOutputStream();
            if (os == null) continue;
            return os;
        }
        return null;
    }

    public URL getURL() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            URL url = r.getURL();
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public boolean isDirectory() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        return true;
    }

    public long lastModified() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            long lm = r.lastModified();
            if (lm == -1L) continue;
            return lm;
        }
        return -1L;
    }

    public long length() {
        return -1L;
    }

    public String[] list() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        HashSet<String> set = new HashSet<String>();
        for (Resource r : this._resources) {
            for (String s : r.list()) {
                set.add(s);
            }
        }
        Object[] result = set.toArray(new String[set.size()]);
        Arrays.sort(result);
        return result;
    }

    public void release() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            r.release();
        }
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public void copyTo(File destination) throws IOException {
        int r = this._resources.length;
        while (r-- > 0) {
            this._resources[r].copyTo(destination);
        }
    }

    public String toString() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        StringBuilder buffer = new StringBuilder();
        for (Resource r : this._resources) {
            buffer.append(r.toString()).append(';');
        }
        return buffer.toString();
    }

    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }
}

