/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

public abstract class AbstractSessionManager
extends AbstractLifeCycle
implements SessionManager {
    public Set<SessionTrackingMode> __defaultSessionTrackingModes = Collections.unmodifiableSet(new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL)));
    public static final int __distantFuture = 628992000;
    private static final HttpSessionContext __nullSessionContext = new NullSessionContext();
    protected int _dftMaxIdleSecs = -1;
    protected SessionHandler _sessionHandler;
    protected boolean _httpOnly = false;
    protected SessionIdManager _sessionIdManager;
    protected boolean _secureCookies = false;
    protected Object _sessionAttributeListeners;
    protected Object _sessionListeners;
    protected ClassLoader _loader;
    protected ContextHandler.Context _context;
    protected String _sessionCookie = "JSESSIONID";
    protected String _sessionIdPathParameterName = "jsessionid";
    protected String _sessionIdPathParameterNamePrefix = ";" + this._sessionIdPathParameterName + "=";
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxCookieAge = -1;
    protected int _refreshCookieAge;
    protected boolean _nodeIdInSessionId;
    public Set<SessionTrackingMode> _sessionTrackingModes;
    private boolean _usingCookies;
    private boolean _usingURLs;
    protected final CounterStatistic _sessionsStats = new CounterStatistic();
    protected final SampleStatistic _sessionTimeStats = new SampleStatistic();
    private SessionCookieConfig _cookieConfig = new SessionCookieConfig(){

        public String getComment() {
            return null;
        }

        public String getDomain() {
            return AbstractSessionManager.this._sessionDomain;
        }

        public int getMaxAge() {
            return AbstractSessionManager.this._maxCookieAge;
        }

        public String getName() {
            return AbstractSessionManager.this._sessionCookie;
        }

        public String getPath() {
            return AbstractSessionManager.this._sessionPath;
        }

        public boolean isHttpOnly() {
            return AbstractSessionManager.this._httpOnly;
        }

        public boolean isSecure() {
            return AbstractSessionManager.this._secureCookies;
        }

        public void setComment(String comment) {
        }

        public void setDomain(String domain) {
            AbstractSessionManager.this._sessionDomain = domain;
        }

        public void setHttpOnly(boolean httpOnly) {
            AbstractSessionManager.this._httpOnly = httpOnly;
        }

        public void setMaxAge(int maxAge) {
            AbstractSessionManager.this._maxCookieAge = maxAge;
        }

        public void setName(String name) {
            AbstractSessionManager.this._sessionCookie = name;
        }

        public void setPath(String path) {
            AbstractSessionManager.this._sessionPath = path;
        }

        public void setSecure(boolean secure) {
            AbstractSessionManager.this._secureCookies = secure;
        }
    };

    public AbstractSessionManager() {
        this.setSessionTrackingModes(this.__defaultSessionTrackingModes);
    }

    @Override
    public HttpCookie access(HttpSession session, boolean secure) {
        long now = System.currentTimeMillis();
        Session s = ((SessionIf)session).getSession();
        s.access(now);
        if (this.isUsingCookies() && (s.isIdChanged() || this.getSessionCookieConfig().getMaxAge() > 0 && this.getRefreshCookieAge() > 0 && (now - s.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            HttpCookie cookie = this.getSessionCookie(session, this._context.getContextPath(), secure);
            s.cookieSet();
            s.setIdChanged(false);
            return cookie;
        }
        return null;
    }

    @Override
    public void addEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.add(this._sessionAttributeListeners, listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.add(this._sessionListeners, listener);
        }
    }

    @Override
    public void clearEventListeners() {
        this._sessionAttributeListeners = null;
        this._sessionListeners = null;
    }

    @Override
    public void complete(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        s.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws Exception {
        String str;
        String tmp;
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this._sessionIdManager == null) {
            Server server;
            Server server2 = server = this.getSessionHandler().getServer();
            synchronized (server2) {
                this._sessionIdManager = server.getSessionIdManager();
                if (this._sessionIdManager == null) {
                    this._sessionIdManager = new HashSessionIdManager();
                    server.setSessionIdManager(this._sessionIdManager);
                }
            }
        }
        if (!this._sessionIdManager.isStarted()) {
            this._sessionIdManager.start();
        }
        if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionCookie")) != null) {
            this._sessionCookie = tmp;
        }
        if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionIdPathParameterName")) != null) {
            this.setSessionIdPathParameterName(tmp);
        }
        if (this._maxCookieAge == -1 && this._context != null && (str = this._context.getInitParameter("org.eclipse.jetty.servlet.MaxAge")) != null) {
            this._maxCookieAge = Integer.parseInt(str.trim());
        }
        if (this._sessionDomain == null && this._context != null) {
            this._sessionDomain = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionDomain");
        }
        if (this._sessionPath == null && this._context != null) {
            this._sessionPath = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionPath");
        }
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.invalidateSessions();
        this._loader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpSession getHttpSession(String nodeId) {
        String cluster_id = this.getIdManager().getClusterId(nodeId);
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            Session session = this.getSession(cluster_id);
            if (session != null && !session.getNodeId().equals(nodeId)) {
                session.setIdChanged(true);
            }
            return session;
        }
    }

    @Override
    public SessionIdManager getIdManager() {
        return this._sessionIdManager;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @Deprecated
    public int getMaxSessions() {
        return this.getSessionsMax();
    }

    public int getSessionsMax() {
        return (int)this._sessionsStats.getMax();
    }

    public int getSessionsTotal() {
        return (int)this._sessionsStats.getTotal();
    }

    @Deprecated
    public SessionIdManager getMetaManager() {
        return this.getIdManager();
    }

    @Deprecated
    public int getMinSessions() {
        return 0;
    }

    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    @Override
    public HttpCookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            String id = this.getNodeId(session);
            HttpCookie cookie = new HttpCookie(this._sessionCookie, id, this._sessionDomain, contextPath == null || contextPath.length() == 0 ? "/" : contextPath, this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), requestIsSecure && this._cookieConfig.isSecure());
            return cookie;
        }
        return null;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public abstract Map getSessionMap();

    public int getSessions() {
        return (int)this._sessionsStats.getCurrent();
    }

    @Override
    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    @Override
    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    @Override
    public boolean isValid(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        return s.isValid();
    }

    @Override
    public String getClusterId(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        return s.getClusterId();
    }

    @Override
    public String getNodeId(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        return s.getNodeId();
    }

    @Override
    public HttpSession newHttpSession(HttpServletRequest request) {
        Session session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        this.addSession(session, true);
        return session;
    }

    @Override
    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.remove(this._sessionAttributeListeners, listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.remove(this._sessionListeners, listener);
        }
    }

    @Deprecated
    public void resetStats() {
        this.statsReset();
    }

    public void statsReset() {
        this._sessionsStats.reset(this.getSessions());
        this._sessionTimeStats.reset();
    }

    public void setHttpOnly(boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    @Override
    public void setIdManager(SessionIdManager metaManager) {
        this._sessionIdManager = metaManager;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
    }

    public void setRefreshCookieAge(int ageInSeconds) {
        this._refreshCookieAge = ageInSeconds;
    }

    @Override
    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    @Override
    public void setSessionIdPathParameterName(String param) {
        this._sessionIdPathParameterName = param == null || "none".equals(param) ? null : param;
        this._sessionIdPathParameterNamePrefix = param == null || "none".equals(param) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    protected abstract void addSession(Session var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(Session session, boolean created) {
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            this._sessionIdManager.addSession(session);
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this.addSession(session);
            }
        }
        if (created) {
            this._sessionsStats.increment();
            if (this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (int i = 0; i < LazyList.size(this._sessionListeners); ++i) {
                    ((HttpSessionListener)LazyList.get(this._sessionListeners, i)).sessionCreated(event);
                }
            }
        } else {
            session.didActivate();
        }
    }

    public abstract Session getSession(String var1);

    protected abstract void invalidateSessions();

    protected abstract Session newSession(HttpServletRequest var1);

    public boolean isNodeIdInSessionId() {
        return this._nodeIdInSessionId;
    }

    public void setNodeIdInSessionId(boolean nodeIdInSessionId) {
        this._nodeIdInSessionId = nodeIdInSessionId;
    }

    public void removeSession(HttpSession session, boolean invalidate) {
        Session s = ((SessionIf)session).getSession();
        this.removeSession(s, invalidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session session, boolean invalidate) {
        boolean removed = false;
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            if (this.getSession(session.getClusterId()) != null) {
                removed = true;
                this.removeSession(session.getClusterId());
            }
        }
        if (removed) {
            this._sessionsStats.decrement();
            this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - session.getCreationTime()) / 1000.0));
            this._sessionIdManager.removeSession(session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                int i = LazyList.size(this._sessionListeners);
                while (i-- > 0) {
                    ((HttpSessionListener)LazyList.get(this._sessionListeners, i)).sessionDestroyed(event);
                }
            }
            if (!invalidate) {
                session.willPassivate();
            }
        }
    }

    protected abstract void removeSession(String var1);

    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.__defaultSessionTrackingModes;
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return Collections.unmodifiableSet(this._sessionTrackingModes);
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this._sessionTrackingModes = new HashSet<SessionTrackingMode>(sessionTrackingModes);
        this._usingCookies = this._sessionTrackingModes.contains(SessionTrackingMode.COOKIE);
        this._usingURLs = this._sessionTrackingModes.contains(SessionTrackingMode.URL);
    }

    @Override
    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    @Override
    public boolean isUsingURLs() {
        return this._usingURLs;
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return this._cookieConfig;
    }

    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    public abstract class Session
    implements SessionIf,
    Serializable {
        protected final String _clusterId;
        protected final String _nodeId;
        protected boolean _idChanged;
        protected final long _created;
        protected long _cookieSet;
        protected long _accessed;
        protected long _lastAccessed;
        protected boolean _invalid;
        protected boolean _doInvalidate;
        protected long _maxIdleMs;
        protected boolean _newSession;
        protected Map _values;
        protected int _requests;

        protected Session(HttpServletRequest request) {
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            this._newSession = true;
            this._created = System.currentTimeMillis();
            this._clusterId = AbstractSessionManager.this._sessionIdManager.newSessionId(request, this._created);
            this._nodeId = AbstractSessionManager.this._sessionIdManager.getNodeId(this._clusterId, request);
            this._accessed = this._created;
            this._requests = 1;
        }

        protected Session(long created, String clusterId) {
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            this._created = created;
            this._clusterId = clusterId;
            this._nodeId = AbstractSessionManager.this._sessionIdManager.getNodeId(this._clusterId, null);
            this._accessed = this._created;
        }

        @Override
        public Session getSession() {
            return this;
        }

        protected void initValues() {
            this._values = this.newAttributeMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getAttribute(String name) {
            Session session = this;
            synchronized (session) {
                if (this._invalid) {
                    throw new IllegalStateException();
                }
                if (null == this._values) {
                    return null;
                }
                return this._values.get(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration getAttributeNames() {
            Session session = this;
            synchronized (session) {
                if (this._invalid) {
                    throw new IllegalStateException();
                }
                List<Object> names = this._values == null ? Collections.EMPTY_LIST : new ArrayList(this._values.keySet());
                return Collections.enumeration(names);
            }
        }

        public long getCookieSetTime() {
            return this._cookieSet;
        }

        public long getCreationTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._created;
        }

        public String getId() throws IllegalStateException {
            return AbstractSessionManager.this._nodeIdInSessionId ? this._nodeId : this._clusterId;
        }

        protected String getNodeId() {
            return this._nodeId;
        }

        protected String getClusterId() {
            return this._clusterId;
        }

        public long getLastAccessedTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._lastAccessed;
        }

        public int getMaxInactiveInterval() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return (int)(this._maxIdleMs / 1000L);
        }

        public ServletContext getServletContext() {
            return AbstractSessionManager.this._context;
        }

        @Deprecated
        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return __nullSessionContext;
        }

        @Deprecated
        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public String[] getValueNames() throws IllegalStateException {
            Session session = this;
            synchronized (session) {
                if (this._invalid) {
                    throw new IllegalStateException();
                }
                if (this._values == null) {
                    return new String[0];
                }
                String[] a = new String[this._values.size()];
                return this._values.keySet().toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void access(long time) {
            Session session = this;
            synchronized (session) {
                this._newSession = false;
                this._lastAccessed = this._accessed;
                this._accessed = time;
                ++this._requests;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete() {
            Session session = this;
            synchronized (session) {
                --this._requests;
                if (this._doInvalidate && this._requests <= 0) {
                    this.doInvalidate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void timeout() throws IllegalStateException {
            AbstractSessionManager.this.removeSession(this, true);
            Session session = this;
            synchronized (session) {
                if (this._requests <= 0) {
                    this.doInvalidate();
                } else {
                    this._doInvalidate = true;
                }
            }
        }

        public void invalidate() throws IllegalStateException {
            AbstractSessionManager.this.removeSession(this, true);
            this.doInvalidate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInvalidate() throws IllegalStateException {
            try {
                if (this._invalid) {
                    throw new IllegalStateException();
                }
                while (this._values != null && this._values.size() > 0) {
                    ArrayList keys;
                    Session session = this;
                    synchronized (session) {
                        keys = new ArrayList(this._values.keySet());
                    }
                    for (String key : keys) {
                        Object value;
                        Session session2 = this;
                        synchronized (session2) {
                            value = this._values.remove(key);
                        }
                        this.unbindValue(key, value);
                        if (AbstractSessionManager.this._sessionAttributeListeners == null) continue;
                        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                        for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                            ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i)).attributeRemoved(event);
                        }
                    }
                }
            }
            finally {
                this._invalid = true;
            }
        }

        public boolean isIdChanged() {
            return this._idChanged;
        }

        public boolean isNew() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._newSession;
        }

        @Deprecated
        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAttribute(String name) {
            Object old;
            Session session = this;
            synchronized (session) {
                if (this._invalid) {
                    throw new IllegalStateException();
                }
                if (this._values == null) {
                    return;
                }
                old = this._values.remove(name);
            }
            if (old != null) {
                this.unbindValue(name, old);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, old);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        ((HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i)).attributeRemoved(event);
                    }
                }
            }
        }

        @Deprecated
        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(String name, Object value) {
            Object old_value;
            if (value == null) {
                this.removeAttribute(name);
                return;
            }
            Session session = this;
            synchronized (session) {
                if (this._invalid) {
                    throw new IllegalStateException();
                }
                if (this._values == null) {
                    this._values = this.newAttributeMap();
                }
                old_value = this._values.put(name, value);
            }
            if (old_value == null || !value.equals(old_value)) {
                this.unbindValue(name, old_value);
                this.bindValue(name, value);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, old_value == null ? value : old_value);
                    for (int i = 0; i < LazyList.size(AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)LazyList.get(AbstractSessionManager.this._sessionAttributeListeners, i);
                        if (old_value == null) {
                            l.attributeAdded(event);
                            continue;
                        }
                        l.attributeReplaced(event);
                    }
                }
            }
        }

        public void setIdChanged(boolean changed) {
            this._idChanged = changed;
        }

        public void setMaxInactiveInterval(int secs) {
            this._maxIdleMs = (long)secs * 1000L;
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
        }

        protected void bindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        protected boolean isValid() {
            return !this._invalid;
        }

        protected abstract Map newAttributeMap();

        protected void cookieSet() {
            this._cookieSet = this._accessed;
        }

        protected void unbindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void willPassivate() {
            Session session = this;
            synchronized (session) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                for (Object value : this._values.values()) {
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    listener.sessionWillPassivate(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void didActivate() {
            Session session = this;
            synchronized (session) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                for (Object value : this._values.values()) {
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    listener.sessionDidActivate(event);
                }
            }
        }
    }

    public static interface SessionIf
    extends HttpSession {
        public Session getSession();
    }

    public static class NullSessionContext
    implements HttpSessionContext {
        private NullSessionContext() {
        }

        @Deprecated
        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        @Deprecated
        public HttpSession getSession(String id) {
            return null;
        }
    }
}

