/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.WebSocketFactory;

public abstract class WebSocketServlet
extends HttpServlet
implements WebSocketFactory.Acceptor {
    WebSocketFactory _webSocketFactory;

    public void init() throws ServletException {
        String bs = this.getInitParameter("bufferSize");
        this._webSocketFactory = new WebSocketFactory(this, bs == null ? 8192 : Integer.parseInt(bs));
        String max = this.getInitParameter("maxIdleTime");
        if (max != null) {
            this._webSocketFactory.setMaxIdleTime(Integer.parseInt(max));
        }
        if ((max = this.getInitParameter("maxTextMessageSize")) != null) {
            this._webSocketFactory.setMaxTextMessageSize(Integer.parseInt(max));
        }
        if ((max = this.getInitParameter("maxBinaryMessageSize")) != null) {
            this._webSocketFactory.setMaxBinaryMessageSize(Integer.parseInt(max));
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this._webSocketFactory.acceptWebSocket(request, response) || response.isCommitted()) {
            return;
        }
        super.service(request, response);
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        return true;
    }
}

