/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ThreadLocalBuffers;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public abstract class HttpBuffers
extends AbstractLifeCycle {
    private final ThreadLocalBuffers _requestBuffers = new ThreadLocalBuffers(){

        protected Buffer newBuffer(int size) {
            return HttpBuffers.this.newRequestBuffer(size);
        }

        protected Buffer newHeader(int size) {
            return HttpBuffers.this.newRequestHeader(size);
        }

        protected boolean isHeader(Buffer buffer) {
            return HttpBuffers.this.isRequestHeader(buffer);
        }
    };
    private final ThreadLocalBuffers _responseBuffers = new ThreadLocalBuffers(){

        protected Buffer newBuffer(int size) {
            return HttpBuffers.this.newResponseBuffer(size);
        }

        protected Buffer newHeader(int size) {
            return HttpBuffers.this.newResponseHeader(size);
        }

        protected boolean isHeader(Buffer buffer) {
            return HttpBuffers.this.isResponseHeader(buffer);
        }
    };

    public HttpBuffers() {
        this._requestBuffers.setBufferSize(8192);
        this._requestBuffers.setHeaderSize(6144);
        this._responseBuffers.setBufferSize(12288);
        this._responseBuffers.setHeaderSize(6144);
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    public int getHeaderBufferSize() {
        return this._requestBuffers.getHeaderSize();
    }

    public Buffers getRequestBuffers() {
        return this._requestBuffers;
    }

    public int getRequestBufferSize() {
        return this._requestBuffers.getBufferSize();
    }

    public int getRequestHeaderSize() {
        return this._requestBuffers.getHeaderSize();
    }

    public Buffers getResponseBuffers() {
        return this._requestBuffers;
    }

    public int getResponseBufferSize() {
        return this._responseBuffers.getBufferSize();
    }

    public int getResponseHeaderSize() {
        return this._responseBuffers.getHeaderSize();
    }

    protected abstract Buffer newRequestBuffer(int var1);

    protected abstract Buffer newRequestHeader(int var1);

    protected abstract Buffer newResponseBuffer(int var1);

    protected abstract Buffer newResponseHeader(int var1);

    protected abstract boolean isRequestHeader(Buffer var1);

    protected abstract boolean isResponseHeader(Buffer var1);

    public void setHeaderBufferSize(int headerBufferSize) {
        this.setRequestHeaderSize(headerBufferSize);
        this.setResponseHeaderSize(headerBufferSize);
    }

    public void setRequestBufferSize(int size) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._requestBuffers.setBufferSize(size);
    }

    public void setRequestHeaderSize(int size) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._requestBuffers.setHeaderSize(size);
    }

    public void setResponseBufferSize(int size) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._responseBuffers.setBufferSize(size);
    }

    public void setResponseHeaderSize(int size) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._responseBuffers.setHeaderSize(size);
    }
}

