/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.security.AccessControlException;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.log.Logger;

public class StdErrLog
implements Logger {
    private static DateCache _dateCache;
    private static final boolean __debug;
    private boolean _debug = __debug;
    private final String _name;
    private boolean _hideStacks = false;

    public StdErrLog() {
        this(null);
    }

    public StdErrLog(String name) {
        this._name = name == null ? "" : name;
        try {
            this._debug = Boolean.parseBoolean(System.getProperty(name + ".DEBUG", Boolean.toString(__debug)));
        }
        catch (AccessControlException ace) {
            this._debug = __debug;
        }
    }

    public String getName() {
        return this._name;
    }

    public boolean isDebugEnabled() {
        return this._debug;
    }

    public void setDebugEnabled(boolean enabled) {
        this._debug = enabled;
    }

    public boolean isHideStacks() {
        return this._hideStacks;
    }

    public void setHideStacks(boolean hideStacks) {
        this._hideStacks = hideStacks;
    }

    public void info(String msg) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        System.err.println(d + (ms > 99 ? "." : (ms > 0 ? ".0" : ".00")) + ms + ":INFO:" + this._name + ":" + msg);
    }

    public void info(String msg, Object arg0, Object arg1) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        System.err.println(d + (ms > 99 ? "." : (ms > 0 ? ".0" : ".00")) + ms + ":INFO:" + this._name + ":" + this.format(msg, arg0, arg1));
    }

    public void debug(String msg, Throwable th) {
        if (this._debug) {
            String d = _dateCache.now();
            int ms = _dateCache.lastMs();
            System.err.println(d + (ms > 99 ? "." : (ms > 0 ? ".0" : ".00")) + ms + ":DBUG:" + this._name + ":" + msg);
            if (th != null) {
                if (this._hideStacks) {
                    System.err.println(th);
                } else {
                    th.printStackTrace();
                }
            }
        }
    }

    public void debug(String msg) {
        if (this._debug) {
            String d = _dateCache.now();
            int ms = _dateCache.lastMs();
            System.err.println(d + (ms > 99 ? "." : (ms > 0 ? ".0" : ".00")) + ms + ":DBUG:" + this._name + ":" + msg);
        }
    }

    public void debug(String msg, Object arg0, Object arg1) {
        if (this._debug) {
            String d = _dateCache.now();
            int ms = _dateCache.lastMs();
            System.err.println(d + (ms > 99 ? "." : (ms > 0 ? ".0" : ".00")) + ms + ":DBUG:" + this._name + ":" + this.format(msg, arg0, arg1));
        }
    }

    public void warn(String msg) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        System.err.println(d + (ms > 99 ? "." : (ms > 0 ? ".0" : ".00")) + ms + ":WARN:" + this._name + ":" + msg);
    }

    public void warn(String msg, Object arg0, Object arg1) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        System.err.println(d + (ms > 99 ? "." : (ms > 0 ? ".0" : ".00")) + ms + ":WARN:" + this._name + ":" + this.format(msg, arg0, arg1));
    }

    public void warn(String msg, Throwable th) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        System.err.println(d + (ms > 99 ? "." : (ms > 0 ? ".0" : ".00")) + ms + ":WARN:" + this._name + ":" + msg);
        if (th != null) {
            if (this._hideStacks) {
                System.err.println(th);
            } else {
                th.printStackTrace();
            }
        }
    }

    private String format(String msg, Object arg0, Object arg1) {
        int i1;
        int i0 = msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (arg1 != null && i1 >= 0) {
            msg = msg.substring(0, i1) + arg1 + msg.substring(i1 + 2);
        }
        if (arg0 != null && i0 >= 0) {
            msg = msg.substring(0, i0) + arg0 + msg.substring(i0 + 2);
        }
        return msg;
    }

    public Logger getLogger(String name) {
        if (name == null && this._name == null || name != null && name.equals(this._name)) {
            return this;
        }
        return new StdErrLog(this._name == null || this._name.length() == 0 ? name : this._name + "." + name);
    }

    public String toString() {
        return "StdErrLog:" + this._name + ":DEBUG=" + this._debug;
    }

    static {
        __debug = Boolean.parseBoolean(System.getProperty("org.eclipse.jetty.util.log.DEBUG", System.getProperty("org.eclipse.jetty.util.log.stderr.DEBUG", "false")));
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

