/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class AsyncContinuation
implements AsyncContext,
Continuation {
    private static final Logger LOG = Log.getLogger(AsyncContinuation.class);
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static final ContinuationThrowable __exception = new ContinuationThrowable();
    private static final int __IDLE = 0;
    private static final int __DISPATCHED = 1;
    private static final int __ASYNCSTARTED = 2;
    private static final int __REDISPATCHING = 3;
    private static final int __ASYNCWAIT = 4;
    private static final int __REDISPATCH = 5;
    private static final int __REDISPATCHED = 6;
    private static final int __COMPLETING = 7;
    private static final int __UNCOMPLETED = 8;
    private static final int __COMPLETED = 9;
    protected AbstractHttpConnection _connection;
    private List<AsyncListener> _lastAsyncListeners;
    private List<AsyncListener> _asyncListeners;
    private List<ContinuationListener> _continuationListeners;
    private int _state = 0;
    private boolean _initial = true;
    private boolean _resumed;
    private boolean _expired;
    private volatile boolean _responseWrapped;
    private long _timeoutMs = 30000L;
    private AsyncEventState _event;
    private volatile long _expireAt;
    private volatile boolean _continuation;

    protected AsyncContinuation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnection(AbstractHttpConnection connection) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this._connection = connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContinuationListener(ContinuationListener listener) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            if (this._continuationListeners == null) {
                this._continuationListeners = new ArrayList<ContinuationListener>();
            }
            this._continuationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeout(long ms) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this._timeoutMs = ms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._timeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncEventState getAsyncEventState() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._event;
        }
    }

    @Override
    public boolean isResponseWrapped() {
        return this._responseWrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitial() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._initial;
        }
    }

    public boolean isContinuation() {
        return this._continuation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuspended() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspending() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 2: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDispatchable() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return super.toString() + "@" + this.getStatusString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusString() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return (this._state == 0 ? "IDLE" : (this._state == 1 ? "DISPATCHED" : (this._state == 2 ? "ASYNCSTARTED" : (this._state == 4 ? "ASYNCWAIT" : (this._state == 3 ? "REDISPATCHING" : (this._state == 5 ? "REDISPATCH" : (this._state == 6 ? "REDISPATCHED" : (this._state == 7 ? "COMPLETING" : (this._state == 8 ? "UNCOMPLETED" : (this._state == 9 ? "COMPLETE" : "UNKNOWN?" + this._state)))))))))) + (this._initial ? ",initial" : "") + (this._resumed ? ",resumed" : "") + (this._expired ? ",expired" : "");
        }
    }

    protected boolean handling() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this._continuation = false;
            this._responseWrapped = false;
            switch (this._state) {
                case 0: {
                    this._initial = true;
                    this._state = 1;
                    if (this._lastAsyncListeners != null) {
                        this._lastAsyncListeners.clear();
                    }
                    if (this._asyncListeners != null) {
                        this._asyncListeners.clear();
                    } else {
                        this._asyncListeners = this._lastAsyncListeners;
                        this._lastAsyncListeners = null;
                    }
                    return true;
                }
                case 7: {
                    this._state = 8;
                    return false;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this._state = 6;
                    return true;
                }
            }
            throw new IllegalStateException(this.getStatusString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSuspend(ServletContext context, ServletRequest request, ServletResponse response) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 1: 
                case 6: {
                    this._resumed = false;
                    this._expired = false;
                    if (this._event == null || request != this._event.getSuppliedRequest() || response != this._event.getSuppliedResponse() || context != this._event.getServletContext()) {
                        this._event = new AsyncEventState(context, request, response);
                    } else {
                        this._event._dispatchContext = null;
                        this._event._pathInContext = null;
                    }
                    this._state = 2;
                    List<AsyncListener> recycle = this._lastAsyncListeners;
                    this._lastAsyncListeners = this._asyncListeners;
                    this._asyncListeners = recycle;
                    if (this._asyncListeners == null) break;
                    this._asyncListeners.clear();
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (this._lastAsyncListeners != null) {
            for (AsyncListener listener : this._lastAsyncListeners) {
                try {
                    listener.onStartAsync((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
    }

    protected boolean unhandle() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 1: 
                case 6: {
                    this._state = 8;
                    return true;
                }
                case 0: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: {
                    this._initial = false;
                    this._state = 4;
                    this.scheduleTimeout();
                    if (this._state == 4) {
                        return true;
                    }
                    if (this._state == 7) {
                        this._state = 8;
                        return true;
                    }
                    this._initial = false;
                    this._state = 6;
                    return false;
                }
                case 3: {
                    this._initial = false;
                    this._state = 6;
                    return false;
                }
                case 7: {
                    this._initial = false;
                    this._state = 8;
                    return true;
                }
            }
            throw new IllegalStateException(this.getStatusString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        boolean dispatch = false;
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 2: {
                    this._state = 3;
                    this._resumed = true;
                    return;
                }
                case 4: {
                    dispatch = !this._expired;
                    this._state = 5;
                    this._resumed = true;
                    break;
                }
                case 5: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expired() {
        List<AsyncListener> aListeners22;
        List<ContinuationListener> cListeners22;
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 2: 
                case 4: {
                    cListeners22 = this._continuationListeners;
                    aListeners22 = this._asyncListeners;
                    break;
                }
                default: {
                    Object cListeners22 = null;
                    Object aListeners22 = null;
                    return;
                }
            }
            this._expired = true;
        }
        if (aListeners22 != null) {
            for (AsyncListener asyncListener : aListeners22) {
                try {
                    asyncListener.onTimeout((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
        if (cListeners22 != null) {
            for (ContinuationListener continuationListener : cListeners22) {
                try {
                    continuationListener.onTimeout(this);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
        asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 2: 
                case 4: {
                    this.dispatch();
                    break;
                }
                default: {
                    if (this._continuation) break;
                    this._expired = false;
                }
            }
        }
        this.scheduleDispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        boolean dispatch = false;
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 1: 
                case 6: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: {
                    this._state = 7;
                    return;
                }
                case 4: {
                    this._state = 7;
                    dispatch = !this._expired;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((AsyncListener)clazz.newInstance());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doComplete(Throwable ex) {
        List<AsyncListener> aListeners22;
        List<ContinuationListener> cListeners22;
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 8: {
                    this._state = 9;
                    cListeners22 = this._continuationListeners;
                    aListeners22 = this._asyncListeners;
                    break;
                }
                default: {
                    Object cListeners22 = null;
                    Object aListeners22 = null;
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (aListeners22 != null) {
            for (AsyncListener asyncListener : aListeners22) {
                try {
                    if (ex != null) {
                        this._event.getSuppliedRequest().setAttribute("javax.servlet.error.exception", (Object)ex);
                        this._event.getSuppliedRequest().setAttribute("javax.servlet.error.message", (Object)ex.getMessage());
                        asyncListener.onError((AsyncEvent)this._event);
                        continue;
                    }
                    asyncListener.onComplete((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
        if (cListeners22 != null) {
            for (ContinuationListener continuationListener : cListeners22) {
                try {
                    continuationListener.onComplete(this);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 1: 
                case 6: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._state = 0;
            this._initial = true;
            this._resumed = false;
            this._expired = false;
            this._responseWrapped = false;
            this.cancelTimeout();
            this._timeoutMs = 30000L;
            this._continuationListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this.cancelTimeout();
            this._continuationListeners = null;
        }
    }

    protected void scheduleDispatch() {
        EndPoint endp = this._connection.getEndPoint();
        if (!endp.isBlocking()) {
            ((AsyncEndPoint)endp).asyncDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTimeout() {
        EndPoint endp = this._connection.getEndPoint();
        if (this._timeoutMs > 0L) {
            if (endp.isBlocking()) {
                AsyncContinuation asyncContinuation = this;
                synchronized (asyncContinuation) {
                    this._expireAt = System.currentTimeMillis() + this._timeoutMs;
                    long wait = this._timeoutMs;
                    while (this._expireAt > 0L && wait > 0L && this._connection.getServer().isRunning()) {
                        try {
                            this.wait(wait);
                        }
                        catch (InterruptedException e) {
                            LOG.ignore(e);
                        }
                        wait = this._expireAt - System.currentTimeMillis();
                    }
                    if (this._expireAt > 0L && wait <= 0L && this._connection.getServer().isRunning()) {
                        this.expired();
                    }
                }
            }
            ((AsyncEndPoint)endp).scheduleTimeout(this._event._timeout, this._timeoutMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTimeout() {
        EndPoint endp = this._connection.getEndPoint();
        if (endp.isBlocking()) {
            AsyncContinuation asyncContinuation = this;
            synchronized (asyncContinuation) {
                this._expireAt = 0L;
                this.notifyAll();
            }
        } else {
            AsyncEventState event = this._event;
            if (event != null) {
                ((AsyncEndPoint)endp).cancelTimeout(event._timeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleting() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._state == 7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUncompleted() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._state == 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._state == 9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsyncStarted() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            switch (this._state) {
                case 0: 
                case 1: 
                case 8: 
                case 9: {
                    return false;
                }
            }
            return true;
        }
    }

    public void dispatch(ServletContext context, String path) {
        this._event._dispatchContext = context;
        this._event._pathInContext = path;
        this.dispatch();
    }

    public void dispatch(String path) {
        this._event._pathInContext = path;
        this.dispatch();
    }

    public Request getBaseRequest() {
        return this._connection.getRequest();
    }

    public ServletRequest getRequest() {
        if (this._event != null) {
            return this._event.getSuppliedRequest();
        }
        return this._connection.getRequest();
    }

    public ServletResponse getResponse() {
        if (this._responseWrapped && this._event != null && this._event.getSuppliedResponse() != null) {
            return this._event.getSuppliedResponse();
        }
        return this._connection.getResponse();
    }

    public void start(final Runnable run) {
        final AsyncEventState event = this._event;
        if (event != null) {
            this._connection.getServer().getThreadPool().dispatch(new Runnable(){

                @Override
                public void run() {
                    ((ContextHandler.Context)event.getServletContext()).getContextHandler().handle(run);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOriginalRequestAndResponse() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._event != null && this._event.getSuppliedRequest() == this._connection._request && this._event.getSuppliedResponse() == this._connection._response;
        }
    }

    public ContextHandler getContextHandler() {
        AsyncEventState event = this._event;
        if (event != null) {
            return ((ContextHandler.Context)event.getServletContext()).getContextHandler();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResumed() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._resumed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpired() {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            return this._expired;
        }
    }

    @Override
    public void resume() {
        this.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startAsync(ServletContext context, ServletRequest request, ServletResponse response) {
        AsyncContinuation asyncContinuation = this;
        synchronized (asyncContinuation) {
            this._responseWrapped = !(response instanceof Response);
            this.doSuspend(context, request, response);
            if (request instanceof HttpServletRequest) {
                this._event._pathInContext = URIUtil.addPaths(((HttpServletRequest)request).getServletPath(), ((HttpServletRequest)request).getPathInfo());
            }
        }
    }

    protected void startAsync() {
        this._responseWrapped = false;
        this._continuation = false;
        this.doSuspend(this._connection.getRequest().getServletContext(), (ServletRequest)this._connection.getRequest(), (ServletResponse)this._connection.getResponse());
    }

    @Override
    public void suspend(ServletResponse response) {
        this._continuation = true;
        this._responseWrapped = !(response instanceof Response);
        this.doSuspend(this._connection.getRequest().getServletContext(), (ServletRequest)this._connection.getRequest(), response);
    }

    @Override
    public void suspend() {
        this._responseWrapped = false;
        this._continuation = true;
        this.doSuspend(this._connection.getRequest().getServletContext(), (ServletRequest)this._connection.getRequest(), (ServletResponse)this._connection.getResponse());
    }

    @Override
    public ServletResponse getServletResponse() {
        if (this._responseWrapped && this._event != null && this._event.getSuppliedResponse() != null) {
            return this._event.getSuppliedResponse();
        }
        return this._connection.getResponse();
    }

    @Override
    public Object getAttribute(String name) {
        return this._connection.getRequest().getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this._connection.getRequest().removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object attribute) {
        this._connection.getRequest().setAttribute(name, attribute);
    }

    @Override
    public void undispatch() {
        if (this.isSuspended()) {
            if (LOG.isDebugEnabled()) {
                throw new ContinuationThrowable();
            }
            throw __exception;
        }
        throw new IllegalStateException("!suspended");
    }

    public class AsyncEventState
    extends AsyncEvent {
        private final ServletContext _suspendedContext;
        private ServletContext _dispatchContext;
        private String _pathInContext;
        private Timeout.Task _timeout;

        public AsyncEventState(ServletContext context, ServletRequest request, ServletResponse response) {
            super((AsyncContext)AsyncContinuation.this, request, response);
            this._timeout = new AsyncTimeout();
            this._suspendedContext = context;
            Request r = AsyncContinuation.this._connection.getRequest();
            if (r.getAttribute("javax.servlet.async.request_uri") == null) {
                String uri = (String)r.getAttribute("javax.servlet.forward.request_uri");
                if (uri != null) {
                    r.setAttribute("javax.servlet.async.request_uri", uri);
                    r.setAttribute("javax.servlet.async.context_path", r.getAttribute("javax.servlet.forward.context_path"));
                    r.setAttribute("javax.servlet.async.servlet_path", r.getAttribute("javax.servlet.forward.servlet_path"));
                    r.setAttribute("javax.servlet.async.path_info", r.getAttribute("javax.servlet.forward.path_info"));
                    r.setAttribute("javax.servlet.async.query_string", r.getAttribute("javax.servlet.forward.query_string"));
                } else {
                    r.setAttribute("javax.servlet.async.request_uri", r.getRequestURI());
                    r.setAttribute("javax.servlet.async.context_path", r.getContextPath());
                    r.setAttribute("javax.servlet.async.servlet_path", r.getServletPath());
                    r.setAttribute("javax.servlet.async.path_info", r.getPathInfo());
                    r.setAttribute("javax.servlet.async.query_string", r.getQueryString());
                }
            }
        }

        public ServletContext getSuspendedContext() {
            return this._suspendedContext;
        }

        public ServletContext getDispatchContext() {
            return this._dispatchContext;
        }

        public ServletContext getServletContext() {
            return this._dispatchContext == null ? this._suspendedContext : this._dispatchContext;
        }

        public String getPath() {
            return this._pathInContext;
        }
    }

    public class AsyncTimeout
    extends Timeout.Task
    implements Runnable {
        @Override
        public void expired() {
            AsyncContinuation.this.expired();
        }

        @Override
        public void run() {
            AsyncContinuation.this.expired();
        }
    }
}

