/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserDataConstraint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.StringMap;

public class ConstraintSecurityHandler
extends SecurityHandler
implements ConstraintAware {
    private ConstraintMapping[] _constraintMappings;
    private Set<String> _roles;
    private PathMap _constraintMap = new PathMap();
    private boolean _strict = true;

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    @Override
    public ConstraintMapping[] getConstraintMappings() {
        return this._constraintMappings;
    }

    @Override
    public Set<String> getRoles() {
        return this._roles;
    }

    public void setConstraintMappings(ConstraintMapping[] constraintMappings) {
        this.setConstraintMappings(constraintMappings, null);
    }

    @Override
    public void setConstraintMappings(ConstraintMapping[] constraintMappings, Set<String> roles) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._constraintMappings = constraintMappings;
        if (roles == null) {
            roles = new HashSet<String>();
            for (ConstraintMapping cm : constraintMappings) {
                String[] cmr = cm.getConstraint().getRoles();
                if (cmr == null) continue;
                for (String r : cmr) {
                    if ("*".equals(r)) continue;
                    roles.add(r);
                }
            }
        }
        this.setRoles(roles);
    }

    public void setRoles(Set<String> roles) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._roles = roles;
    }

    @Override
    protected void doStart() throws Exception {
        this._constraintMap.clear();
        if (this._constraintMappings != null) {
            for (ConstraintMapping mapping : this._constraintMappings) {
                RoleInfo allMethodsRoleInfo;
                Map mappings = (Map)this._constraintMap.get(mapping.getPathSpec());
                if (mappings == null) {
                    mappings = new StringMap();
                    this._constraintMap.put(mapping.getPathSpec(), mappings);
                }
                if ((allMethodsRoleInfo = (RoleInfo)mappings.get(null)) != null && allMethodsRoleInfo.isForbidden()) continue;
                String httpMethod = mapping.getMethod();
                RoleInfo roleInfo = (RoleInfo)mappings.get(httpMethod);
                if (roleInfo == null) {
                    roleInfo = new RoleInfo();
                    mappings.put(httpMethod, roleInfo);
                    if (allMethodsRoleInfo != null) {
                        roleInfo.combine(allMethodsRoleInfo);
                    }
                }
                if (roleInfo.isForbidden()) continue;
                Constraint constraint = mapping.getConstraint();
                boolean forbidden = constraint.isForbidden();
                roleInfo.setForbidden(forbidden);
                if (forbidden) {
                    if (httpMethod != null) continue;
                    mappings.clear();
                    mappings.put(null, roleInfo);
                    continue;
                }
                UserDataConstraint userDataConstraint = UserDataConstraint.get(constraint.getDataConstraint());
                roleInfo.setUserDataConstraint(userDataConstraint);
                boolean checked = constraint.getAuthenticate();
                roleInfo.setChecked(checked);
                if (roleInfo.isChecked()) {
                    if (constraint.isAnyRole()) {
                        if (this._strict) {
                            for (String string : this._roles) {
                                roleInfo.addRole(string);
                            }
                        } else {
                            roleInfo.setAnyRole(true);
                        }
                    } else {
                        String[] newRoles;
                        for (String role : newRoles = constraint.getRoles()) {
                            if (this._strict && !this._roles.contains(role)) {
                                throw new IllegalArgumentException("Attempt to use undeclared role: " + role + ", known roles: " + this._roles);
                            }
                            roleInfo.addRole(role);
                        }
                    }
                }
                if (httpMethod != null) continue;
                for (Map.Entry entry : mappings.entrySet()) {
                    if (entry.getKey() == null) continue;
                    RoleInfo specific = (RoleInfo)entry.getValue();
                    specific.combine(roleInfo);
                }
            }
        }
        super.doStart();
    }

    @Override
    protected Object prepareConstraintInfo(String pathInContext, Request request) {
        Map mappings = (Map)this._constraintMap.match(pathInContext);
        if (mappings != null) {
            String httpMethod = request.getMethod();
            RoleInfo roleInfo = (RoleInfo)mappings.get(httpMethod);
            if (roleInfo == null) {
                roleInfo = (RoleInfo)mappings.get(null);
            }
            return roleInfo;
        }
        return null;
    }

    @Override
    protected boolean checkUserDataPermissions(String pathInContext, Request request, Response response, Object constraintInfo) throws IOException {
        if (constraintInfo == null) {
            return true;
        }
        RoleInfo roleInfo = (RoleInfo)constraintInfo;
        if (roleInfo.isForbidden()) {
            return false;
        }
        UserDataConstraint dataConstraint = roleInfo.getUserDataConstraint();
        if (dataConstraint == null || dataConstraint == UserDataConstraint.None) {
            return true;
        }
        HttpConnection connection = HttpConnection.getCurrentConnection();
        Connector connector = connection.getConnector();
        if (dataConstraint == UserDataConstraint.Integral) {
            if (connector.isIntegral(request)) {
                return true;
            }
            if (connector.getConfidentialPort() > 0) {
                String url = connector.getIntegralScheme() + "://" + request.getServerName() + ":" + connector.getIntegralPort() + request.getRequestURI();
                if (request.getQueryString() != null) {
                    url = url + "?" + request.getQueryString();
                }
                response.setContentLength(0);
                response.sendRedirect(url);
            } else {
                response.sendError(403, "!Integral");
            }
            request.setHandled(true);
            return false;
        }
        if (dataConstraint == UserDataConstraint.Confidential) {
            if (connector.isConfidential(request)) {
                return true;
            }
            if (connector.getConfidentialPort() > 0) {
                String url = connector.getConfidentialScheme() + "://" + request.getServerName() + ":" + connector.getConfidentialPort() + request.getRequestURI();
                if (request.getQueryString() != null) {
                    url = url + "?" + request.getQueryString();
                }
                response.setContentLength(0);
                response.sendRedirect(url);
            } else {
                response.sendError(403, "!Confidential");
            }
            request.setHandled(true);
            return false;
        }
        throw new IllegalArgumentException("Invalid dataConstraint value: " + (Object)((Object)dataConstraint));
    }

    @Override
    protected boolean isAuthMandatory(Request baseRequest, Response base_response, Object constraintInfo) {
        if (constraintInfo == null) {
            return false;
        }
        return ((RoleInfo)constraintInfo).isChecked();
    }

    @Override
    protected boolean checkWebResourcePermissions(String pathInContext, Request request, Response response, Object constraintInfo, UserIdentity userIdentity) throws IOException {
        String[] roles;
        if (constraintInfo == null) {
            return true;
        }
        RoleInfo roleInfo = (RoleInfo)constraintInfo;
        if (!roleInfo.isChecked()) {
            return true;
        }
        if (roleInfo.isAnyRole() && request.getAuthType() != null) {
            return true;
        }
        for (String role : roles = roleInfo.getRoles()) {
            if (!userIdentity.isUserInRole(role, null)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void dump(StringBuilder b, String indent) {
        super.dump(b, indent);
        b.append(indent).append(" +=roles=").append(this._roles).append('\n');
        for (Object path : this._constraintMap.keySet()) {
            Object constraint = this._constraintMap.get(path);
            b.append(indent).append(" +=").append(path).append('=').append(constraint).append('\n');
        }
    }
}

