/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.RunAsToken;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.servlet.api.ServletRegistration;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletHolder
extends Holder<Servlet>
implements UserIdentity.Scope,
Comparable {
    private static final Logger LOG = Log.getLogger(ServletHolder.class);
    private int _initOrder;
    private boolean _initOnStartup = false;
    private Map<String, String> _roleMap;
    private String _forcedPath;
    private String _runAsRole;
    private RunAsToken _runAsToken;
    private IdentityService _identityService;
    private ServletRegistration.Dynamic _registration;
    private transient Servlet _servlet;
    private transient Config _config;
    private transient long _unavailable;
    private transient UnavailableException _unavailableEx;
    public static final Map<String, String> NO_MAPPED_ROLES = Collections.emptyMap();

    public ServletHolder() {
    }

    public ServletHolder(String name, Servlet servlet) {
        this.setName(name);
        this.setServlet(servlet);
    }

    public ServletHolder(Servlet servlet) {
        this.setServlet(servlet);
    }

    public ServletHolder(String name, Class<? extends Servlet> servlet) {
        this.setName(name);
        this.setHeldClass(servlet);
    }

    public ServletHolder(Class<? extends Servlet> servlet) {
        this.setHeldClass(servlet);
    }

    public UnavailableException getUnavailableException() {
        return this._unavailableEx;
    }

    public synchronized void setServlet(Servlet servlet) {
        if (servlet == null || servlet instanceof SingleThreadModel) {
            throw new IllegalArgumentException();
        }
        this._extInstance = true;
        this._servlet = servlet;
        this.setHeldClass(servlet.getClass());
        if (this.getName() == null) {
            this.setName(servlet.getClass().getName() + "-" + super.hashCode());
        }
    }

    public int getInitOrder() {
        return this._initOrder;
    }

    public void setInitOrder(int order) {
        this._initOnStartup = true;
        this._initOrder = order;
    }

    public boolean isSetInitOrder() {
        return this._initOnStartup;
    }

    public int compareTo(Object o) {
        if (o instanceof ServletHolder) {
            int c;
            ServletHolder sh = (ServletHolder)o;
            if (sh == this) {
                return 0;
            }
            if (sh._initOrder < this._initOrder) {
                return 1;
            }
            if (sh._initOrder > this._initOrder) {
                return -1;
            }
            int n = c = this._className != null && sh._className != null ? this._className.compareTo(sh._className) : 0;
            if (c == 0) {
                c = this._name.compareTo(sh._name);
            }
            if (c == 0) {
                c = this.hashCode() > o.hashCode() ? 1 : -1;
            }
            return c;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this._name == null ? System.identityHashCode(this) : this._name.hashCode();
    }

    public synchronized void setUserRoleLink(String name, String link) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap<String, String>();
        }
        this._roleMap.put(name, link);
    }

    public String getUserRoleLink(String name) {
        if (this._roleMap == null) {
            return name;
        }
        String link = this._roleMap.get(name);
        return link == null ? name : link;
    }

    public Map<String, String> getRoleMap() {
        return this._roleMap == null ? NO_MAPPED_ROLES : this._roleMap;
    }

    public String getForcedPath() {
        return this._forcedPath;
    }

    public void setForcedPath(String forcedPath) {
        this._forcedPath = forcedPath;
    }

    @Override
    public void doStart() throws Exception {
        this._unavailable = 0L;
        try {
            super.doStart();
            this.checkServletType();
        }
        catch (UnavailableException ue) {
            this.makeUnavailable(ue);
        }
        this._identityService = this._servletHandler.getIdentityService();
        if (this._identityService != null && this._runAsRole != null) {
            this._runAsToken = this._identityService.newRunAsToken(this._runAsRole);
        }
        this._config = new Config();
        if (this._class != null && SingleThreadModel.class.isAssignableFrom(this._class)) {
            this._servlet = new SingleThreadedWrapper();
        }
        if (this._extInstance || this._initOnStartup) {
            try {
                this.initServlet();
            }
            catch (Exception e) {
                if (this._servletHandler.isStartWithUnavailable()) {
                    LOG.ignore(e);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        Object old_run_as = null;
        if (this._servlet != null) {
            try {
                if (this._identityService != null) {
                    old_run_as = this._identityService.setRunAs(this._identityService.getSystemUserIdentity(), this._runAsToken);
                }
                this.destroyInstance(this._servlet);
                if (this._identityService != null) {
                    this._identityService.unsetRunAs(old_run_as);
                }
            }
            catch (Exception e) {
                try {
                    LOG.warn(e);
                    if (this._identityService != null) {
                        this._identityService.unsetRunAs(old_run_as);
                    }
                }
                catch (Throwable throwable) {
                    if (this._identityService != null) {
                        this._identityService.unsetRunAs(old_run_as);
                    }
                    throw throwable;
                }
            }
        }
        if (!this._extInstance) {
            this._servlet = null;
        }
        this._config = null;
    }

    @Override
    public void destroyInstance(Object o) throws Exception {
        if (o == null) {
            return;
        }
        Servlet servlet = (Servlet)o;
        servlet.destroy();
        this.getServletHandler().destroyServlet(servlet);
    }

    public synchronized Servlet getServlet() throws ServletException {
        if (this._unavailable != 0L) {
            if (this._unavailable < 0L || this._unavailable > 0L && System.currentTimeMillis() < this._unavailable) {
                throw this._unavailableEx;
            }
            this._unavailable = 0L;
            this._unavailableEx = null;
        }
        if (this._servlet == null) {
            this.initServlet();
        }
        return this._servlet;
    }

    public Servlet getServletInstance() {
        return this._servlet;
    }

    public void checkServletType() throws UnavailableException {
        if (this._class == null || !Servlet.class.isAssignableFrom(this._class)) {
            throw new UnavailableException("Servlet " + this._class + " is not a javax.servlet.Servlet");
        }
    }

    public boolean isAvailable() {
        if (this.isStarted() && this._unavailable == 0L) {
            return true;
        }
        try {
            this.getServlet();
        }
        catch (Exception e) {
            LOG.ignore(e);
        }
        return this.isStarted() && this._unavailable == 0L;
    }

    private void makeUnavailable(UnavailableException e) {
        if (this._unavailableEx == e && this._unavailable != 0L) {
            return;
        }
        this._servletHandler.getServletContext().log("unavailable", (Throwable)e);
        this._unavailableEx = e;
        this._unavailable = -1L;
        this._unavailable = e.isPermanent() ? -1L : (this._unavailableEx.getUnavailableSeconds() > 0 ? System.currentTimeMillis() + (long)(1000 * this._unavailableEx.getUnavailableSeconds()) : System.currentTimeMillis() + 5000L);
    }

    private void makeUnavailable(final Throwable e) {
        if (e instanceof UnavailableException) {
            this.makeUnavailable((UnavailableException)e);
        } else {
            ServletContext ctx = this._servletHandler.getServletContext();
            if (ctx == null) {
                LOG.info("unavailable", e);
            } else {
                ctx.log("unavailable", e);
            }
            this._unavailableEx = new UnavailableException(String.valueOf(e), -1){
                {
                    super(x0, x1);
                    this.initCause(e);
                }
            };
            this._unavailable = -1L;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initServlet() throws ServletException {
        Object old_run_as = null;
        try {
            if (this._servlet == null) {
                this._servlet = this.newInstance();
            }
            if (this._config == null) {
                this._config = new Config();
            }
            if (this._identityService != null) {
                old_run_as = this._identityService.setRunAs(this._identityService.getSystemUserIdentity(), this._runAsToken);
            }
            this._servlet.init((ServletConfig)this._config);
            if (this._identityService == null) return;
            this._identityService.unsetRunAs(old_run_as);
            return;
        }
        catch (UnavailableException e) {
            try {
                this.makeUnavailable(e);
                this._servlet = null;
                this._config = null;
                throw e;
                catch (ServletException e2) {
                    this.makeUnavailable(e2.getCause() == null ? e2 : e2.getCause());
                    this._servlet = null;
                    this._config = null;
                    throw e2;
                }
                catch (Exception e3) {
                    this.makeUnavailable(e3);
                    this._servlet = null;
                    this._config = null;
                    throw new ServletException(this.toString(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                if (this._identityService == null) throw throwable;
                this._identityService.unsetRunAs(old_run_as);
                throw throwable;
            }
        }
    }

    @Override
    public String getContextPath() {
        return this._config.getServletContext().getContextPath();
    }

    @Override
    public Map<String, String> getRoleRefMap() {
        return this._roleMap;
    }

    public String getRunAsRole() {
        return this._runAsRole;
    }

    public void setRunAsRole(String role) {
        this._runAsRole = role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(Request baseRequest, ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        if (this._class == null) {
            throw new UnavailableException("Servlet Not Initialized");
        }
        Servlet servlet = this._servlet;
        ServletHolder servletHolder = this;
        synchronized (servletHolder) {
            if (this._unavailable != 0L || !this._initOnStartup) {
                servlet = this.getServlet();
            }
            if (servlet == null) {
                throw new UnavailableException("Could not instantiate " + this._class);
            }
        }
        boolean servlet_error = true;
        Object old_run_as = null;
        boolean suspendable = baseRequest.isAsyncSupported();
        try {
            if (this._forcedPath != null) {
                request.setAttribute("org.apache.catalina.jsp_file", (Object)this._forcedPath);
            }
            if (this._identityService != null) {
                old_run_as = this._identityService.setRunAs(baseRequest.getResolvedUserIdentity(), this._runAsToken);
            }
            if (!this.isAsyncSupported()) {
                baseRequest.setAsyncSupported(false);
            }
            servlet.service(request, response);
            servlet_error = false;
            baseRequest.setAsyncSupported(suspendable);
            if (this._identityService != null) {
                this._identityService.unsetRunAs(old_run_as);
            }
            if (!servlet_error) return;
        }
        catch (UnavailableException e) {
            try {
                this.makeUnavailable(e);
                throw this._unavailableEx;
            }
            catch (Throwable throwable) {
                baseRequest.setAsyncSupported(suspendable);
                if (this._identityService != null) {
                    this._identityService.unsetRunAs(old_run_as);
                }
                if (!servlet_error) throw throwable;
                request.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
                throw throwable;
            }
        }
        request.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
        return;
    }

    public ServletRegistration.Dynamic getRegistration() {
        if (this._registration == null) {
            this._registration = new Registration();
        }
        return this._registration;
    }

    protected Servlet newInstance() throws ServletException, IllegalAccessException, InstantiationException {
        try {
            ServletContext ctx = this.getServletHandler().getServletContext();
            if (ctx == null) {
                return (Servlet)this.getHeldClass().newInstance();
            }
            return ((ServletContextHandler.Context)ctx).createServlet(this.getHeldClass());
        }
        catch (ServletException se) {
            Throwable cause = se.getRootCause();
            if (cause instanceof InstantiationException) {
                throw (InstantiationException)cause;
            }
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            throw se;
        }
    }

    private class SingleThreadedWrapper
    implements Servlet {
        Stack<Servlet> _stack = new Stack();

        private SingleThreadedWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                while (this._stack.size() > 0) {
                    try {
                        this._stack.pop().destroy();
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                    }
                }
            }
        }

        public ServletConfig getServletConfig() {
            return ServletHolder.this._config;
        }

        public String getServletInfo() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(ServletConfig config) throws ServletException {
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                if (this._stack.size() == 0) {
                    try {
                        Servlet s = ServletHolder.this.newInstance();
                        s.init(config);
                        this._stack.push(s);
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Servlet s;
            SingleThreadedWrapper singleThreadedWrapper = this;
            synchronized (singleThreadedWrapper) {
                if (this._stack.size() > 0) {
                    s = this._stack.pop();
                } else {
                    try {
                        s = ServletHolder.this.newInstance();
                        s.init((ServletConfig)ServletHolder.this._config);
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                }
            }
            try {
                s.service(req, res);
            }
            finally {
                singleThreadedWrapper = this;
                synchronized (singleThreadedWrapper) {
                    this._stack.push(s);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Registration
    extends Holder.HolderRegistration
    implements ServletRegistration.Dynamic {
        @Override
        public Set<String> addMapping(String ... urlPatterns) {
            ServletHolder.this.illegalStateIfContextStarted();
            HashSet<String> clash = null;
            for (String pattern : urlPatterns) {
                if (ServletHolder.this._servletHandler.getServletMapping(pattern) == null) continue;
                if (clash == null) {
                    clash = new HashSet<String>();
                }
                clash.add(pattern);
            }
            if (clash != null) {
                return clash;
            }
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(ServletHolder.this.getName());
            mapping.setPathSpecs(urlPatterns);
            ServletHolder.this._servletHandler.addServletMapping(mapping);
            return Collections.emptySet();
        }

        @Override
        public Collection<String> getMappings() {
            ServletMapping[] mappings = ServletHolder.this._servletHandler.getServletMappings();
            ArrayList<String> patterns = new ArrayList<String>();
            for (ServletMapping mapping : mappings) {
                String[] specs;
                if (!mapping.getServletName().equals(this.getName()) || (specs = mapping.getPathSpecs()) == null || specs.length <= 0) continue;
                patterns.addAll(Arrays.asList(specs));
            }
            return patterns;
        }

        @Override
        public String getRunAsRole() {
            return ServletHolder.this._runAsRole;
        }

        @Override
        public void setLoadOnStartup(int loadOnStartup) {
            ServletHolder.this.illegalStateIfContextStarted();
            ServletHolder.this.setInitOrder(loadOnStartup);
        }

        public int getInitOrder() {
            return ServletHolder.this.getInitOrder();
        }

        @Override
        public void setRunAsRole(String role) {
            ServletHolder.this._runAsRole = role;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Config
    extends Holder.HolderConfig
    implements ServletConfig {
        protected Config() {
        }

        public String getServletName() {
            return ServletHolder.this.getName();
        }
    }
}

