/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas.spi;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.plus.jaas.spi.AbstractDatabaseLoginModule;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCLoginModule
extends AbstractDatabaseLoginModule {
    private String dbDriver;
    private String dbUrl;
    private String dbUserName;
    private String dbPassword;

    @Override
    public Connection getConnection() throws Exception {
        if (this.dbDriver == null || this.dbUrl == null) {
            throw new IllegalStateException("Database connection information not configured");
        }
        if (Log.isDebugEnabled()) {
            Log.debug("Connecting using dbDriver=" + this.dbDriver + "+ dbUserName=" + this.dbUserName + ", dbPassword=" + this.dbUrl);
        }
        return DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        try {
            super.initialize(subject, callbackHandler, sharedState, options);
            this.dbDriver = (String)options.get("dbDriver");
            this.dbUrl = (String)options.get("dbUrl");
            this.dbUserName = (String)options.get("dbUserName");
            this.dbPassword = (String)options.get("dbPassword");
            if (this.dbUserName == null) {
                this.dbUserName = "";
            }
            if (this.dbPassword == null) {
                this.dbPassword = "";
            }
            if (this.dbDriver != null) {
                Loader.loadClass(this.getClass(), this.dbDriver).newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.toString());
        }
    }
}

