/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.PermissionCollection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppClassLoader;

public class WebAppContext
extends ServletContextHandler {
    public static final String TEMPDIR = "javax.servlet.context.tempdir";
    public static final String WEB_DEFAULTS_XML = "org/eclipse/jetty/webapp/webdefault.xml";
    public static final String ERROR_PAGE = "org.eclipse.jetty.server.error_page";
    public static final String SERVER_CONFIG = "org.eclipse.jetty.webapp.configuration";
    private static String[] __dftConfigurationClasses = new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration", "org.eclipse.jetty.webapp.TagLibConfiguration"};
    private String[] _configurationClasses = __dftConfigurationClasses;
    private Configuration[] _configurations;
    private String _defaultsDescriptor = "org/eclipse/jetty/webapp/webdefault.xml";
    private String _descriptor = null;
    private String _overrideDescriptor = null;
    private boolean _distributable = false;
    private boolean _extractWAR = true;
    private boolean _copyDir = false;
    private boolean _logUrlOnStart = false;
    private boolean _parentLoaderPriority = Boolean.getBoolean("org.eclipse.jetty.server.webapp.parentLoaderPriority");
    private PermissionCollection _permissions;
    private String[] _systemClasses = new String[]{"java.", "javax.", "org.xml.", "org.w3c.", "org.apache.commons.logging.", "org.eclipse.jetty.continuation.", "org.eclipse.jetty.jndi.", "org.eclipse.jetty.plus.jaas.", "org.eclipse.jetty.servlet.DefaultServlet", "org.eclipse.jetty.websocket."};
    private String[] _serverClasses = new String[]{"-org.eclipse.jetty.continuation.", "-org.eclipse.jetty.jndi.", "-org.eclipse.jetty.plus.jaas.", "-org.eclipse.jetty.servlet.DefaultServlet", "-org.eclipse.jetty.websocket.", "org.eclipse.jetty."};
    private File _tmpDir;
    private String _war;
    private String _extraClasspath;
    private Throwable _unavailableException;
    private Map _resourceAliases;
    private boolean _ownClassLoader = false;
    private boolean _configurationDiscovered = true;
    private boolean _configurationClassesSet = false;
    private boolean _configurationsSet = false;

    public static ContextHandler getCurrentWebAppContext() {
        ContextHandler handler;
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context != null && (handler = context.getContextHandler()) instanceof WebAppContext) {
            return handler;
        }
        return null;
    }

    public WebAppContext() {
        super(3);
        this.setErrorHandler(new ErrorPageErrorHandler());
    }

    public WebAppContext(String webApp, String contextPath) {
        super(null, contextPath, 3);
        this.setContextPath(contextPath);
        this.setWar(webApp);
        this.setErrorHandler(new ErrorPageErrorHandler());
    }

    public WebAppContext(HandlerContainer parent, String webApp, String contextPath) {
        super(parent, contextPath, 3);
        this.setWar(webApp);
        this.setErrorHandler(new ErrorPageErrorHandler());
    }

    public WebAppContext(SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        super(null, sessionHandler, securityHandler, servletHandler, errorHandler);
        this.setErrorHandler(errorHandler != null ? errorHandler : new ErrorPageErrorHandler());
    }

    public void setDisplayName(String servletContextName) {
        super.setDisplayName(servletContextName);
        ClassLoader cl = this.getClassLoader();
        if (cl != null && cl instanceof WebAppClassLoader) {
            ((WebAppClassLoader)cl).setName(servletContextName);
        }
    }

    public Throwable getUnavailableException() {
        return this._unavailableException;
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public Map getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases;
    }

    public void setResourceAliases(Map map) {
        this._resourceAliases = map;
    }

    public String getResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.get(alias);
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.remove(alias);
    }

    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        if (classLoader != null && classLoader instanceof WebAppClassLoader) {
            ((WebAppClassLoader)classLoader).setName(this.getDisplayName());
        }
    }

    public Resource getResource(String uriInContext) throws MalformedURLException {
        IOException ioe = null;
        Resource resource = null;
        int loop = 0;
        while (uriInContext != null && loop++ < 100) {
            try {
                resource = super.getResource(uriInContext);
                if (resource != null && resource.exists()) {
                    return resource;
                }
                uriInContext = this.getResourceAlias(uriInContext);
            }
            catch (IOException e) {
                Log.ignore(e);
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null && ioe instanceof MalformedURLException) {
            throw (MalformedURLException)ioe;
        }
        return resource;
    }

    public boolean isConfigurationDiscovered() {
        return this._configurationDiscovered;
    }

    public void setConfigurationDiscovered(boolean discovered) {
        this._configurationDiscovered = discovered;
    }

    protected void doStart() throws Exception {
        try {
            int i;
            this.loadConfigurations();
            this._ownClassLoader = false;
            if (this.getClassLoader() == null) {
                WebAppClassLoader classLoader = new WebAppClassLoader(this);
                this.setClassLoader(classLoader);
                this._ownClassLoader = true;
            }
            if (Log.isDebugEnabled()) {
                ClassLoader loader = this.getClassLoader();
                Log.debug("Thread Context class loader is: " + loader);
                for (loader = loader.getParent(); loader != null; loader = loader.getParent()) {
                    Log.debug("Parent class loader is: " + loader);
                }
            }
            for (i = 0; i < this._configurations.length; ++i) {
                this._configurations[i].preConfigure(this);
            }
            super.doStart();
            for (i = 0; i < this._configurations.length; ++i) {
                this._configurations[i].postConfigure(this);
            }
            if (this.isLogUrlOnStart()) {
                this.dumpUrl();
            }
        }
        catch (Exception e) {
            Log.warn("Failed startup of context " + this, e);
            this._unavailableException = e;
            this.setAvailable(false);
        }
    }

    public void dumpUrl() {
        Connector[] connectors = this.getServer().getConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            String connectorName = connectors[i].getName();
            String displayName = this.getDisplayName();
            if (displayName == null) {
                displayName = "WebApp@" + connectors.hashCode();
            }
            Log.info(displayName + " at http://" + connectorName + this.getContextPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        try {
            int i = this._configurations.length;
            while (i-- > 0) {
                this._configurations[i].deconfigure(this);
            }
            this._configurations = null;
        }
        finally {
            if (this._ownClassLoader) {
                this.setClassLoader(null);
            }
            this.setAvailable(true);
            this._unavailableException = null;
        }
    }

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public Configuration[] getConfigurations() {
        return this._configurations;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public String getOverrideDescriptor() {
        return this._overrideDescriptor;
    }

    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public String[] getServerClasses() {
        return this._serverClasses;
    }

    public void addServerClass(String classname) {
        int n = this._serverClasses.length;
        for (int i = 0; i < n; ++i) {
            if (!this._serverClasses[i].equals(classname)) continue;
            return;
        }
        int len = this._serverClasses.length + 1;
        String[] sysclass = new String[len];
        System.arraycopy(this._serverClasses, 0, sysclass, 0, len - 1);
        sysclass[len - 1] = classname;
        this._serverClasses = sysclass;
    }

    public String[] getSystemClasses() {
        return this._systemClasses;
    }

    public void addSystemClass(String classname) {
        int n = this._systemClasses.length;
        for (int i = 0; i < n; ++i) {
            if (!this._systemClasses[i].equals(classname)) continue;
            return;
        }
        int len = this._systemClasses.length + 1;
        String[] sysclass = new String[len];
        System.arraycopy(this._systemClasses, 0, sysclass, 0, len - 1);
        sysclass[len - 1] = classname;
        this._systemClasses = sysclass;
    }

    public boolean isServerClass(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] server_classes = this.getServerClasses();
        if (server_classes != null) {
            for (int i = 0; i < server_classes.length; ++i) {
                boolean result = true;
                String c = server_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (!(c.endsWith(".") ? name.startsWith(c) : name.equals(c))) continue;
                return result;
            }
        }
        return false;
    }

    public boolean isSystemClass(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] system_classes = this.getSystemClasses();
        if (system_classes != null) {
            for (int i = 0; i < system_classes.length; ++i) {
                boolean result = true;
                String c = system_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (!(c.endsWith(".") ? name.startsWith(c) : name.equals(c))) continue;
                return result;
            }
        }
        return false;
    }

    public String getWar() {
        if (this._war == null) {
            this._war = this.getResourceBase();
        }
        return this._war;
    }

    public Resource getWebInf() throws IOException {
        if (super.getBaseResource() == null) {
            return null;
        }
        Resource web_inf = super.getBaseResource().addPath("WEB-INF/");
        if (!web_inf.exists() || !web_inf.isDirectory()) {
            return null;
        }
        return web_inf;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public boolean isExtractWAR() {
        return this._extractWAR;
    }

    public boolean isCopyWebDir() {
        return this._copyDir;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public String[] getDefaultConfigurationClasses() {
        return __dftConfigurationClasses;
    }

    protected void loadConfigurations() throws Exception {
        if (this._configurations != null) {
            return;
        }
        if (!this._configurationClassesSet) {
            this._configurationClasses = __dftConfigurationClasses;
        }
        this._configurations = new Configuration[this._configurationClasses.length];
        for (int i = 0; i < this._configurationClasses.length; ++i) {
            this._configurations[i] = (Configuration)Loader.loadClass(this.getClass(), this._configurationClasses[i]).newInstance();
        }
    }

    protected boolean isProtectedTarget(String target) {
        while (target.startsWith("//")) {
            target = URIUtil.compactPath(target);
        }
        return StringUtil.startsWithIgnoreCase(target, "/web-inf") || StringUtil.startsWithIgnoreCase(target, "/meta-inf");
    }

    public String toString() {
        return super.toString() + (this._war == null ? "" : "," + this._war);
    }

    public void setConfigurationClasses(String[] configurations) {
        this._configurationClasses = configurations == null ? null : (String[])configurations.clone();
        this._configurationClassesSet = true;
    }

    public void setConfigurations(Configuration[] configurations) {
        this._configurations = configurations == null ? null : (Configuration[])configurations.clone();
        this._configurationsSet = true;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public void setOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptor = overrideDescriptor;
    }

    public String getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        if (this._sessionHandler != null) {
            this._sessionHandler.clearEventListeners();
        }
        super.setEventListeners(eventListeners);
        for (int i = 0; eventListeners != null && i < eventListeners.length; ++i) {
            EventListener listener = eventListeners[i];
            if (!(listener instanceof HttpSessionActivationListener) && !(listener instanceof HttpSessionAttributeListener) && !(listener instanceof HttpSessionBindingListener) && !(listener instanceof HttpSessionListener) || this._sessionHandler == null) continue;
            this._sessionHandler.addEventListener(listener);
        }
    }

    public void addEventListener(EventListener listener) {
        this.setEventListeners((EventListener[])LazyList.addToArray(this.getEventListeners(), listener, EventListener.class));
    }

    public void setExtractWAR(boolean extractWAR) {
        this._extractWAR = extractWAR;
    }

    public void setCopyWebDir(boolean copy) {
        this._copyDir = copy;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this._parentLoaderPriority = java2compliant;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public void setServerClasses(String[] serverClasses) {
        this._serverClasses = serverClasses == null ? null : (String[])serverClasses.clone();
    }

    public void setSystemClasses(String[] systemClasses) {
        this._systemClasses = systemClasses == null ? null : (String[])systemClasses.clone();
    }

    public void setTempDirectory(File dir) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (dir != null) {
            try {
                dir = new File(dir.getCanonicalPath());
            }
            catch (IOException e) {
                Log.warn("EXCEPTION ", e);
            }
        }
        if (dir != null && !dir.exists()) {
            dir.mkdir();
            dir.deleteOnExit();
        }
        if (!(dir == null || dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad temp directory: " + dir);
        }
        this._tmpDir = dir;
        this.setAttribute(TEMPDIR, this._tmpDir);
    }

    public File getTempDirectory() {
        return this._tmpDir;
    }

    public void setWar(String war) {
        this._war = war;
    }

    public String getExtraClasspath() {
        return this._extraClasspath;
    }

    public void setExtraClasspath(String extraClasspath) {
        this._extraClasspath = extraClasspath;
    }

    public boolean isLogUrlOnStart() {
        return this._logUrlOnStart;
    }

    public void setLogUrlOnStart(boolean logOnStart) {
        this._logUrlOnStart = logOnStart;
    }

    public void setServer(Server server) {
        String[] serverConfigs;
        super.setServer(server);
        if (!this._configurationsSet && !this._configurationClassesSet && server != null && (serverConfigs = (String[])server.getAttribute(SERVER_CONFIG)) != null) {
            this.setConfigurationClasses(serverConfigs);
        }
    }

    protected void startContext() throws Exception {
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configure(this);
        }
        super.startContext();
    }
}

