/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.net.URL;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class EnvConfiguration
implements Configuration {
    private URL jettyEnvXmlUrl;

    public void setJettyEnvXml(URL url) {
        this.jettyEnvXmlUrl = url;
    }

    public void preConfigure(WebAppContext context) throws Exception {
        this.createEnvContext(context);
    }

    public void configure(WebAppContext context) throws Exception {
        Resource jettyEnv;
        Resource web_inf;
        if (Log.isDebugEnabled()) {
            Log.debug("Created java:comp/env for webapp " + context.getContextPath());
        }
        if (this.jettyEnvXmlUrl == null && (web_inf = context.getWebInf()) != null && web_inf.isDirectory() && (jettyEnv = web_inf.addPath("jetty-env.xml")).exists()) {
            this.jettyEnvXmlUrl = jettyEnv.getURL();
        }
        if (this.jettyEnvXmlUrl != null) {
            XmlConfiguration configuration = new XmlConfiguration(this.jettyEnvXmlUrl);
            configuration.configure(context);
        }
        this.bindEnvEntries(context);
    }

    public void postConfigure(WebAppContext context) throws Exception {
    }

    public void deconfigure(WebAppContext context) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        try {
            InitialContext ic = new InitialContext();
            Context compCtx = (Context)ic.lookup("java:comp");
            compCtx.destroySubcontext("env");
        }
        catch (NameNotFoundException e) {
            Log.warn(e);
        }
        try {
            Context scopeContext = NamingEntryUtil.getContextForScope(context);
            scopeContext.destroySubcontext("__");
        }
        catch (NameNotFoundException e) {
            Log.ignore(e);
            Log.debug("No naming entries configured in environment for webapp " + context);
        }
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void bindEnvEntries(WebAppContext context) throws NamingException {
        Name namingEntryName;
        Log.debug("Binding env entries from the jvm scope");
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        HandlerWrapper scope = null;
        List list = NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class);
        for (EnvEntry ee : list) {
            ee.bindToENC(ee.getJndiName());
            namingEntryName = NamingEntryUtil.makeNamingEntryName(null, ee);
            NamingUtil.bind(envCtx, namingEntryName.toString(), ee);
        }
        Log.debug("Binding env entries from the server scope");
        scope = context.getServer();
        list = NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class);
        for (EnvEntry ee : list) {
            ee.bindToENC(ee.getJndiName());
            namingEntryName = NamingEntryUtil.makeNamingEntryName(null, ee);
            NamingUtil.bind(envCtx, namingEntryName.toString(), ee);
        }
        Log.debug("Binding env entries from the context scope");
        scope = context;
        list = NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class);
        for (EnvEntry ee : list) {
            ee.bindToENC(ee.getJndiName());
            namingEntryName = NamingEntryUtil.makeNamingEntryName(null, ee);
            NamingUtil.bind(envCtx, namingEntryName.toString(), ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEnvContext(WebAppContext wac) throws NamingException {
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.createSubcontext("env");
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }
}

