/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SslSelectChannelEndPoint
extends SelectChannelEndPoint {
    static Logger __log = Log.getLogger("org.eclipse.jetty.http.ssl");
    private static final ByteBuffer[] __NO_BUFFERS = new ByteBuffer[0];
    private final Buffers _buffers;
    private final SSLEngine _engine;
    private final SSLSession _session;
    private final ByteBuffer _inBuffer;
    private final NIOBuffer _inNIOBuffer;
    private final ByteBuffer _outBuffer;
    private final NIOBuffer _outNIOBuffer;
    private final NIOBuffer[] _reuseBuffer = new NIOBuffer[2];
    private final ByteBuffer[] _gather = new ByteBuffer[2];
    private boolean _closing = false;
    private SSLEngineResult _result;
    private boolean _handshook = false;
    private boolean _allowRenegotiate = false;
    private final boolean _debug = __log.isDebugEnabled();

    public SslSelectChannelEndPoint(Buffers buffers, SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, SSLEngine engine) throws IOException {
        super(channel, selectSet, key);
        this._buffers = buffers;
        this._engine = engine;
        this._session = engine.getSession();
        this._outNIOBuffer = (NIOBuffer)this._buffers.getBuffer(this._session.getPacketBufferSize());
        this._outBuffer = this._outNIOBuffer.getByteBuffer();
        this._inNIOBuffer = (NIOBuffer)this._buffers.getBuffer(this._session.getPacketBufferSize());
        this._inBuffer = this._inNIOBuffer.getByteBuffer();
        if (this._debug) {
            __log.debug(this._session + " channel=" + channel);
        }
    }

    public boolean isAllowRenegotiate() {
        return this._allowRenegotiate;
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._allowRenegotiate = allowRenegotiate;
    }

    public void dump() {
        Log.info("" + this._result);
    }

    protected void idleExpired() {
        try {
            this.getSelectManager().dispatch(new Runnable(){

                public void run() {
                    SslSelectChannelEndPoint.this.doIdleExpired();
                }
            });
        }
        catch (Exception e) {
            Log.ignore(e);
        }
    }

    protected void doIdleExpired() {
        super.idleExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        this._closing = true;
        try {
            try {
                if (this.isBufferingOutput()) {
                    this.flush();
                    while (this.isOpen() && this.isBufferingOutput()) {
                        Thread.sleep(100L);
                        this.flush();
                    }
                }
                this._engine.closeOutbound();
                block18: while (!(!this.isOpen() || this._engine.isInboundDone() && this._engine.isOutboundDone())) {
                    if (this.isBufferingOutput()) {
                        this.flush();
                        while (this.isOpen() && this.isBufferingOutput()) {
                            Thread.sleep(100L);
                            this.flush();
                        }
                    }
                    if (this._debug) {
                        __log.debug(this._session + " closing " + (Object)((Object)this._engine.getHandshakeStatus()));
                    }
                    switch (this._engine.getHandshakeStatus()) {
                        case FINISHED: 
                        case NOT_HANDSHAKING: {
                            this._handshook = true;
                            break block18;
                        }
                        case NEED_UNWRAP: {
                            Object var4_8;
                            Buffer buffer = this._buffers.getBuffer(this._engine.getSession().getApplicationBufferSize());
                            try {
                                try {
                                    ByteBuffer bbuffer = ((NIOBuffer)buffer).getByteBuffer();
                                    if (!this.unwrap(bbuffer) && this._engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                                        var4_8 = null;
                                        this._buffers.returnBuffer(buffer);
                                        break block18;
                                    }
                                    var4_8 = null;
                                    this._buffers.returnBuffer(buffer);
                                }
                                catch (SSLException e) {
                                    Log.ignore(e);
                                    var4_8 = null;
                                    this._buffers.returnBuffer(buffer);
                                }
                                break;
                            }
                            catch (Throwable throwable) {
                                var4_8 = null;
                                this._buffers.returnBuffer(buffer);
                                throw throwable;
                            }
                        }
                        case NEED_TASK: {
                            Runnable task;
                            while ((task = this._engine.getDelegatedTask()) != null) {
                                task.run();
                            }
                            break;
                        }
                        case NEED_WRAP: {
                            Object var6_9;
                            try {
                                this._outNIOBuffer.compact();
                                int put = this._outNIOBuffer.putIndex();
                                this._outBuffer.position(put);
                                this._result = null;
                                this._result = this._engine.wrap(__NO_BUFFERS, this._outBuffer);
                                if (this._debug) {
                                    __log.debug(this._session + " close wrap " + this._result);
                                }
                                this._outNIOBuffer.setPutIndex(put + this._result.bytesProduced());
                                var6_9 = null;
                                this._outBuffer.position(0);
                                break;
                            }
                            catch (Throwable throwable) {
                                var6_9 = null;
                                this._outBuffer.position(0);
                                throw throwable;
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                Log.ignore(e);
                Object var8_13 = null;
                super.close();
                if (this._inNIOBuffer != null) {
                    this._buffers.returnBuffer(this._inNIOBuffer);
                }
                if (this._outNIOBuffer != null) {
                    this._buffers.returnBuffer(this._outNIOBuffer);
                }
                if (this._reuseBuffer[0] != null) {
                    this._buffers.returnBuffer(this._reuseBuffer[0]);
                }
                if (this._reuseBuffer[1] == null) return;
                this._buffers.returnBuffer(this._reuseBuffer[1]);
                return;
            }
            catch (InterruptedException e) {
                Log.ignore(e);
                Object var8_14 = null;
                super.close();
                if (this._inNIOBuffer != null) {
                    this._buffers.returnBuffer(this._inNIOBuffer);
                }
                if (this._outNIOBuffer != null) {
                    this._buffers.returnBuffer(this._outNIOBuffer);
                }
                if (this._reuseBuffer[0] != null) {
                    this._buffers.returnBuffer(this._reuseBuffer[0]);
                }
                if (this._reuseBuffer[1] == null) return;
                this._buffers.returnBuffer(this._reuseBuffer[1]);
                return;
            }
            Object var8_12 = null;
            super.close();
            if (this._inNIOBuffer != null) {
                this._buffers.returnBuffer(this._inNIOBuffer);
            }
            if (this._outNIOBuffer != null) {
                this._buffers.returnBuffer(this._outNIOBuffer);
            }
            if (this._reuseBuffer[0] != null) {
                this._buffers.returnBuffer(this._reuseBuffer[0]);
            }
            if (this._reuseBuffer[1] == null) return;
            this._buffers.returnBuffer(this._reuseBuffer[1]);
            return;
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            super.close();
            if (this._inNIOBuffer != null) {
                this._buffers.returnBuffer(this._inNIOBuffer);
            }
            if (this._outNIOBuffer != null) {
                this._buffers.returnBuffer(this._outNIOBuffer);
            }
            if (this._reuseBuffer[0] != null) {
                this._buffers.returnBuffer(this._reuseBuffer[0]);
            }
            if (this._reuseBuffer[1] == null) throw throwable;
            this._buffers.returnBuffer(this._reuseBuffer[1]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int fill(Buffer buffer) throws IOException {
        ByteBuffer bbuf = this.extractInputBuffer(buffer);
        int size = buffer.length();
        SSLEngineResult.HandshakeStatus initialStatus = this._engine.getHandshakeStatus();
        ByteBuffer byteBuffer = bbuf;
        synchronized (byteBuffer) {
            block27: {
                this.unwrap(bbuf);
                int wraps = 0;
                block21: while (true) {
                    if (this.isBufferingOutput()) {
                        this.flush();
                        if (this.isBufferingOutput()) break;
                    }
                    switch (this._engine.getHandshakeStatus()) {
                        case FINISHED: 
                        case NOT_HANDSHAKING: {
                            if (!this._closing) break block21;
                            int n = -1;
                            Object var13_12 = null;
                            buffer.setPutIndex(bbuf.position());
                            bbuf.position(0);
                            return n;
                        }
                        case NEED_UNWRAP: {
                            this.checkRenegotiate();
                            if (this.unwrap(bbuf) || this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                            break block21;
                        }
                        case NEED_TASK: {
                            Runnable task;
                            while ((task = this._engine.getDelegatedTask()) != null) {
                                task.run();
                            }
                            if (initialStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || wraps != 0) break;
                            if (this._debug) {
                                __log.warn(this._session + " JETTY-567");
                            }
                            int n = -1;
                            Object var13_13 = null;
                            buffer.setPutIndex(bbuf.position());
                            bbuf.position(0);
                            return n;
                        }
                        case NEED_WRAP: {
                            this.checkRenegotiate();
                            ++wraps;
                            ByteBuffer byteBuffer2 = this._outBuffer;
                            synchronized (byteBuffer2) {
                                Object var10_11;
                                try {
                                    this._outNIOBuffer.compact();
                                    int put = this._outNIOBuffer.putIndex();
                                    this._outBuffer.position();
                                    this._result = null;
                                    this._result = this._engine.wrap(__NO_BUFFERS, this._outBuffer);
                                    if (this._debug) {
                                        __log.debug(this._session + " fill wrap " + this._result);
                                    }
                                    switch (this._result.getStatus()) {
                                        case BUFFER_OVERFLOW: 
                                        case BUFFER_UNDERFLOW: {
                                            Log.warn("wrap {}", this._result);
                                        }
                                        case CLOSED: {
                                            this._closing = true;
                                            break;
                                        }
                                    }
                                    this._outNIOBuffer.setPutIndex(put + this._result.bytesProduced());
                                    var10_11 = null;
                                    this._outBuffer.position(0);
                                }
                                catch (Throwable throwable) {
                                    var10_11 = null;
                                    this._outBuffer.position(0);
                                    throw throwable;
                                }
                            }
                            this.flush();
                        }
                    }
                }
                try {
                    Object var13_14 = null;
                    buffer.setPutIndex(bbuf.position());
                    bbuf.position(0);
                    break block27;
                    catch (SSLException e) {
                        Log.warn(e.toString());
                        Log.debug(e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    buffer.setPutIndex(bbuf.position());
                    bbuf.position(0);
                    throw throwable;
                }
            }
            int filled = buffer.length() - size;
            if (filled > 0) {
                this._handshook = true;
            }
            return filled;
        }
    }

    public int flush(Buffer buffer) throws IOException {
        return this.flush(buffer, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int consumed = 0;
        int available = header.length();
        if (buffer != null) {
            available += buffer.length();
        }
        boolean tries = false;
        while (true) {
            if (this._outNIOBuffer.length() > 0) {
                this.flush();
                if (this.isBufferingOutput()) {
                    return consumed;
                }
            }
            switch (2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[this._engine.getHandshakeStatus().ordinal()]) {
                case 1: 
                case 2: {
                    if (this._closing || available == 0) {
                        if (consumed != 0) return consumed;
                        return -1;
                    }
                    int c = header != null && header.length() > 0 ? (buffer != null && buffer.length() > 0 ? this.wrap(header, buffer) : this.wrap(header)) : this.wrap(buffer);
                    if (c > 0) {
                        this._handshook = true;
                        consumed += c;
                        available -= c;
                        break;
                    }
                    if (c >= 0) break;
                    if (consumed != 0) return consumed;
                    return -1;
                }
                case 3: {
                    Object var11_12;
                    this.checkRenegotiate();
                    Buffer buf = this._buffers.getBuffer(this._engine.getSession().getApplicationBufferSize());
                    try {
                        ByteBuffer bbuf = ((NIOBuffer)buf).getByteBuffer();
                        if (!this.unwrap(bbuf) && this._engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            var11_12 = null;
                            this._buffers.returnBuffer(buf);
                            return consumed;
                        }
                        var11_12 = null;
                        this._buffers.returnBuffer(buf);
                        break;
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        this._buffers.returnBuffer(buf);
                        throw throwable;
                    }
                }
                case 4: {
                    Runnable task;
                    while ((task = this._engine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    break;
                }
                case 5: {
                    this.checkRenegotiate();
                    ByteBuffer byteBuffer = this._outBuffer;
                    synchronized (byteBuffer) {
                        Object var13_13;
                        try {
                            this._outNIOBuffer.compact();
                            int put = this._outNIOBuffer.putIndex();
                            this._outBuffer.position();
                            this._result = null;
                            this._result = this._engine.wrap(__NO_BUFFERS, this._outBuffer);
                            if (this._debug) {
                                __log.debug(this._session + " flush wrap " + this._result);
                            }
                            switch (this._result.getStatus()) {
                                case BUFFER_OVERFLOW: 
                                case BUFFER_UNDERFLOW: {
                                    Log.warn("unwrap {}", this._result);
                                }
                                case CLOSED: {
                                    this._closing = true;
                                    break;
                                }
                            }
                            this._outNIOBuffer.setPutIndex(put + this._result.bytesProduced());
                            var13_13 = null;
                            this._outBuffer.position(0);
                        }
                        catch (Throwable throwable) {
                            var13_13 = null;
                            this._outBuffer.position(0);
                            throw throwable;
                        }
                    }
                }
                this.flush();
                if (!this.isBufferingOutput()) break;
                return consumed;
            }
        }
    }

    public void flush() throws IOException {
        int len = this._outNIOBuffer.length();
        if (this.isBufferingOutput()) {
            int flushed = super.flush(this._outNIOBuffer);
            if (this._debug) {
                __log.debug(this._session + " Flushed " + flushed + "/" + len);
            }
            if (this.isBufferingOutput()) {
                Thread.yield();
                flushed = super.flush(this._outNIOBuffer);
                if (this._debug) {
                    __log.debug(this._session + " flushed " + flushed + "/" + len);
                }
            }
        }
    }

    private void checkRenegotiate() throws IOException {
        if (this._handshook && !this._allowRenegotiate && this._channel != null && this._channel.isOpen()) {
            Log.warn("SSL renegotiate denied: " + this._channel);
            this.close();
        }
    }

    private ByteBuffer extractInputBuffer(Buffer buffer) {
        assert (buffer instanceof NIOBuffer);
        NIOBuffer nbuf = (NIOBuffer)buffer;
        ByteBuffer bbuf = nbuf.getByteBuffer();
        bbuf.position(buffer.putIndex());
        return bbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unwrap(ByteBuffer buffer) throws IOException {
        if (this._inNIOBuffer.hasContent()) {
            this._inNIOBuffer.compact();
        } else {
            this._inNIOBuffer.clear();
        }
        int total_filled = 0;
        while (this._inNIOBuffer.space() > 0 && super.isOpen()) {
            try {
                int filled = super.fill(this._inNIOBuffer);
                if (this._debug) {
                    __log.debug(this._session + " unwrap filled " + filled);
                }
                if (filled <= 0) break;
                total_filled += filled;
            }
            catch (IOException e) {
                if (this._inNIOBuffer.length() != 0) break;
                this._outNIOBuffer.clear();
                throw e;
            }
        }
        if (total_filled == 0 && this._inNIOBuffer.length() == 0) {
            if (!this.isOpen()) {
                this._outNIOBuffer.clear();
                throw new EofException();
            }
            return false;
        }
        try {
            this._inBuffer.position(this._inNIOBuffer.getIndex());
            this._inBuffer.limit(this._inNIOBuffer.putIndex());
            this._result = null;
            this._result = this._engine.unwrap(this._inBuffer, buffer);
            if (this._debug) {
                __log.debug(this._session + " unwrap unwrap " + this._result);
            }
            this._inNIOBuffer.skip(this._result.bytesConsumed());
            Object var5_5 = null;
            this._inBuffer.position(0);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._inBuffer.position(0);
            this._inBuffer.limit(this._inBuffer.capacity());
            throw throwable;
        }
        this._inBuffer.limit(this._inBuffer.capacity());
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: {
                throw new IllegalStateException(this._result.toString());
            }
            case BUFFER_UNDERFLOW: {
                if (Log.isDebugEnabled()) {
                    Log.debug("unwrap {}", this._result);
                }
                if (!this.isOpen()) {
                    this._inNIOBuffer.clear();
                    this._outNIOBuffer.clear();
                    throw new EofException();
                }
                return total_filled > 0;
            }
            case CLOSED: {
                this._closing = true;
            }
            case OK: {
                return total_filled > 0 || this._result.bytesConsumed() > 0 || this._result.bytesProduced() > 0;
            }
        }
        Log.warn("unwrap " + this._result);
        throw new IOException(this._result.toString());
    }

    private ByteBuffer extractOutputBuffer(Buffer buffer, int n) {
        if (buffer.buffer() instanceof NIOBuffer) {
            NIOBuffer nBuf = (NIOBuffer)buffer.buffer();
            return nBuf.getByteBuffer();
        }
        if (this._reuseBuffer[n] == null) {
            this._reuseBuffer[n] = (NIOBuffer)this._buffers.getBuffer(this._session.getApplicationBufferSize());
        }
        NIOBuffer buf = this._reuseBuffer[n];
        buf.clear();
        buf.put(buffer);
        return buf.getByteBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrap(Buffer header, Buffer buffer) throws IOException {
        this._gather[0] = this.extractOutputBuffer(header, 0);
        ByteBuffer byteBuffer = this._gather[0];
        synchronized (byteBuffer) {
            this._gather[0].position(header.getIndex());
            this._gather[0].limit(header.putIndex());
            this._gather[1] = this.extractOutputBuffer(buffer, 1);
            ByteBuffer byteBuffer2 = this._gather[1];
            synchronized (byteBuffer2) {
                this._gather[1].position(buffer.getIndex());
                this._gather[1].limit(buffer.putIndex());
                ByteBuffer byteBuffer3 = this._outBuffer;
                synchronized (byteBuffer3) {
                    int len2;
                    int consumed = 0;
                    try {
                        this._outNIOBuffer.clear();
                        this._outBuffer.position(0);
                        this._outBuffer.limit(this._outBuffer.capacity());
                        this._result = null;
                        this._result = this._engine.wrap(this._gather, this._outBuffer);
                        if (this._debug) {
                            __log.debug(this._session + " wrap wrap " + this._result);
                        }
                        this._outNIOBuffer.setGetIndex(0);
                        this._outNIOBuffer.setPutIndex(this._result.bytesProduced());
                        consumed = this._result.bytesConsumed();
                        Object var8_7 = null;
                        this._outBuffer.position(0);
                    }
                    catch (Throwable throwable) {
                        int len2;
                        Object var8_8 = null;
                        this._outBuffer.position(0);
                        if (consumed > 0) {
                            len2 = consumed < header.length() ? consumed : header.length();
                            header.skip(len2);
                            consumed -= len2;
                            this._gather[0].position(0);
                            this._gather[0].limit(this._gather[0].capacity());
                        }
                        if (consumed > 0) {
                            len2 = consumed < buffer.length() ? consumed : buffer.length();
                            buffer.skip(len2);
                            consumed -= len2;
                            this._gather[1].position(0);
                            this._gather[1].limit(this._gather[1].capacity());
                        }
                        assert (consumed == 0);
                        throw throwable;
                    }
                    if (consumed > 0) {
                        len2 = consumed < header.length() ? consumed : header.length();
                        header.skip(len2);
                        consumed -= len2;
                        this._gather[0].position(0);
                        this._gather[0].limit(this._gather[0].capacity());
                    }
                    if (consumed > 0) {
                        len2 = consumed < buffer.length() ? consumed : buffer.length();
                        buffer.skip(len2);
                        consumed -= len2;
                        this._gather[1].position(0);
                        this._gather[1].limit(this._gather[1].capacity());
                    }
                    assert (consumed == 0);
                }
            }
        }
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: 
            case BUFFER_UNDERFLOW: {
                Log.warn("unwrap {}", this._result);
            }
            case OK: {
                return this._result.bytesConsumed();
            }
            case CLOSED: {
                this._closing = true;
                return this._result.bytesConsumed() > 0 ? this._result.bytesConsumed() : -1;
            }
        }
        Log.warn("wrap " + this._result);
        throw new IOException(this._result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrap(Buffer buffer) throws IOException {
        this._gather[0] = this.extractOutputBuffer(buffer, 0);
        ByteBuffer byteBuffer = this._gather[0];
        synchronized (byteBuffer) {
            this._gather[0].position(buffer.getIndex());
            this._gather[0].limit(buffer.putIndex());
            int consumed = 0;
            ByteBuffer byteBuffer2 = this._outBuffer;
            synchronized (byteBuffer2) {
                try {
                    this._outNIOBuffer.clear();
                    this._outBuffer.position(0);
                    this._outBuffer.limit(this._outBuffer.capacity());
                    this._result = null;
                    this._result = this._engine.wrap(this._gather[0], this._outBuffer);
                    if (this._debug) {
                        __log.debug(this._session + " wrap wrap " + this._result);
                    }
                    this._outNIOBuffer.setGetIndex(0);
                    this._outNIOBuffer.setPutIndex(this._result.bytesProduced());
                    consumed = this._result.bytesConsumed();
                    Object var6_5 = null;
                    this._outBuffer.position(0);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this._outBuffer.position(0);
                    if (consumed > 0) {
                        int len = consumed < buffer.length() ? consumed : buffer.length();
                        buffer.skip(len);
                        consumed -= len;
                        this._gather[0].position(0);
                        this._gather[0].limit(this._gather[0].capacity());
                    }
                    assert (consumed == 0);
                    throw throwable;
                }
                if (consumed > 0) {
                    int len = consumed < buffer.length() ? consumed : buffer.length();
                    buffer.skip(len);
                    consumed -= len;
                    this._gather[0].position(0);
                    this._gather[0].limit(this._gather[0].capacity());
                }
                assert (consumed == 0);
            }
        }
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: 
            case BUFFER_UNDERFLOW: {
                Log.warn("unwrap {}", this._result);
            }
            case OK: {
                return this._result.bytesConsumed();
            }
            case CLOSED: {
                this._closing = true;
                return this._result.bytesConsumed() > 0 ? this._result.bytesConsumed() : -1;
            }
        }
        Log.warn("wrap " + this._result);
        throw new IOException(this._result.toString());
    }

    public boolean isBufferingInput() {
        return this._inNIOBuffer.hasContent();
    }

    public boolean isBufferingOutput() {
        return this._outNIOBuffer.hasContent();
    }

    public boolean isBufferred() {
        return true;
    }

    public SSLEngine getSSLEngine() {
        return this._engine;
    }

    public String toString() {
        return super.toString() + "," + (Object)((Object)this._engine.getHandshakeStatus()) + ", in/out=" + this._inNIOBuffer.length() + "/" + this._outNIOBuffer.length() + " " + this._result;
    }
}

