/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlProcessor;

public class WebXmlConfiguration
implements Configuration {
    public void preConfigure(WebAppContext context) throws Exception {
        Resource webxml;
        String defaultsDescriptor;
        if (context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        WebXmlProcessor processor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (processor == null) {
            processor = new WebXmlProcessor(context);
            context.setAttribute("org.eclipse.jetty.webProcessor", processor);
        }
        if ((defaultsDescriptor = context.getDefaultsDescriptor()) != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = Resource.newSystemResource(defaultsDescriptor);
            if (dftResource == null) {
                dftResource = context.newResource(defaultsDescriptor);
            }
            processor.parseDefaults(dftResource);
            processor.processDefaults();
        }
        if ((webxml = this.findWebXml(context)) != null) {
            processor.parseWebXml(webxml);
        }
    }

    public void configure(WebAppContext context) throws Exception {
        if (context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        WebXmlProcessor processor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (processor == null) {
            processor = new WebXmlProcessor(context);
            context.setAttribute("org.eclipse.jetty.webProcessor", processor);
        }
        processor.processWebXml();
        String overrideDescriptor = context.getOverrideDescriptor();
        if (overrideDescriptor != null && overrideDescriptor.length() > 0) {
            Resource orideResource = Resource.newSystemResource(overrideDescriptor);
            if (orideResource == null) {
                orideResource = context.newResource(overrideDescriptor);
            }
            processor.parseOverride(orideResource);
            processor.processOverride();
        }
    }

    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute("org.eclipse.jetty.webProcessor", null);
        context.setAttribute("org.eclipse.jetty.metadataComplete", null);
        context.setAttribute("org.eclipse.jetty.webXmlVersion", null);
        context.setAttribute("org.eclipse.jetty.webXmlClassNames", null);
    }

    protected Resource findWebXml(WebAppContext context) throws IOException, MalformedURLException {
        Resource web;
        String descriptor = context.getDescriptor();
        if (descriptor != null && (web = context.newResource(descriptor)).exists() && !web.isDirectory()) {
            return web;
        }
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource web2 = web_inf.addPath("web.xml");
            if (web2.exists()) {
                return web2;
            }
            Log.debug("No WEB-INF/web.xml in " + context.getWar() + ". Serving files and default/dynamic servlets only");
        }
        return null;
    }

    public void deconfigure(WebAppContext context) throws Exception {
        ServletHandler _servletHandler = context.getServletHandler();
        SecurityHandler _securityHandler = context.getSecurityHandler();
        _servletHandler.setFilters(null);
        _servletHandler.setFilterMappings(null);
        _servletHandler.setServlets(null);
        _servletHandler.setServletMappings(null);
        context.setEventListeners(null);
        context.setWelcomeFiles(null);
        if (_securityHandler instanceof ConstraintAware) {
            ((ConstraintAware)((Object)_securityHandler)).setConstraintMappings(new ConstraintMapping[0], Collections.EMPTY_SET);
        }
        if (context.getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)context.getErrorHandler()).setErrorPages(null);
        }
    }
}

