/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.List;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlProcessor;

public class FragmentConfiguration
implements Configuration {
    public static final String FRAGMENT_RESOURCES = "org.eclipse.jetty.webFragments";

    public void preConfigure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        WebXmlProcessor processor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (processor == null) {
            processor = new WebXmlProcessor(context);
            context.setAttribute("org.eclipse.jetty.webProcessor", processor);
        }
        this.parseWebFragments(context, processor);
    }

    public void configure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        WebXmlProcessor processor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (processor == null) {
            processor = new WebXmlProcessor(context);
            context.setAttribute("org.eclipse.jetty.webProcessor", processor);
        }
        processor.processFragments();
    }

    public void deconfigure(WebAppContext context) throws Exception {
    }

    public void postConfigure(WebAppContext context) throws Exception {
    }

    public void parseWebFragments(WebAppContext context, WebXmlProcessor processor) throws Exception {
        List frags = (List)context.getAttribute(FRAGMENT_RESOURCES);
        if (frags != null) {
            for (Resource frag : frags) {
                processor.parseFragment("jar:" + frag.getURL() + "!/META-INF/web-fragment.xml");
            }
        }
    }
}

