/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi.modules;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.jaspi.modules.BaseAuthModule;
import org.eclipse.jetty.util.security.Password;

@Deprecated
public class ClientCertAuthModule
extends BaseAuthModule {
    public ClientCertAuthModule() {
    }

    public ClientCertAuthModule(CallbackHandler callbackHandler) {
        super(callbackHandler);
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        try {
            String password;
            String username;
            if (certs == null || certs.length == 0 || certs[0] == null) {
                response.sendError(403, "A client certificate is required for accessing this web application but the server's listener is not configured for mutual authentication (or the client did not provide a certificate).");
                return AuthStatus.SEND_FAILURE;
            }
            Principal principal = certs[0].getSubjectDN();
            if (principal == null) {
                principal = certs[0].getIssuerDN();
            }
            if (this.login(clientSubject, username = principal == null ? "clientcert" : principal.getName(), new Password(password = Base64.getEncoder().encodeToString(certs[0].getSignature())), "CLIENT_CERT", messageInfo)) {
                return AuthStatus.SUCCESS;
            }
            if (!this.isMandatory(messageInfo)) {
                return AuthStatus.SUCCESS;
            }
            response.sendError(403, "The provided client certificate does not correspond to a trusted user.");
            return AuthStatus.SEND_FAILURE;
        }
        catch (IOException e) {
            throw new AuthException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new AuthException(e.getMessage());
        }
    }
}

