/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.servlet.ServletOutputStream;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class HttpOutput
extends ServletOutputStream {
    private static Logger LOG = Log.getLogger(HttpOutput.class);
    private final HttpChannel<?> _channel;
    private boolean _closed;
    private long _written;
    private ByteBuffer _aggregate;
    private int _bufferSize;

    public HttpOutput(HttpChannel<?> channel) {
        this._channel = channel;
        this._bufferSize = this._channel.getHttpConfiguration().getOutputBufferSize();
    }

    public boolean isWritten() {
        return this._written > 0L;
    }

    public long getWritten() {
        return this._written;
    }

    public void reset() {
        this._written = 0L;
        this.reopen();
    }

    public void reopen() {
        this._closed = false;
    }

    void closed() {
        if (!this._closed) {
            this._closed = true;
            try {
                this._channel.getResponse().closeOutput();
            }
            catch (IOException e) {
                this._channel.failed();
                LOG.ignore(e);
            }
            this.releaseBuffer();
        }
    }

    public void close() {
        if (!this.isClosed()) {
            try {
                if (BufferUtil.hasContent(this._aggregate)) {
                    this._channel.write(this._aggregate, !this._channel.getResponse().isIncluding());
                } else {
                    this._channel.write(BufferUtil.EMPTY_BUFFER, !this._channel.getResponse().isIncluding());
                }
            }
            catch (IOException e) {
                this._channel.failed();
                LOG.ignore(e);
            }
        }
        this.closed();
    }

    private void releaseBuffer() {
        if (this._aggregate != null) {
            this._channel.getConnector().getByteBufferPool().release(this._aggregate);
            this._aggregate = null;
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void flush() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (BufferUtil.hasContent(this._aggregate)) {
            this._channel.write(this._aggregate, false);
        } else {
            this._channel.write(BufferUtil.EMPTY_BUFFER, false);
        }
    }

    public boolean isAllContentWritten() {
        Response response = this._channel.getResponse();
        return response.isAllContentWritten(this._written);
    }

    public void closeOutput() throws IOException {
        this._channel.getResponse().closeOutput();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed()) {
            throw new EofException("Closed");
        }
        this._written += (long)len;
        boolean complete = this._channel.getResponse().isAllContentWritten(this._written);
        int capacity = this.getBufferSize();
        if (!complete && len <= capacity / 4) {
            if (this._aggregate == null) {
                this._aggregate = this._channel.getByteBufferPool().acquire(capacity, false);
            }
            int filled = BufferUtil.fill(this._aggregate, b, off, len);
            if (!complete && filled == len && !BufferUtil.isFull(this._aggregate)) {
                return;
            }
            off += filled;
            len -= filled;
        }
        if (BufferUtil.hasContent(this._aggregate)) {
            this._channel.write(this._aggregate, complete && len == 0);
            if (len > 0 && !complete && len <= this._aggregate.capacity() / 4) {
                BufferUtil.append(this._aggregate, b, off, len);
                return;
            }
        }
        if (len > 0) {
            this._channel.write(ByteBuffer.wrap(b, off, len), complete);
        } else if (complete) {
            this._channel.write(BufferUtil.EMPTY_BUFFER, complete);
        }
        if (complete) {
            this.closed();
        }
    }

    public void write(int b) throws IOException {
        if (this.isClosed()) {
            throw new EOFException("Closed");
        }
        if (this._aggregate == null) {
            this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), false);
        }
        BufferUtil.append(this._aggregate, (byte)b);
        ++this._written;
        boolean complete = this._channel.getResponse().isAllContentWritten(this._written);
        if (complete || BufferUtil.isFull(this._aggregate)) {
            BlockingCallback callback = this._channel.getWriteBlockingCallback();
            this._channel.write(this._aggregate, false, callback);
            callback.block();
            if (complete) {
                this.closed();
            }
        }
    }

    public void print(String s) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        this.write(s.getBytes(this._channel.getResponse().getCharacterEncoding()));
    }

    @Deprecated
    public void sendContent(Object content) throws IOException {
        BlockingCallback callback = this._channel.getWriteBlockingCallback();
        if (content instanceof HttpContent) {
            this._channel.getResponse().setHeaders((HttpContent)content);
            this.sendContent((HttpContent)content, (Callback)callback);
        } else if (content instanceof Resource) {
            Resource resource = (Resource)content;
            this._channel.getResponse().getHttpFields().putDateField(HttpHeader.LAST_MODIFIED, resource.lastModified());
            ReadableByteChannel in = ((Resource)content).getReadableByteChannel();
            if (in != null) {
                this.sendContent(in, (Callback)callback);
            } else {
                this.sendContent(resource.getInputStream(), (Callback)callback);
            }
        } else if (content instanceof ByteBuffer) {
            this.sendContent((ByteBuffer)content, (Callback)callback);
        } else if (content instanceof ReadableByteChannel) {
            this.sendContent((ReadableByteChannel)content, (Callback)callback);
        } else if (content instanceof InputStream) {
            this.sendContent((InputStream)content, (Callback)callback);
        } else {
            callback.failed(new IllegalArgumentException("unknown content type " + content.getClass()));
        }
        callback.block();
    }

    public void sendContent(ByteBuffer content) throws IOException {
        BlockingCallback callback = this._channel.getWriteBlockingCallback();
        this._channel.write(content, true, callback);
        callback.block();
    }

    public void sendContent(InputStream in) throws IOException {
        BlockingCallback callback = this._channel.getWriteBlockingCallback();
        new InputStreamWritingCB(in, callback).iterate();
        callback.block();
    }

    public void sendContent(ReadableByteChannel in) throws IOException {
        BlockingCallback callback = this._channel.getWriteBlockingCallback();
        new ReadableByteChannelWritingCB(in, callback).iterate();
        callback.block();
    }

    public void sendContent(HttpContent content) throws IOException {
        BlockingCallback callback = this._channel.getWriteBlockingCallback();
        this.sendContent(content, (Callback)callback);
        callback.block();
    }

    public void sendContent(ByteBuffer content, final Callback callback) {
        this._channel.write(content, true, new Callback(){

            @Override
            public void succeeded() {
                HttpOutput.this.closed();
                callback.succeeded();
            }

            @Override
            public void failed(Throwable x) {
                callback.failed(x);
            }
        });
    }

    public void sendContent(InputStream in, Callback callback) {
        new InputStreamWritingCB(in, callback).iterate();
    }

    public void sendContent(ReadableByteChannel in, Callback callback) {
        new ReadableByteChannelWritingCB(in, callback).iterate();
    }

    public void sendContent(HttpContent httpContent, Callback callback) throws IOException {
        ByteBuffer buffer;
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        if (BufferUtil.hasContent(this._aggregate)) {
            throw new IOException("written");
        }
        if (this._channel.isCommitted()) {
            throw new IOException("committed");
        }
        ByteBuffer byteBuffer = buffer = this._channel.useDirectBuffers() ? httpContent.getDirectBuffer() : null;
        if (buffer == null) {
            buffer = httpContent.getIndirectBuffer();
        }
        if (buffer != null) {
            this.sendContent(buffer, callback);
            return;
        }
        ReadableByteChannel rbc = httpContent.getReadableByteChannel();
        if (rbc != null) {
            this.sendContent(rbc, callback);
            return;
        }
        InputStream in = httpContent.getInputStream();
        if (in != null) {
            this.sendContent(in, callback);
            return;
        }
        callback.failed(new IllegalArgumentException("unknown content for " + httpContent));
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    public void resetBuffer() {
        if (BufferUtil.hasContent(this._aggregate)) {
            BufferUtil.clear(this._aggregate);
        }
    }

    private class ReadableByteChannelWritingCB
    extends IteratingCallback {
        private final ReadableByteChannel _in;
        private final ByteBuffer _buffer;
        private boolean _eof;

        public ReadableByteChannelWritingCB(ReadableByteChannel in, Callback callback) {
            super(callback);
            this._in = in;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), HttpOutput.this._channel.useDirectBuffers());
        }

        @Override
        protected boolean process() throws Exception {
            if (this._eof) {
                this._in.close();
                HttpOutput.this.closed();
                HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                return true;
            }
            this._buffer.clear();
            while (this._buffer.hasRemaining() && !this._eof) {
                this._eof = this._in.read(this._buffer) < 0;
            }
            this._buffer.flip();
            HttpOutput.this._channel.write(this._buffer, this._eof, this);
            return false;
        }

        @Override
        public void failed(Throwable x) {
            super.failed(x);
            HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
            try {
                this._in.close();
            }
            catch (IOException e) {
                LOG.ignore(e);
            }
        }
    }

    private class InputStreamWritingCB
    extends IteratingCallback {
        private final InputStream _in;
        private final ByteBuffer _buffer;
        private boolean _eof;

        public InputStreamWritingCB(InputStream in, Callback callback) {
            super(callback);
            this._in = in;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), false);
        }

        @Override
        protected boolean process() throws Exception {
            if (this._eof) {
                this._in.close();
                HttpOutput.this.closed();
                HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                return true;
            }
            int len = 0;
            while (len < this._buffer.capacity() && !this._eof) {
                int r = this._in.read(this._buffer.array(), this._buffer.arrayOffset() + len, this._buffer.capacity() - len);
                if (r < 0) {
                    this._eof = true;
                    continue;
                }
                len += r;
            }
            this._buffer.position(0);
            this._buffer.limit(len);
            HttpOutput.this._channel.write(this._buffer, this._eof, this);
            return false;
        }

        @Override
        public void failed(Throwable x) {
            super.failed(x);
            HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
            try {
                this._in.close();
            }
            catch (IOException e) {
                LOG.ignore(e);
            }
        }
    }
}

