/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.client.FlowControlStrategyFactory;
import org.eclipse.jetty.spdy.client.NextProtoNegoClientConnection;
import org.eclipse.jetty.spdy.client.SPDYClientConnectionFactory;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class SPDYClient {
    private final SPDYClientConnectionFactory connectionFactory = new SPDYClientConnectionFactory();
    final short version;
    final Factory factory;
    private volatile SocketAddress bindAddress;
    private volatile long idleTimeout = -1L;
    private volatile int initialWindowSize;
    private volatile boolean executeOnFillable;

    protected SPDYClient(short version, Factory factory) {
        this.version = version;
        this.factory = factory;
        this.setInitialWindowSize(65536);
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public Future<Session> connect(InetSocketAddress address, SessionFrameListener listener) throws IOException {
        if (!this.factory.isStarted()) {
            throw new IllegalStateException(Factory.class.getSimpleName() + " is not started");
        }
        SocketChannel channel = SocketChannel.open();
        if (this.bindAddress != null) {
            channel.bind(this.bindAddress);
        }
        channel.socket().setTcpNoDelay(true);
        channel.configureBlocking(false);
        SessionPromise result = new SessionPromise(channel, this, listener);
        channel.connect(address);
        this.factory.selector.connect(channel, result);
        return result;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public boolean isExecuteOnFillable() {
        return this.executeOnFillable;
    }

    public void setExecuteOnFillable(boolean executeOnFillable) {
        this.executeOnFillable = executeOnFillable;
    }

    protected String selectProtocol(List<String> serverProtocols) {
        String protocol = "spdy/" + this.version;
        for (String serverProtocol : serverProtocols) {
            if (!serverProtocol.equals(protocol)) continue;
            return protocol;
        }
        return null;
    }

    public SPDYClientConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected SSLEngine newSSLEngine(SslContextFactory sslContextFactory, SocketChannel channel) {
        String peerHost = channel.socket().getInetAddress().getHostName();
        int peerPort = channel.socket().getPort();
        SSLEngine engine = sslContextFactory.newSSLEngine(peerHost, peerPort);
        engine.setUseClientMode(true);
        return engine;
    }

    protected FlowControlStrategy newFlowControlStrategy() {
        return FlowControlStrategyFactory.newFlowControlStrategy(this.version);
    }

    static class SessionPromise
    extends FuturePromise<Session> {
        private final SocketChannel channel;
        final SPDYClient client;
        final SessionFrameListener listener;

        private SessionPromise(SocketChannel channel, SPDYClient client, SessionFrameListener listener) {
            this.channel = channel;
            this.client = client;
            this.listener = listener;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                super.cancel(mayInterruptIfRunning);
                this.channel.close();
                return true;
            }
            catch (IOException x) {
                return true;
            }
        }
    }

    public static class Factory
    extends ContainerLifeCycle {
        private final Queue<Session> sessions = new ConcurrentLinkedQueue<Session>();
        private final ByteBufferPool bufferPool = new MappedByteBufferPool();
        private final Scheduler scheduler;
        private final Executor executor;
        private final SslContextFactory sslContextFactory;
        private final SelectorManager selector;
        private final long idleTimeout;
        private long connectTimeout = 15000L;

        public Factory() {
            this(null, null);
        }

        public Factory(SslContextFactory sslContextFactory) {
            this(null, null, sslContextFactory);
        }

        public Factory(Executor executor) {
            this(executor, null);
        }

        public Factory(Executor executor, Scheduler scheduler) {
            this(executor, scheduler, null);
        }

        public Factory(Executor executor, Scheduler scheduler, SslContextFactory sslContextFactory) {
            this(executor, scheduler, sslContextFactory, 30000L);
        }

        public Factory(Executor executor, Scheduler scheduler, SslContextFactory sslContextFactory, long idleTimeout) {
            this.idleTimeout = idleTimeout;
            if (executor == null) {
                executor = new QueuedThreadPool();
            }
            this.executor = executor;
            this.addBean(executor);
            if (scheduler == null) {
                scheduler = new ScheduledExecutorScheduler();
            }
            this.scheduler = scheduler;
            this.addBean(scheduler);
            this.sslContextFactory = sslContextFactory;
            if (sslContextFactory != null) {
                this.addBean(sslContextFactory);
            }
            this.selector = new ClientSelectorManager(executor, scheduler);
            this.selector.setConnectTimeout(this.getConnectTimeout());
            this.addBean(this.selector);
        }

        public ByteBufferPool getByteBufferPool() {
            return this.bufferPool;
        }

        public Scheduler getScheduler() {
            return this.scheduler;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public long getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public SPDYClient newSPDYClient(short version) {
            return new SPDYClient(version, this);
        }

        @Override
        protected void doStop() throws Exception {
            this.closeConnections();
            super.doStop();
        }

        boolean sessionOpened(Session session) {
            return this.isRunning() && this.sessions.offer(session);
        }

        boolean sessionClosed(Session session) {
            return this.isRunning() && this.sessions.remove(session);
        }

        private void closeConnections() {
            for (Session session : this.sessions) {
                session.goAway(new GoAwayInfo(), new Callback.Adapter());
            }
            this.sessions.clear();
        }

        public Collection<Session> getSessions() {
            return Collections.unmodifiableCollection(this.sessions);
        }

        private class ClientSelectorManager
        extends SelectorManager {
            private ClientSelectorManager(Executor executor, Scheduler scheduler) {
                super(executor, scheduler);
            }

            @Override
            protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selectSet, SelectionKey key) throws IOException {
                SessionPromise attachment = (SessionPromise)key.attachment();
                long clientIdleTimeout = attachment.client.getIdleTimeout();
                if (clientIdleTimeout < 0L) {
                    clientIdleTimeout = Factory.this.idleTimeout;
                }
                return new SelectChannelEndPoint(channel, selectSet, key, this.getScheduler(), clientIdleTimeout);
            }

            @Override
            public Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) {
                SessionPromise sessionPromise = (SessionPromise)attachment;
                SPDYClient client = sessionPromise.client;
                try {
                    if (Factory.this.sslContextFactory != null) {
                        SSLEngine engine = client.newSSLEngine(Factory.this.sslContextFactory, channel);
                        SslConnection sslConnection = new SslConnection(Factory.this.bufferPool, this.getExecutor(), endPoint, engine);
                        sslConnection.setRenegotiationAllowed(Factory.this.sslContextFactory.isRenegotiationAllowed());
                        SslConnection.DecryptedEndPoint sslEndPoint = sslConnection.getDecryptedEndPoint();
                        NextProtoNegoClientConnection connection = new NextProtoNegoClientConnection(channel, sslEndPoint, attachment, this.getExecutor(), client);
                        sslEndPoint.setConnection(connection);
                        return sslConnection;
                    }
                    SPDYClientConnectionFactory connectionFactory = new SPDYClientConnectionFactory();
                    return connectionFactory.newConnection(channel, endPoint, attachment);
                }
                catch (RuntimeException x) {
                    sessionPromise.failed(x);
                    throw x;
                }
            }
        }
    }
}

