/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.PushInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.http.HttpChannelOverSPDY;
import org.eclipse.jetty.spdy.server.http.HttpInputOverSPDY;
import org.eclipse.jetty.spdy.server.http.PushStrategy;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpTransportOverSPDY
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverSPDY.class);
    private final Connector connector;
    private final HttpConfiguration configuration;
    private final EndPoint endPoint;
    private final PushStrategy pushStrategy;
    private final Stream stream;
    private final Fields requestHeaders;
    private final BlockingCallback streamBlocker = new BlockingCallback();
    private final AtomicBoolean committed = new AtomicBoolean();

    public HttpTransportOverSPDY(Connector connector, HttpConfiguration configuration, EndPoint endPoint, PushStrategy pushStrategy, Stream stream, Fields requestHeaders) {
        this.connector = connector;
        this.configuration = configuration;
        this.endPoint = endPoint;
        this.pushStrategy = pushStrategy == null ? new PushStrategy.None() : pushStrategy;
        this.stream = stream;
        this.requestHeaders = requestHeaders;
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("send  {} {} {} {} last={}", this, this.stream, info, BufferUtil.toDetailString(content), lastContent);
        }
        if (this.stream.isClosed() || this.stream.isReset()) {
            EofException exception = new EofException("stream closed");
            callback.failed(exception);
            return;
        }
        boolean hasContent = BufferUtil.hasContent(content);
        if (info != null) {
            if (!this.committed.compareAndSet(false, true)) {
                StreamException exception = new StreamException(this.stream.getId(), StreamStatus.PROTOCOL_ERROR, "Stream already committed!");
                callback.failed(exception);
                LOG.warn("Committed response twice.", exception);
                return;
            }
            short version = this.stream.getSession().getVersion();
            Fields headers = new Fields();
            HttpVersion httpVersion = HttpVersion.HTTP_1_1;
            headers.put(HTTPSPDYHeader.VERSION.name(version), httpVersion.asString());
            int status = info.getStatus();
            StringBuilder httpStatus = new StringBuilder().append(status);
            String reason = info.getReason();
            if (reason == null) {
                reason = HttpStatus.getMessage(status);
            }
            if (reason != null) {
                httpStatus.append(" ").append(reason);
            }
            headers.put(HTTPSPDYHeader.STATUS.name(version), httpStatus.toString());
            LOG.debug("HTTP < {} {}", new Object[]{httpVersion, httpStatus});
            HttpFields fields = info.getHttpFields();
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    HttpField field = fields.getField(i);
                    String name = field.getName();
                    String value = field.getValue();
                    headers.put(name, value);
                    LOG.debug("HTTP < {}: {}", name, value);
                }
            }
            boolean close = !hasContent && lastContent;
            ReplyInfo reply = new ReplyInfo(headers, close);
            this.reply(this.stream, reply);
        }
        if (hasContent) {
            if (this.stream.isClosed() || this.stream.isReset()) {
                callback.failed(new EofException("stream closed"));
            } else {
                this.stream.data(new ByteBufferDataInfo(this.endPoint.getIdleTimeout(), TimeUnit.MILLISECONDS, content, lastContent), callback);
            }
        } else if (lastContent) {
            if (this.stream.isClosed() || this.stream.isReset()) {
                callback.succeeded();
            } else {
                this.stream.data(new ByteBufferDataInfo(this.endPoint.getIdleTimeout(), TimeUnit.MILLISECONDS, BufferUtil.EMPTY_BUFFER, lastContent), callback);
            }
        } else {
            callback.succeeded();
        }
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent) throws EofException {
        this.send(info, content, lastContent, this.streamBlocker);
        try {
            this.streamBlocker.block();
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            LOG.debug(e);
        }
    }

    @Override
    public void completed() {
        LOG.debug("completed", new Object[0]);
    }

    private void reply(Stream stream, ReplyInfo replyInfo) {
        if (!stream.isUnidirectional()) {
            stream.reply(replyInfo, new Callback.Adapter());
        } else {
            stream.headers(new HeadersInfo(replyInfo.getHeaders(), replyInfo.isClose()), new Callback.Adapter());
        }
        Fields responseHeaders = replyInfo.getHeaders();
        short version = stream.getSession().getVersion();
        if (responseHeaders.get(HTTPSPDYHeader.STATUS.name(version)).value().startsWith("200") && !stream.isClosed()) {
            Fields.Field scheme = this.requestHeaders.get(HTTPSPDYHeader.SCHEME.name(version));
            Fields.Field host = this.requestHeaders.get(HTTPSPDYHeader.HOST.name(version));
            Fields.Field uri = this.requestHeaders.get(HTTPSPDYHeader.URI.name(version));
            Set<String> pushResources = this.pushStrategy.apply(stream, this.requestHeaders, responseHeaders);
            for (String pushResource : pushResources) {
                Fields pushHeaders = this.createPushHeaders(scheme, host, pushResource);
                final Fields pushRequestHeaders = this.createRequestHeaders(scheme, host, uri, pushResource);
                stream.push(new PushInfo(0L, TimeUnit.MILLISECONDS, pushHeaders, false), (Promise<Stream>)new Promise.Adapter<Stream>(){

                    @Override
                    public void succeeded(Stream pushStream) {
                        HttpChannelOverSPDY pushChannel = HttpTransportOverSPDY.this.newHttpChannelOverSPDY(pushStream, pushRequestHeaders);
                        pushChannel.requestStart(pushRequestHeaders, true);
                    }
                });
            }
        }
    }

    private Fields createRequestHeaders(Fields.Field scheme, Fields.Field host, Fields.Field uri, String pushResourcePath) {
        Fields newRequestHeaders = new Fields(this.requestHeaders, false);
        short version = this.stream.getSession().getVersion();
        newRequestHeaders.put(HTTPSPDYHeader.METHOD.name(version), "GET");
        newRequestHeaders.put(HTTPSPDYHeader.VERSION.name(version), "HTTP/1.1");
        newRequestHeaders.put(scheme);
        newRequestHeaders.put(host);
        newRequestHeaders.put(HTTPSPDYHeader.URI.name(version), pushResourcePath);
        String referrer = scheme.value() + "://" + host.value() + uri.value();
        newRequestHeaders.put("referer", referrer);
        newRequestHeaders.put("x-spdy-push", "true");
        return newRequestHeaders;
    }

    private Fields createPushHeaders(Fields.Field scheme, Fields.Field host, String pushResourcePath) {
        Fields pushHeaders = new Fields();
        short version = this.stream.getSession().getVersion();
        if (version == 2) {
            pushHeaders.put(HTTPSPDYHeader.URI.name(version), scheme.value() + "://" + host.value() + pushResourcePath);
        } else {
            pushHeaders.put(HTTPSPDYHeader.URI.name(version), pushResourcePath);
            pushHeaders.put(scheme);
            pushHeaders.put(host);
        }
        return pushHeaders;
    }

    private HttpChannelOverSPDY newHttpChannelOverSPDY(Stream pushStream, Fields pushRequestHeaders) {
        HttpTransportOverSPDY transport = new HttpTransportOverSPDY(this.connector, this.configuration, this.endPoint, this.pushStrategy, pushStream, pushRequestHeaders);
        HttpInputOverSPDY input = new HttpInputOverSPDY();
        return new HttpChannelOverSPDY(this.connector, this.configuration, this.endPoint, transport, input, pushStream);
    }
}

