/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.IdleListener;
import org.eclipse.jetty.spdy.PushSynInfo;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.StandardStream;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.GoAwayResultInfo;
import org.eclipse.jetty.spdy.api.PingInfo;
import org.eclipse.jetty.spdy.api.PingResultInfo;
import org.eclipse.jetty.spdy.api.PushInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.SPDYException;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.api.Settings;
import org.eclipse.jetty.spdy.api.SettingsInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.spdy.frames.CredentialFrame;
import org.eclipse.jetty.spdy.frames.DataFrame;
import org.eclipse.jetty.spdy.frames.GoAwayFrame;
import org.eclipse.jetty.spdy.frames.HeadersFrame;
import org.eclipse.jetty.spdy.frames.PingFrame;
import org.eclipse.jetty.spdy.frames.RstStreamFrame;
import org.eclipse.jetty.spdy.frames.SettingsFrame;
import org.eclipse.jetty.spdy.frames.SynReplyFrame;
import org.eclipse.jetty.spdy.frames.SynStreamFrame;
import org.eclipse.jetty.spdy.frames.WindowUpdateFrame;
import org.eclipse.jetty.spdy.generator.Generator;
import org.eclipse.jetty.spdy.parser.Parser;
import org.eclipse.jetty.util.Atomics;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ForkInvoker;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class StandardSession
implements ISession,
Parser.Listener,
Dumpable {
    private static final Logger LOG = Log.getLogger(Session.class);
    private final ForkInvoker<Callback> invoker = new SessionInvoker();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final List<Session.Listener> listeners = new CopyOnWriteArrayList<Session.Listener>();
    private final ConcurrentMap<Integer, IStream> streams = new ConcurrentHashMap<Integer, IStream>();
    private final LinkedList<FrameBytes> queue = new LinkedList();
    private final ByteBufferPool bufferPool;
    private final Executor threadPool;
    private final Scheduler scheduler;
    private final short version;
    private final Controller controller;
    private final EndPoint endPoint;
    private final IdleListener idleListener;
    private final AtomicInteger streamIds;
    private final AtomicInteger pingIds;
    private final SessionFrameListener listener;
    private final Generator generator;
    private final AtomicBoolean goAwaySent = new AtomicBoolean();
    private final AtomicBoolean goAwayReceived = new AtomicBoolean();
    private final AtomicInteger lastStreamId = new AtomicInteger();
    private final FlowControlStrategy flowControlStrategy;
    private boolean flushing;
    private Throwable failure;

    public StandardSession(short version, ByteBufferPool bufferPool, Executor threadPool, Scheduler scheduler, Controller controller, EndPoint endPoint, IdleListener idleListener, int initialStreamId, SessionFrameListener listener, Generator generator, FlowControlStrategy flowControlStrategy) {
        this.version = version;
        this.bufferPool = bufferPool;
        this.threadPool = threadPool;
        this.scheduler = scheduler;
        this.controller = controller;
        this.endPoint = endPoint;
        this.idleListener = idleListener;
        this.streamIds = new AtomicInteger(initialStreamId);
        this.pingIds = new AtomicInteger(initialStreamId);
        this.listener = listener;
        this.generator = generator;
        this.flowControlStrategy = flowControlStrategy;
    }

    @Override
    public short getVersion() {
        return this.version;
    }

    @Override
    public void addListener(Session.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Session.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Stream syn(SynInfo synInfo, StreamFrameListener listener) throws ExecutionException, InterruptedException, TimeoutException {
        FuturePromise<Stream> result = new FuturePromise<Stream>();
        this.syn(synInfo, listener, result);
        if (synInfo.getTimeout() > 0L) {
            return result.get(synInfo.getTimeout(), synInfo.getUnit());
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syn(SynInfo synInfo, StreamFrameListener listener, Promise<Stream> promise) {
        int associatedStreamId = 0;
        if (synInfo instanceof PushSynInfo) {
            associatedStreamId = ((PushSynInfo)synInfo).getAssociatedStreamId();
        }
        StandardSession standardSession = this;
        synchronized (standardSession) {
            int streamId = this.streamIds.getAndAdd(2);
            SynStreamFrame synStream = new SynStreamFrame(this.version, synInfo.getFlags(), streamId, associatedStreamId, synInfo.getPriority(), 0, synInfo.getHeaders());
            IStream stream = this.createStream(synStream, listener, true, promise);
            this.generateAndEnqueueControlFrame(stream, synStream, synInfo.getTimeout(), synInfo.getUnit(), stream);
        }
        this.flush();
    }

    @Override
    public void rst(RstInfo rstInfo) throws InterruptedException, ExecutionException, TimeoutException {
        FutureCallback result = new FutureCallback();
        this.rst(rstInfo, result);
        if (rstInfo.getTimeout() > 0L) {
            result.get(rstInfo.getTimeout(), rstInfo.getUnit());
        } else {
            result.get();
        }
    }

    @Override
    public void rst(RstInfo rstInfo, Callback callback) {
        if (this.goAwaySent.get()) {
            this.complete(callback);
        } else {
            int streamId = rstInfo.getStreamId();
            IStream stream = (IStream)this.streams.get(streamId);
            RstStreamFrame frame = new RstStreamFrame(this.version, streamId, rstInfo.getStreamStatus().getCode(this.version));
            this.control(stream, frame, rstInfo.getTimeout(), rstInfo.getUnit(), callback);
            if (stream != null) {
                stream.process(frame);
                this.removeStream(stream);
            }
        }
    }

    @Override
    public void settings(SettingsInfo settingsInfo) throws ExecutionException, InterruptedException, TimeoutException {
        FutureCallback result = new FutureCallback();
        this.settings(settingsInfo, result);
        if (settingsInfo.getTimeout() > 0L) {
            result.get(settingsInfo.getTimeout(), settingsInfo.getUnit());
        } else {
            result.get();
        }
    }

    @Override
    public void settings(SettingsInfo settingsInfo, Callback callback) {
        SettingsFrame frame = new SettingsFrame(this.version, settingsInfo.getFlags(), settingsInfo.getSettings());
        this.control(null, frame, settingsInfo.getTimeout(), settingsInfo.getUnit(), callback);
    }

    @Override
    public PingResultInfo ping(PingInfo pingInfo) throws ExecutionException, InterruptedException, TimeoutException {
        FuturePromise<PingResultInfo> result = new FuturePromise<PingResultInfo>();
        this.ping(pingInfo, result);
        if (pingInfo.getTimeout() > 0L) {
            return result.get(pingInfo.getTimeout(), pingInfo.getUnit());
        }
        return result.get();
    }

    @Override
    public void ping(PingInfo pingInfo, Promise<PingResultInfo> promise) {
        int pingId = this.pingIds.getAndAdd(2);
        PingInfoCallback pingInfoCallback = new PingInfoCallback(pingId, promise);
        PingFrame frame = new PingFrame(this.version, pingId);
        this.control(null, frame, pingInfo.getTimeout(), pingInfo.getUnit(), pingInfoCallback);
    }

    @Override
    public void goAway(GoAwayInfo goAwayInfo) throws ExecutionException, InterruptedException, TimeoutException {
        this.goAway(goAwayInfo, SessionStatus.OK);
    }

    private void goAway(GoAwayInfo goAwayInfo, SessionStatus sessionStatus) throws ExecutionException, InterruptedException, TimeoutException {
        FutureCallback result = new FutureCallback();
        this.goAway(sessionStatus, goAwayInfo.getTimeout(), goAwayInfo.getUnit(), result);
        if (goAwayInfo.getTimeout() > 0L) {
            result.get(goAwayInfo.getTimeout(), goAwayInfo.getUnit());
        } else {
            result.get();
        }
    }

    @Override
    public void goAway(GoAwayInfo goAwayInfo, Callback callback) {
        this.goAway(SessionStatus.OK, goAwayInfo.getTimeout(), goAwayInfo.getUnit(), callback);
    }

    private void goAway(SessionStatus sessionStatus, long timeout, TimeUnit unit, Callback callback) {
        if (this.goAwaySent.compareAndSet(false, true) && !this.goAwayReceived.get()) {
            GoAwayFrame frame = new GoAwayFrame(this.version, this.lastStreamId.get(), sessionStatus.getCode());
            this.control(null, frame, timeout, unit, callback);
            return;
        }
        this.complete(callback);
    }

    @Override
    public Set<Stream> getStreams() {
        HashSet<Stream> result = new HashSet<Stream>();
        result.addAll(this.streams.values());
        return result;
    }

    @Override
    public IStream getStream(int streamId) {
        return (IStream)this.streams.get(streamId);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.endPoint.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.endPoint.getRemoteAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onControlFrame(ControlFrame frame) {
        this.notifyIdle(this.idleListener, false);
        try {
            LOG.debug("Processing {}", frame);
            if (this.goAwaySent.get()) {
                LOG.debug("Skipped processing of {}", frame);
                return;
            }
            switch (frame.getType()) {
                case SYN_STREAM: {
                    this.onSyn((SynStreamFrame)frame);
                    return;
                }
                case SYN_REPLY: {
                    this.onReply((SynReplyFrame)frame);
                    return;
                }
                case RST_STREAM: {
                    this.onRst((RstStreamFrame)frame);
                    return;
                }
                case SETTINGS: {
                    this.onSettings((SettingsFrame)frame);
                    return;
                }
                case NOOP: {
                    return;
                }
                case PING: {
                    this.onPing((PingFrame)frame);
                    return;
                }
                case GO_AWAY: {
                    this.onGoAway((GoAwayFrame)frame);
                    return;
                }
                case HEADERS: {
                    this.onHeaders((HeadersFrame)frame);
                    return;
                }
                case WINDOW_UPDATE: {
                    this.onWindowUpdate((WindowUpdateFrame)frame);
                    return;
                }
                case CREDENTIAL: {
                    this.onCredential((CredentialFrame)frame);
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.notifyIdle(this.idleListener, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataFrame(DataFrame frame, ByteBuffer data) {
        this.notifyIdle(this.idleListener, false);
        try {
            LOG.debug("Processing {}, {} data bytes", frame, data.remaining());
            if (this.goAwaySent.get()) {
                LOG.debug("Skipped processing of {}", frame);
                return;
            }
            int streamId = frame.getStreamId();
            IStream stream = (IStream)this.streams.get(streamId);
            if (stream == null) {
                RstInfo rstInfo = new RstInfo(streamId, StreamStatus.INVALID_STREAM);
                LOG.debug("Unknown stream {}", rstInfo);
                this.rst(rstInfo, new Callback.Adapter());
            } else {
                this.processData(stream, frame, data);
            }
        }
        finally {
            this.notifyIdle(this.idleListener, true);
        }
    }

    private void notifyIdle(IdleListener listener, boolean idle) {
        if (listener != null) {
            listener.onIdle(idle);
        }
    }

    private void processData(final IStream stream, DataFrame frame, ByteBuffer data) {
        ByteBufferDataInfo dataInfo = new ByteBufferDataInfo(data, frame.isClose()){

            @Override
            public void consume(int delta) {
                super.consume(delta);
                StandardSession.this.flowControlStrategy.onDataConsumed(StandardSession.this, stream, this, delta);
            }
        };
        this.flowControlStrategy.onDataReceived(this, stream, dataInfo);
        stream.process(dataInfo);
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    @Override
    public void onStreamException(StreamException x) {
        this.notifyOnException(this.listener, x);
        this.rst(new RstInfo(x.getStreamId(), x.getStreamStatus()), new Callback.Adapter());
    }

    @Override
    public void onSessionException(SessionException x) {
        Throwable cause = x.getCause();
        this.notifyOnException(this.listener, cause == null ? x : cause);
        this.goAway(x.getSessionStatus(), 0L, TimeUnit.SECONDS, new Callback.Adapter());
    }

    private void onSyn(SynStreamFrame frame) {
        IStream stream = this.createStream(frame, null, false, null);
        if (stream != null) {
            this.processSyn(this.listener, stream, frame);
        }
    }

    private void processSyn(SessionFrameListener listener, IStream stream, SynStreamFrame frame) {
        StreamFrameListener streamListener;
        stream.process(frame);
        this.updateLastStreamId(stream);
        if (stream.isUnidirectional()) {
            PushInfo pushInfo = new PushInfo(frame.getHeaders(), frame.isClose());
            streamListener = this.notifyOnPush(stream.getAssociatedStream().getStreamFrameListener(), stream, pushInfo);
        } else {
            SynInfo synInfo = new SynInfo(frame.getHeaders(), frame.isClose(), frame.getPriority());
            streamListener = this.notifyOnSyn(listener, stream, synInfo);
        }
        stream.setStreamFrameListener(streamListener);
        this.flush();
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    private IStream createStream(SynStreamFrame frame, StreamFrameListener listener, boolean local, Promise<Stream> promise) {
        int streamId;
        IStream associatedStream = (IStream)this.streams.get(frame.getAssociatedStreamId());
        StandardStream stream = new StandardStream(frame.getStreamId(), frame.getPriority(), this, associatedStream, promise);
        this.flowControlStrategy.onNewStream(this, stream);
        stream.updateCloseState(frame.isClose(), local);
        stream.setStreamFrameListener(listener);
        if (stream.isUnidirectional()) {
            stream.updateCloseState(true, !local);
            if (!stream.isClosed()) {
                stream.getAssociatedStream().associate(stream);
            }
        }
        if (this.streams.putIfAbsent(streamId = stream.getId(), stream) != null) {
            if (local) {
                throw new IllegalStateException("Duplicate stream id " + streamId);
            }
            RstInfo rstInfo = new RstInfo(streamId, StreamStatus.PROTOCOL_ERROR);
            LOG.debug("Duplicate stream, {}", rstInfo);
            try {
                this.rst(rstInfo);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
            }
            return null;
        }
        LOG.debug("Created {}", stream);
        if (local) {
            this.notifyStreamCreated(stream);
        }
        return stream;
    }

    private void notifyStreamCreated(IStream stream) {
        for (Session.Listener listener : this.listeners) {
            if (!(listener instanceof Session.StreamListener)) continue;
            try {
                ((Session.StreamListener)listener).onStreamCreated(stream);
            }
            catch (Exception x) {
                LOG.info("Exception while notifying listener " + listener, x);
            }
            catch (Error x) {
                LOG.info("Exception while notifying listener " + listener, x);
                throw x;
            }
        }
    }

    private void removeStream(IStream stream) {
        IStream removed;
        if (stream.isUnidirectional()) {
            stream.getAssociatedStream().disassociate(stream);
        }
        if ((removed = (IStream)this.streams.remove(stream.getId())) != null) assert (removed == stream);
        LOG.debug("Removed {}", stream);
        this.notifyStreamClosed(stream);
    }

    private void notifyStreamClosed(IStream stream) {
        for (Session.Listener listener : this.listeners) {
            if (!(listener instanceof Session.StreamListener)) continue;
            try {
                ((Session.StreamListener)listener).onStreamClosed(stream);
            }
            catch (Exception x) {
                LOG.info("Exception while notifying listener " + listener, x);
            }
            catch (Error x) {
                LOG.info("Exception while notifying listener " + listener, x);
                throw x;
            }
        }
    }

    private void onReply(SynReplyFrame frame) {
        int streamId = frame.getStreamId();
        IStream stream = (IStream)this.streams.get(streamId);
        if (stream == null) {
            RstInfo rstInfo = new RstInfo(streamId, StreamStatus.INVALID_STREAM);
            LOG.debug("Unknown stream {}", rstInfo);
            this.rst(rstInfo, new Callback.Adapter());
        } else {
            this.processReply(stream, frame);
        }
    }

    private void processReply(IStream stream, SynReplyFrame frame) {
        stream.process(frame);
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    private void onRst(RstStreamFrame frame) {
        IStream stream = (IStream)this.streams.get(frame.getStreamId());
        if (stream != null) {
            stream.process(frame);
        }
        RstInfo rstInfo = new RstInfo(frame.getStreamId(), StreamStatus.from(frame.getVersion(), frame.getStatusCode()));
        this.notifyOnRst(this.listener, rstInfo);
        this.flush();
        if (stream != null) {
            this.removeStream(stream);
        }
    }

    private void onSettings(SettingsFrame frame) {
        Settings.Setting windowSizeSetting = frame.getSettings().get(Settings.ID.INITIAL_WINDOW_SIZE);
        if (windowSizeSetting != null) {
            int windowSize = windowSizeSetting.value();
            this.setWindowSize(windowSize);
            LOG.debug("Updated session window size to {}", windowSize);
        }
        SettingsInfo settingsInfo = new SettingsInfo(frame.getSettings(), frame.isClearPersisted());
        this.notifyOnSettings(this.listener, settingsInfo);
        this.flush();
    }

    private void onPing(PingFrame frame) {
        int pingId = frame.getPingId();
        if (pingId % 2 == this.pingIds.get() % 2) {
            PingResultInfo pingResultInfo = new PingResultInfo(frame.getPingId());
            this.notifyOnPing(this.listener, pingResultInfo);
            this.flush();
        } else {
            this.control(null, frame, 0L, TimeUnit.MILLISECONDS, new Callback.Adapter());
        }
    }

    private void onGoAway(GoAwayFrame frame) {
        if (this.goAwayReceived.compareAndSet(false, true)) {
            GoAwayResultInfo goAwayResultInfo = new GoAwayResultInfo(frame.getLastStreamId(), SessionStatus.from(frame.getStatusCode()));
            this.notifyOnGoAway(this.listener, goAwayResultInfo);
            this.flush();
        }
    }

    private void onHeaders(HeadersFrame frame) {
        int streamId = frame.getStreamId();
        IStream stream = (IStream)this.streams.get(streamId);
        if (stream == null) {
            RstInfo rstInfo = new RstInfo(streamId, StreamStatus.INVALID_STREAM);
            LOG.debug("Unknown stream, {}", rstInfo);
            this.rst(rstInfo, new Callback.Adapter());
        } else {
            this.processHeaders(stream, frame);
        }
    }

    private void processHeaders(IStream stream, HeadersFrame frame) {
        stream.process(frame);
        if (stream.isClosed()) {
            this.removeStream(stream);
        }
    }

    private void onWindowUpdate(WindowUpdateFrame frame) {
        int streamId = frame.getStreamId();
        IStream stream = (IStream)this.streams.get(streamId);
        this.flowControlStrategy.onWindowUpdate(this, stream, frame.getWindowDelta());
        this.flush();
    }

    private void onCredential(CredentialFrame frame) {
        LOG.warn("{} frame not yet supported", new Object[]{frame.getType()});
        this.flush();
    }

    protected void close() {
        if (this.controller != null) {
            this.controller.close(false);
        }
    }

    private void notifyOnException(SessionFrameListener listener, Throwable x) {
        try {
            if (listener != null) {
                LOG.debug("Invoking callback with {} on listener {}", x, listener);
                listener.onException(x);
            }
        }
        catch (Exception xx) {
            LOG.info("Exception while notifying listener " + listener, xx);
        }
        catch (Error xx) {
            LOG.info("Exception while notifying listener " + listener, xx);
            throw xx;
        }
    }

    private StreamFrameListener notifyOnPush(StreamFrameListener listener, Stream stream, PushInfo pushInfo) {
        try {
            if (listener == null) {
                return null;
            }
            LOG.debug("Invoking callback with {} on listener {}", pushInfo, listener);
            return listener.onPush(stream, pushInfo);
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, x);
            return null;
        }
        catch (Error x) {
            LOG.info("Exception while notifying listener " + listener, x);
            throw x;
        }
    }

    private StreamFrameListener notifyOnSyn(SessionFrameListener listener, Stream stream, SynInfo synInfo) {
        try {
            if (listener == null) {
                return null;
            }
            LOG.debug("Invoking callback with {} on listener {}", synInfo, listener);
            return listener.onSyn(stream, synInfo);
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, x);
            return null;
        }
        catch (Error x) {
            LOG.info("Exception while notifying listener " + listener, x);
            throw x;
        }
    }

    private void notifyOnRst(SessionFrameListener listener, RstInfo rstInfo) {
        try {
            if (listener != null) {
                LOG.debug("Invoking callback with {} on listener {}", rstInfo, listener);
                listener.onRst(this, rstInfo);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
        catch (Error x) {
            LOG.info("Exception while notifying listener " + listener, x);
            throw x;
        }
    }

    private void notifyOnSettings(SessionFrameListener listener, SettingsInfo settingsInfo) {
        try {
            if (listener != null) {
                LOG.debug("Invoking callback with {} on listener {}", settingsInfo, listener);
                listener.onSettings(this, settingsInfo);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
        catch (Error x) {
            LOG.info("Exception while notifying listener " + listener, x);
            throw x;
        }
    }

    private void notifyOnPing(SessionFrameListener listener, PingResultInfo pingResultInfo) {
        try {
            if (listener != null) {
                LOG.debug("Invoking callback with {} on listener {}", pingResultInfo, listener);
                listener.onPing(this, pingResultInfo);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
        catch (Error x) {
            LOG.info("Exception while notifying listener " + listener, x);
            throw x;
        }
    }

    private void notifyOnGoAway(SessionFrameListener listener, GoAwayResultInfo goAwayResultInfo) {
        try {
            if (listener != null) {
                LOG.debug("Invoking callback with {} on listener {}", goAwayResultInfo, listener);
                listener.onGoAway(this, goAwayResultInfo);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
        catch (Error x) {
            LOG.info("Exception while notifying listener " + listener, x);
            throw x;
        }
    }

    @Override
    public void control(IStream stream, ControlFrame frame, long timeout, TimeUnit unit, Callback callback) {
        this.generateAndEnqueueControlFrame(stream, frame, timeout, unit, callback);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAndEnqueueControlFrame(IStream stream, ControlFrame frame, long timeout, TimeUnit unit, Callback callback) {
        try {
            StandardSession standardSession = this;
            synchronized (standardSession) {
                ByteBuffer buffer = this.generator.control(frame);
                LOG.debug("Queuing {} on {}", frame, stream);
                ControlFrameBytes frameBytes = new ControlFrameBytes(stream, callback, frame, buffer);
                if (timeout > 0L) {
                    frameBytes.task = this.scheduler.schedule(frameBytes, timeout, unit);
                }
                if (ControlFrameType.PING == frame.getType()) {
                    this.prepend(frameBytes);
                } else {
                    this.append(frameBytes);
                }
            }
        }
        catch (Exception x) {
            this.notifyCallbackFailed(callback, x);
        }
    }

    private void updateLastStreamId(IStream stream) {
        int streamId = stream.getId();
        if (streamId % 2 != this.streamIds.get() % 2) {
            Atomics.updateMax(this.lastStreamId, streamId);
        }
    }

    @Override
    public void data(IStream stream, DataInfo dataInfo, long timeout, TimeUnit unit, Callback callback) {
        LOG.debug("Queuing {} on {}", dataInfo, stream);
        DataFrameBytes frameBytes = new DataFrameBytes(stream, callback, dataInfo);
        if (timeout > 0L) {
            frameBytes.task = this.scheduler.schedule(frameBytes, timeout, unit);
        }
        this.append(frameBytes);
        this.flush();
    }

    @Override
    public void shutdown() {
        CloseFrameBytes frameBytes = new CloseFrameBytes();
        this.append(frameBytes);
        this.flush();
    }

    private void execute(Runnable task) {
        this.threadPool.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        FrameBytes frameBytes = null;
        ByteBuffer buffer = null;
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.flushing || this.queue.isEmpty()) {
                return;
            }
            HashSet<IStream> stalledStreams = null;
            for (int i = 0; i < this.queue.size(); ++i) {
                frameBytes = this.queue.get(i);
                IStream stream = frameBytes.getStream();
                if (stream != null && stalledStreams != null && stalledStreams.contains(stream)) continue;
                buffer = frameBytes.getByteBuffer();
                if (buffer != null) {
                    this.queue.remove(i);
                    if (stream == null || !stream.isReset() || frameBytes instanceof ControlFrameBytes) break;
                    frameBytes.fail(new StreamException(stream.getId(), StreamStatus.INVALID_STREAM, "Stream: " + stream + " is reset!"));
                    return;
                }
                if (stalledStreams == null) {
                    stalledStreams = new HashSet<IStream>();
                }
                if (stream != null) {
                    stalledStreams.add(stream);
                }
                LOG.debug("Flush stalled for {}, {} frame(s) in queue", frameBytes, this.queue.size());
            }
            if (buffer == null) {
                return;
            }
            this.flushing = true;
            LOG.debug("Flushing {}, {} frame(s) in queue", frameBytes, this.queue.size());
        }
        this.write(buffer, frameBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(FrameBytes frameBytes) {
        Throwable failure;
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            failure = this.failure;
            if (failure == null) {
                if (frameBytes instanceof ControlFrameBytes) {
                    this.queue.addLast(frameBytes);
                } else {
                    FrameBytes element;
                    int index;
                    for (index = this.queue.size(); index > 0 && (element = this.queue.get(index - 1)).compareTo(frameBytes) < 0; --index) {
                    }
                    this.queue.add(index, frameBytes);
                }
            }
        }
        if (failure != null) {
            frameBytes.fail(new SPDYException(failure));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepend(FrameBytes frameBytes) {
        Throwable failure;
        LinkedList<FrameBytes> linkedList = this.queue;
        synchronized (linkedList) {
            failure = this.failure;
            if (failure == null) {
                FrameBytes element;
                int index;
                for (index = 0; index < this.queue.size() && (element = this.queue.get(index)).compareTo(frameBytes) > 0; ++index) {
                }
                this.queue.add(index, frameBytes);
            }
        }
        if (failure != null) {
            frameBytes.fail(new SPDYException(failure));
        }
    }

    protected void write(ByteBuffer buffer, Callback callback) {
        if (this.controller != null) {
            LOG.debug("Writing {} frame bytes of {}", buffer.remaining(), buffer.limit());
            this.controller.write(buffer, callback);
        }
    }

    private void complete(Callback callback) {
        this.invoker.invoke(callback);
    }

    private void notifyCallbackFailed(Callback callback, Throwable x) {
        try {
            if (callback != null) {
                callback.failed(x);
            }
        }
        catch (Exception xx) {
            LOG.info("Exception while notifying callback " + callback, xx);
        }
        catch (Error xx) {
            LOG.info("Exception while notifying callback " + callback, xx);
            throw xx;
        }
    }

    public int getWindowSize() {
        return this.flowControlStrategy.getWindowSize(this);
    }

    public void setWindowSize(int initialWindowSize) {
        this.flowControlStrategy.setWindowSize(this, initialWindowSize);
    }

    public String toString() {
        return String.format("%s@%x{v%d,queueSize=%d,windowSize=%d,streams=%d}", this.getClass().getSimpleName(), this.hashCode(), this.version, this.queue.size(), this.getWindowSize(), this.streams.size());
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject(out, this);
        ContainerLifeCycle.dump(out, indent, Collections.singletonList(this.controller), this.streams.values());
    }

    private static class PingInfoCallback
    extends PingResultInfo
    implements Callback {
        private final Promise<PingResultInfo> promise;

        public PingInfoCallback(int pingId, Promise<PingResultInfo> promise) {
            super(pingId);
            this.promise = promise;
        }

        @Override
        public void succeeded() {
            if (this.promise != null) {
                this.promise.succeeded(this);
            }
        }

        @Override
        public void failed(Throwable x) {
            if (this.promise != null) {
                this.promise.failed(x);
            }
        }
    }

    private class CloseFrameBytes
    extends AbstractFrameBytes {
        private CloseFrameBytes() {
            super(null, new Callback.Adapter());
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return BufferUtil.EMPTY_BUFFER;
        }

        @Override
        public void complete() {
            super.complete();
            StandardSession.this.close();
        }
    }

    private class DataFrameBytes
    extends AbstractFrameBytes {
        private final DataInfo dataInfo;
        private int size;
        private volatile ByteBuffer buffer;

        private DataFrameBytes(IStream stream, Callback handler, DataInfo dataInfo) {
            super(stream, handler);
            this.dataInfo = dataInfo;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            try {
                IStream stream = this.getStream();
                int windowSize = stream.getWindowSize();
                if (windowSize <= 0) {
                    return null;
                }
                this.size = this.dataInfo.available();
                if (this.size > windowSize) {
                    this.size = windowSize;
                }
                this.buffer = StandardSession.this.generator.data(stream.getId(), this.size, this.dataInfo);
                return this.buffer;
            }
            catch (Throwable x) {
                this.fail(x);
                return null;
            }
        }

        @Override
        public void complete() {
            StandardSession.this.bufferPool.release(this.buffer);
            IStream stream = this.getStream();
            this.dataInfo.consume(this.size);
            StandardSession.this.flowControlStrategy.updateWindow(StandardSession.this, stream, -this.size);
            if (this.dataInfo.available() > 0) {
                StandardSession.this.prepend(this);
                StandardSession.this.flush();
            } else {
                super.complete();
                stream.updateCloseState(this.dataInfo.isClose(), true);
                if (stream.isClosed()) {
                    StandardSession.this.removeStream(stream);
                }
            }
        }

        public String toString() {
            return String.format("DATA bytes @%x available=%d consumed=%d on %s", this.dataInfo.hashCode(), this.dataInfo.available(), this.dataInfo.consumed(), this.getStream());
        }
    }

    private class ControlFrameBytes
    extends AbstractFrameBytes {
        private final ControlFrame frame;
        private final ByteBuffer buffer;

        private ControlFrameBytes(IStream stream, Callback callback, ControlFrame frame, ByteBuffer buffer) {
            super(stream, callback);
            this.frame = frame;
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.buffer;
        }

        @Override
        public void complete() {
            IStream stream;
            StandardSession.this.bufferPool.release(this.buffer);
            super.complete();
            if (this.frame.getType() == ControlFrameType.GO_AWAY) {
                StandardSession.this.close();
            }
            if ((stream = this.getStream()) != null && stream.isClosed()) {
                StandardSession.this.removeStream(stream);
            }
        }

        public String toString() {
            return this.frame.toString();
        }
    }

    private abstract class AbstractFrameBytes
    implements FrameBytes,
    Runnable {
        private final IStream stream;
        private final Callback callback;
        protected volatile Scheduler.Task task;

        protected AbstractFrameBytes(IStream stream, Callback callback) {
            this.stream = stream;
            this.callback = Objects.requireNonNull(callback);
        }

        @Override
        public IStream getStream() {
            return this.stream;
        }

        @Override
        public int compareTo(FrameBytes that) {
            IStream thisStream = this.getStream();
            IStream thatStream = that.getStream();
            if (thisStream == null) {
                return thatStream == null ? 0 : -1;
            }
            if (thatStream == null) {
                return 1;
            }
            return thatStream.getPriority() - thisStream.getPriority();
        }

        @Override
        public void complete() {
            this.cancelTask();
            StandardSession.this.complete(this.callback);
        }

        @Override
        public void fail(Throwable x) {
            this.cancelTask();
            StandardSession.this.notifyCallbackFailed(this.callback, x);
            StandardSession.this.flush();
        }

        private void cancelTask() {
            Scheduler.Task task = this.task;
            if (task != null) {
                task.cancel();
            }
        }

        @Override
        public void run() {
            StandardSession.this.close();
            this.fail(new InterruptedByTimeoutException());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void succeeded() {
            LinkedList linkedList = StandardSession.this.queue;
            synchronized (linkedList) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Completed write of {}, {} frame(s) in queue", this, StandardSession.this.queue.size());
                }
                StandardSession.this.flushing = false;
            }
            this.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable x) {
            ArrayList<AbstractFrameBytes> frameBytesToFail = new ArrayList<AbstractFrameBytes>();
            frameBytesToFail.add(this);
            LinkedList linkedList = StandardSession.this.queue;
            synchronized (linkedList) {
                StandardSession.this.failure = x;
                if (LOG.isDebugEnabled()) {
                    String string = String.format("Failed write of %s, failing all %d frame(s) in queue", this, StandardSession.this.queue.size());
                    LOG.debug(string, x);
                }
                frameBytesToFail.addAll(StandardSession.this.queue);
                StandardSession.this.queue.clear();
                StandardSession.this.flushing = false;
            }
            for (FrameBytes frameBytes : frameBytesToFail) {
                frameBytes.fail(x);
            }
        }
    }

    public static interface FrameBytes
    extends Comparable<FrameBytes>,
    Callback {
        public IStream getStream();

        public ByteBuffer getByteBuffer();

        public void complete();

        public void fail(Throwable var1);
    }

    private class SessionInvoker
    extends ForkInvoker<Callback> {
        private SessionInvoker() {
            super(4);
        }

        @Override
        public void fork(final Callback callback) {
            StandardSession.this.execute(new Runnable(){

                @Override
                public void run() {
                    callback.succeeded();
                    StandardSession.this.flush();
                }
            });
        }

        @Override
        public void call(Callback callback) {
            callback.succeeded();
            StandardSession.this.flush();
        }
    }
}

