/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class ServletWebSocketRequest
extends UpgradeRequest {
    private Map<String, String> cookieMap;
    private HttpServletRequest req;

    public ServletWebSocketRequest(HttpServletRequest request) {
        super(request.getRequestURI());
        this.req = request;
        this.setMethod(request.getMethod());
        this.setHttpVersion(request.getProtocol());
        super.setParameterMap(request.getParameterMap());
        this.cookieMap = new HashMap<String, String>();
        for (Cookie cookie : request.getCookies()) {
            this.cookieMap.put(cookie.getName(), cookie.getValue());
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration valuesEnum = request.getHeaders(name);
            ArrayList<String> values = new ArrayList<String>();
            while (valuesEnum.hasMoreElements()) {
                values.add((String)valuesEnum.nextElement());
            }
            this.setHeader(name, values);
        }
        Enumeration protocols = request.getHeaders("Sec-WebSocket-Protocol");
        ArrayList<String> subProtocols = new ArrayList<String>();
        Object protocol = null;
        while (protocol == null && protocols != null && protocols.hasMoreElements()) {
            String candidate = (String)protocols.nextElement();
            for (String p : this.parseProtocols(candidate)) {
                subProtocols.add(p);
            }
        }
        this.setSubProtocols(subProtocols);
        Enumeration e = request.getHeaders("Sec-WebSocket-Extensions");
        while (e.hasMoreElements()) {
            Iterator<String> extTokenIter = QuoteUtil.splitAt((String)e.nextElement(), ",");
            while (extTokenIter.hasNext()) {
                String extToken = extTokenIter.next();
                ExtensionConfig config = ExtensionConfig.parse(extToken);
                this.addExtensions(config);
            }
        }
    }

    public Principal getPrincipal() {
        return this.req.getUserPrincipal();
    }

    public StringBuffer getRequestURL() {
        return this.req.getRequestURL();
    }

    public Map<String, Object> getServletAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String name : Collections.list(this.req.getAttributeNames())) {
            attributes.put(name, this.req.getAttribute(name));
        }
        return attributes;
    }

    public Map<String, List<String>> getServletParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (String name : Collections.list(this.req.getParameterNames())) {
            parameters.put(name, Collections.unmodifiableList(Arrays.asList(this.req.getParameterValues(name))));
        }
        return parameters;
    }

    @Override
    public Object getSession() {
        return this.req.getSession();
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    public void setServletAttribute(String name, Object o) {
        this.req.setAttribute(name, o);
    }
}

