/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;

public class ContainerInitializerConfiguration
extends AbstractConfiguration {
    public static final String CONTAINER_INITIALIZERS = "org.eclipse.jetty.containerInitializers";

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        List initializers = (List)context.getAttribute(CONTAINER_INITIALIZERS);
        MultiMap classMap = (MultiMap)context.getAttribute("org.eclipse.jetty.classInheritanceMap");
        if (initializers != null) {
            for (ContainerInitializer i : initializers) {
                if (i.getAnnotatedTypeNames() != null) {
                    HashSet<String> annotatedClassNames = new HashSet<String>(i.getAnnotatedTypeNames());
                    for (String name : annotatedClassNames) {
                        i.addApplicableTypeName(name);
                        List implementsOrExtends = classMap.getValues(name);
                        if (implementsOrExtends == null || implementsOrExtends.isEmpty()) continue;
                        this.addInheritedTypes(classMap, i, implementsOrExtends);
                    }
                }
                if (i.getInterestedTypes() != null) {
                    for (Class c : i.getInterestedTypes()) {
                        List implementsOrExtends;
                        if (c.isAnnotation() || (implementsOrExtends = classMap.getValues(c.getName())) == null || implementsOrExtends.isEmpty()) continue;
                        this.addInheritedTypes(classMap, i, implementsOrExtends);
                    }
                }
                i.callStartup(context);
            }
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
    }

    void addInheritedTypes(MultiMap classMap, ContainerInitializer initializer, List<String> applicableTypes) {
        for (String s : applicableTypes) {
            initializer.addApplicableTypeName(s);
            List implementsOrExtends = classMap.getValues(s);
            if (implementsOrExtends == null || implementsOrExtends.isEmpty()) continue;
            this.addInheritedTypes(classMap, initializer, implementsOrExtends);
        }
    }
}

